/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.data.query.CriteriaItem;
import com.diboot.core.data.query.QueryCondition;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.D;
import com.diboot.core.util.S;
import com.diboot.core.vo.Status;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

public class V {
    private static final Logger log = LoggerFactory.getLogger(V.class);
    private static Validator VALIDATOR = null;
    private static final Pattern SQL_INJECT_PATTERN = Pattern.compile("(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)", 2);
    private static final Pattern PATTERN = Pattern.compile("^[0-9A-Za-z_][\\w.:]*$");
    private static final Set<String> TRUE_SET = new HashSet<String>(Arrays.asList("true", "\u662f", "y", "yes", "1"));
    private static final Set<String> FALSE_SET = new HashSet<String>(Arrays.asList("false", "\u5426", "n", "no", "0"));

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return V.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return V.isEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return V.isEmpty((Map)obj);
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence value) {
        return S.isBlank((CharSequence)value);
    }

    public static boolean isEmpty(String value) {
        return S.isBlank((CharSequence)value);
    }

    public static <T> boolean isEmpty(Collection<T> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isEmpty(String[] values) {
        return values == null || values.length == 0;
    }

    public static <T, F> boolean isEmpty(Map<T, F> obj) {
        return obj == null || obj.isEmpty();
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean notEmpty(boolean[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(byte[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(char[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(double[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(float[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(int[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(long[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(short[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(Object[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isAnyEmpty(Object ... objs) {
        if (V.isEmpty(objs)) {
            return true;
        }
        for (Object obj : objs) {
            if (!V.isEmpty(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneEmpty(Object ... objs) {
        return !V.isAnyEmpty(objs);
    }

    public static boolean isAllEmpty(Object ... objs) {
        if (V.isEmpty(objs)) {
            return true;
        }
        for (Object obj : objs) {
            if (!V.notEmpty(obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean notEmpty(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CharSequence) {
            return V.notEmpty((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return V.notEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return V.notEmpty((Map)obj);
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) != 0;
        }
        return true;
    }

    public static boolean notEmpty(CharSequence value) {
        return S.isNotBlank((CharSequence)value);
    }

    public static boolean notEmpty(String value) {
        return S.isNotBlank((CharSequence)value);
    }

    public static boolean notEmpty(String[] values) {
        return values != null && values.length > 0;
    }

    public static <T> boolean notEmpty(Collection<T> list) {
        return list != null && !list.isEmpty();
    }

    public static <T, F> boolean notEmpty(Map<T, F> obj) {
        return obj != null && !obj.isEmpty();
    }

    public static boolean notEmptyOrZero(Long longObj) {
        return longObj != null && longObj != 0L;
    }

    public static boolean notEmptyOrZero(Integer intObj) {
        return intObj != null && intObj != 0;
    }

    public static <T> boolean contains(Collection<T> collection, T target) {
        return collection != null && collection.contains(target);
    }

    public static boolean containsIgnoreCase(Collection<String> collection, String target) {
        return collection != null && (collection.contains(target) || collection.contains(target.toLowerCase()) || collection.contains(target.toUpperCase()));
    }

    public static <T> boolean notContains(Collection<T> collection, T target) {
        return collection != null && !collection.contains(target);
    }

    public static boolean notContainsIgnoreCase(Collection<String> collection, String target) {
        return !V.containsIgnoreCase(collection, target);
    }

    public static boolean isNumber(String str) {
        String regex = "^(-?[1-9]\\d*\\.?\\d*)|(-?0\\.\\d*[1-9])|(-?[0])|(-?[0]\\.\\d*)$";
        return str.matches(regex);
    }

    public static boolean isEmail(String str) {
        if (V.isEmpty(str)) {
            return false;
        }
        return str.matches("^[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)+$");
    }

    public static boolean isPhone(String str) {
        if (V.isEmpty(str)) {
            return false;
        }
        boolean valid = str.matches("^1\\d{10}$");
        if (!valid) {
            valid = str.matches("^[0|4]\\d{2,3}-?\\d{7,8}$");
        }
        return valid;
    }

    public static void securityCheck(String ... paramValues) {
        if (V.isEmpty(paramValues)) {
            return;
        }
        for (String param : paramValues) {
            if (V.isValidSqlParam(param)) continue;
            throw new BusinessException(Status.FAIL_VALIDATION, "\u975e\u6cd5\u7684\u53c2\u6570: " + param, new Object[0]);
        }
    }

    public static void securityCheck(Object ... paramValues) {
        if (V.isEmpty(paramValues)) {
            return;
        }
        for (Object param : paramValues) {
            if (V.isValidSqlParam(param)) continue;
            throw new BusinessException(Status.FAIL_VALIDATION, "\u975e\u6cd5\u7684\u53c2\u6570: " + param, new Object[0]);
        }
    }

    public static void securityCheck(QueryCondition queryCondition) throws BusinessException {
        if (V.isEmpty(queryCondition.getCriteriaList())) {
            return;
        }
        for (CriteriaItem entry : queryCondition.getCriteriaList()) {
            String value;
            V.securityCheck(entry.getField());
            if (entry.getValue() == null || !(entry.getValue() instanceof String) || !SQL_INJECT_PATTERN.matcher((value = (String)entry.getValue()).toLowerCase()).find()) continue;
            log.warn("\u975e\u6cd5\u7684\u53c2\u6570\u503c: {}", entry.getValue());
            throw new BusinessException(Status.FAIL_VALIDATION, "\u975e\u6cd5\u7684\u53c2\u6570\u503c: {}", entry.getValue());
        }
    }

    public static boolean isValidSqlParam(Object sqlParam) {
        if (V.isEmpty(sqlParam)) {
            return true;
        }
        if (sqlParam instanceof Collection) {
            Collection collection = (Collection)sqlParam;
            for (Object param : collection) {
                boolean valid = V.isValidSqlParam(param);
                if (valid) continue;
                log.debug("\u4e0d\u7b26\u5408\u5b89\u5168\u89c4\u8303\u7684\u53c2\u6570: {}", (Object)S.valueOf(param));
                return false;
            }
            return true;
        }
        if (sqlParam.getClass().isArray()) {
            Object[] paramArray;
            for (Object param : paramArray = (Object[])sqlParam) {
                boolean valid = V.isValidSqlParam(param);
                if (valid) continue;
                log.debug("\u4e0d\u7b26\u5408\u5b89\u5168\u89c4\u8303\u7684\u53c2\u6570: {}", (Object)S.valueOf(param));
                return false;
            }
            return true;
        }
        if (sqlParam instanceof Map) {
            boolean valid;
            Map map = (Map)sqlParam;
            for (Object key : map.keySet()) {
                valid = V.isValidSqlParam(key);
                if (valid) continue;
                log.debug("\u4e0d\u7b26\u5408\u5b89\u5168\u89c4\u8303\u7684\u53c2\u6570: {}", (Object)S.valueOf(key));
                return false;
            }
            for (Object val : map.values()) {
                valid = V.isValidSqlParam(val);
                if (valid) continue;
                log.debug("\u4e0d\u7b26\u5408\u5b89\u5168\u89c4\u8303\u7684\u53c2\u6570: {}", (Object)S.valueOf(val));
                return false;
            }
            return true;
        }
        return PATTERN.matcher(S.valueOf(sqlParam)).matches();
    }

    public static boolean isValidBoolean(String value) {
        if (value == null) {
            return false;
        }
        return TRUE_SET.contains(value = S.trim((String)value).toLowerCase()) || FALSE_SET.contains(value);
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        value = S.trim((String)value).toLowerCase();
        return TRUE_SET.contains(value);
    }

    public static boolean isFalse(boolean expression) {
        return !expression;
    }

    @Deprecated
    public static String validate(String value, String validation) {
        String[] rules;
        if (V.isEmpty(validation)) {
            return null;
        }
        ArrayList<String> errorMsgList = new ArrayList<String>();
        for (String rule : rules = validation.split(",")) {
            if ("NotNull".equalsIgnoreCase(rule)) {
                if (!V.isEmpty(value)) continue;
                errorMsgList.add("\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if ("Number".equalsIgnoreCase(rule)) {
                if (V.isNumber(value)) continue;
                errorMsgList.add("\u975e\u6570\u5b57\u683c\u5f0f");
                continue;
            }
            if ("Boolean".equalsIgnoreCase(rule)) {
                if (V.isValidBoolean(value)) continue;
                errorMsgList.add("\u975eBoolean\u683c\u5f0f");
                continue;
            }
            if ("Date".equalsIgnoreCase(rule)) {
                if (D.fuzzyConvert(value) != null) continue;
                errorMsgList.add("\u975e\u65e5\u671f\u683c\u5f0f");
                continue;
            }
            if (rule.toLowerCase().startsWith("length")) {
                String range = rule.substring(rule.indexOf("(") + 1, rule.lastIndexOf(")"));
                if (range.contains("-")) {
                    String[] arr = range.split("-");
                    if (V.notEmpty(arr[0]) && (V.isEmpty(value) || value.length() < Integer.parseInt(arr[0]))) {
                        errorMsgList.add("\u957f\u5ea6\u5c11\u4e8e\u6700\u5c0f\u9650\u5236\u6570: " + arr[0]);
                    }
                    if (!V.notEmpty(arr[1]) || !V.notEmpty(value) || value.length() <= Integer.parseInt(arr[1])) continue;
                    errorMsgList.add("\u957f\u5ea6\u8d85\u51fa\u6700\u5927\u9650\u5236\u6570: " + arr[1]);
                    continue;
                }
                if (!V.isEmpty(value) && value.length() == Integer.parseInt(range)) continue;
                errorMsgList.add("\u957f\u5ea6\u9650\u5236: " + range + "\u4f4d");
                continue;
            }
            if ("Email".equalsIgnoreCase(rule)) {
                if (V.isEmail(value)) continue;
                errorMsgList.add("\u975eEmail\u683c\u5f0f");
                continue;
            }
            if (!"Phone".equalsIgnoreCase(rule) || V.isPhone(value)) continue;
            errorMsgList.add("\u975e\u7535\u8bdd\u53f7\u7801\u683c\u5f0f");
        }
        if (errorMsgList.isEmpty()) {
            return null;
        }
        return S.join(errorMsgList);
    }

    public static boolean notEquals(Object source, Object target) {
        return !V.equals(source, target);
    }

    public static <T> boolean equals(T source, T target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (!(source.getClass() == target.getClass() || source instanceof Map && target instanceof Map)) {
            log.warn("source\u548ctarget\u7c7b\u578b\u4e0d\u5339\u914d\uff1a" + source.getClass() + " \u548c " + target.getClass());
            return false;
        }
        if (source instanceof Class) {
            return ((Class)source).getName().equals(((Class)target).getName());
        }
        if (source instanceof Comparable) {
            return ((Comparable)source).compareTo(target) == 0;
        }
        if (source instanceof Collection) {
            Collection sourceList = (Collection)source;
            Collection targetList = (Collection)target;
            if (sourceList.size() != targetList.size()) {
                return false;
            }
            if (sourceList.isEmpty()) {
                return true;
            }
            if (source instanceof Set) {
                return ((Set)source).containsAll(targetList);
            }
            CardinalityHelper helper = new CardinalityHelper(sourceList, targetList);
            if (helper.cardinalityA.size() != helper.cardinalityB.size()) {
                return false;
            }
            for (Object obj : helper.cardinalityA.keySet()) {
                if (helper.freqA(obj) == helper.freqB(obj)) continue;
                return false;
            }
            return true;
        }
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            Map targetMap = (Map)target;
            if (sourceMap.size() != targetMap.size()) {
                return false;
            }
            if (sourceMap.isEmpty()) {
                return true;
            }
            for (Map.Entry entry : sourceMap.entrySet()) {
                if (V.equals(entry.getValue(), targetMap.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        log.warn("\u6682\u672a\u5b9e\u73b0\u7c7b\u578b " + source.getClass().getName() + "-" + target.getClass().getName() + " \u7684\u6bd4\u5bf9\uff01");
        return false;
    }

    @SafeVarargs
    public static <T> boolean anyEquals(T source, T ... others) {
        if (V.isEmpty(others)) {
            return false;
        }
        for (T other : others) {
            if (!V.equals(source, other)) continue;
            return true;
        }
        return false;
    }

    public static boolean fuzzyEqual(Object source, Object target) {
        if (V.equals(source, target)) {
            return true;
        }
        if (source instanceof Boolean && target instanceof String) {
            return (Boolean)source == V.isTrue((String)target);
        }
        if (target instanceof Boolean && source instanceof String) {
            return (Boolean)target == V.isTrue((String)source);
        }
        if (source instanceof Date && target instanceof String) {
            return D.getDateTime((Date)source, new int[0]).equals(target) || D.getDate((Date)source, new int[0]).equals(target);
        }
        if (target instanceof Date && source instanceof String) {
            return D.getDateTime((Date)target, new int[0]).equals(source) || D.getDate((Date)target, new int[0]).equals(source);
        }
        return S.valueOf(source).equals(S.valueOf(target));
    }

    public static String getBindingError(BindingResult result) {
        if (result == null || !result.hasErrors()) {
            return null;
        }
        List errors = result.getAllErrors();
        ArrayList<String> allErrors = new ArrayList<String>(errors.size());
        for (ObjectError error : errors) {
            String defaultMessage = error.getDefaultMessage();
            if (!V.notEmpty(defaultMessage)) continue;
            allErrors.add(defaultMessage.replaceAll("\"", "'"));
        }
        return S.join(allErrors);
    }

    public static <T> Set<ConstraintViolation<T>> validateBean(T obj, Class<?> ... groups) {
        if (VALIDATOR == null) {
            VALIDATOR = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory().getValidator();
        }
        return VALIDATOR.validate(obj, (Class[])groups);
    }

    public static <T> String validateBeanErrMsg(T obj, Class<?> ... groups) {
        Set<ConstraintViolation<T>> errors = V.validateBean(obj, groups);
        if (V.isEmpty(errors)) {
            return null;
        }
        ArrayList<String> allErrors = new ArrayList<String>(errors.size());
        for (ConstraintViolation<T> err : errors) {
            allErrors.add(err.getMessage());
        }
        return S.join(allErrors);
    }

    private static class CardinalityHelper<O> {
        final Map<O, Integer> cardinalityA;
        final Map<O, Integer> cardinalityB;

        CardinalityHelper(Iterable<? extends O> a, Iterable<? extends O> b) {
            this.cardinalityA = CardinalityHelper.getCardinalityMap(a);
            this.cardinalityB = CardinalityHelper.getCardinalityMap(b);
        }

        public static <O> Map<O, Integer> getCardinalityMap(Iterable<? extends O> coll) {
            Objects.requireNonNull(coll, "coll");
            HashMap<O, Integer> count = new HashMap<O, Integer>();
            for (O obj : coll) {
                count.merge(obj, 1, Integer::sum);
            }
            return count;
        }

        public final int max(Object obj) {
            return Math.max(this.freqA(obj), this.freqB(obj));
        }

        public final int min(Object obj) {
            return Math.min(this.freqA(obj), this.freqB(obj));
        }

        public int freqA(Object obj) {
            return this.getFreq(obj, this.cardinalityA);
        }

        public int freqB(Object obj) {
            return this.getFreq(obj, this.cardinalityB);
        }

        private int getFreq(Object obj, Map<?, Integer> freqMap) {
            Integer count = freqMap.get(obj);
            if (count != null) {
                return count;
            }
            return 0;
        }
    }
}

