/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.SqlExecutor;
import com.diboot.core.util.V;
import com.diboot.core.util.sql.DMTranslator;
import com.diboot.core.util.sql.OracleTranslator;
import com.diboot.core.util.sql.PostgresSqlTranslator;
import com.diboot.core.util.sql.SqlServerTranslator;
import com.diboot.core.util.sql.SqliteTranslator;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFileInitializer {
    private static final Logger log = LoggerFactory.getLogger(SqlFileInitializer.class);

    public static String getBootstrapSqlPath(String module) {
        return "META-INF/sql/init-" + module + "-mysql.sql";
    }

    public static void initBootstrapSql(Class inst, String module) {
        String mysqlPath = SqlFileInitializer.getBootstrapSqlPath(module);
        SqlFileInitializer.extractAndExecuteSqls(inst, mysqlPath);
    }

    public static boolean checkSqlExecutable(String sqlStatement) {
        sqlStatement = SqlFileInitializer.buildPureSqlStatement(sqlStatement);
        return SqlExecutor.validateQuery(sqlStatement);
    }

    public static List<String> extractSqlStatements(Class inst, String sqlPath) {
        List<String> sqlFileReadLines = SqlFileInitializer.readLinesFromResource(inst, sqlPath);
        if (V.isEmpty(sqlFileReadLines)) {
            return Collections.emptyList();
        }
        List<String> sqlStatements = SqlFileInitializer.extractSqlStatements(sqlFileReadLines);
        String dbType = SqlFileInitializer.getDbType();
        if (DbType.MYSQL.getDb().equalsIgnoreCase(dbType) || DbType.MARIADB.getDb().equalsIgnoreCase(dbType)) {
            return sqlStatements;
        }
        if (DbType.POSTGRE_SQL.getDb().equalsIgnoreCase(dbType) || DbType.KINGBASE_ES.getDb().equalsIgnoreCase(dbType)) {
            return new PostgresSqlTranslator().translate(sqlStatements);
        }
        if (DbType.SQL_SERVER.getDb().equalsIgnoreCase(dbType)) {
            return new SqlServerTranslator().translate(sqlStatements);
        }
        if (DbType.DM.getDb().equalsIgnoreCase(dbType)) {
            return new DMTranslator().translate(sqlStatements);
        }
        if (dbType.startsWith(DbType.ORACLE.getDb())) {
            return new OracleTranslator().translate(sqlStatements);
        }
        if (DbType.SQLITE.getDb().equals(dbType)) {
            return new SqliteTranslator().translate(sqlStatements);
        }
        throw new InvalidUsageException("\u6682\u4e0d\u652f\u6301 {} \u6570\u636e\u5e93\u81ea\u52a8\u521d\u59cb\u5316", dbType);
    }

    public static boolean extractAndExecuteSqls(Class inst, String sqlPath) {
        List<String> sqlStatementList = SqlFileInitializer.extractSqlStatements(inst, sqlPath);
        if (V.isEmpty(sqlStatementList)) {
            return false;
        }
        return SqlFileInitializer.executeMultipleUpdateSqls(sqlStatementList);
    }

    public static List<String> extractSqlStatements(List<String> sqlFileReadLines) {
        ArrayList<String> sqlStatementList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String line : sqlFileReadLines) {
            if (line.contains("--")) {
                line = line.substring(0, line.indexOf("--"));
            }
            sb.append(" ");
            if (line.contains(";")) {
                String leftSql;
                sb.append(line.substring(0, line.indexOf(";")));
                String cleanSql = SqlFileInitializer.buildPureSqlStatement(sb.toString());
                sqlStatementList.add(cleanSql);
                sb.setLength(0);
                if (line.indexOf(";") >= line.length() - 1 || !V.notEmpty(leftSql = line.substring(line.indexOf(";") + 1))) continue;
                sb.append(leftSql);
                continue;
            }
            if (!V.notEmpty(line)) continue;
            sb.append(line);
        }
        if (sb.length() > 0) {
            String cleanSql = SqlFileInitializer.buildPureSqlStatement(sb.toString());
            sqlStatementList.add(cleanSql);
            sb.setLength(0);
        }
        return sqlStatementList;
    }

    public static String buildPureSqlStatement(String sqlStatement) {
        if ((sqlStatement = SqlFileInitializer.clearComments(sqlStatement)).contains("${SCHEMA}")) {
            String schema = SqlExecutor.getDatabase();
            sqlStatement = V.isEmpty(schema) ? S.replace((String)sqlStatement, (String)"${SCHEMA}.", (String)"") : S.replace((String)sqlStatement, (String)"${SCHEMA}", (String)schema);
        }
        return sqlStatement;
    }

    public static boolean executeMultipleUpdateSqls(List<String> sqlStatementList) {
        if (V.isEmpty(sqlStatementList)) {
            return false;
        }
        for (String sqlStatement : sqlStatementList) {
            try {
                boolean success = SqlExecutor.executeUpdate(sqlStatement, null);
                if (!success) continue;
                log.info("SQL\u6267\u884c\u5b8c\u6210: " + S.substring((String)sqlStatement, (int)0, (int)60) + "...");
            }
            catch (Exception e) {
                log.error("SQL\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6216\u624b\u52a8\u6267\u884c\u3002SQL => {}", (Object)sqlStatement, (Object)e);
            }
        }
        return true;
    }

    public static boolean executeMultipleUpdateSqlsWithTransaction(List<String> sqlStatementList) throws Exception {
        if (V.isEmpty(sqlStatementList)) {
            return false;
        }
        SqlSessionFactory sqlSessionFactory = ContextHolder.getBean(SqlSessionFactory.class);
        if (sqlSessionFactory == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6SqlSessionFactory\u5b9e\u4f8b\uff0cSQL\u5c06\u4e0d\u88ab\u6267\u884c\u3002");
            return false;
        }
        SqlSession session = SqlSessionUtils.getSqlSession((SqlSessionFactory)sqlSessionFactory);
        Connection conn = session.getConnection();
        try {
            for (String sqlStatement : sqlStatementList) {
                PreparedStatement stmt = conn.prepareStatement(sqlStatement);
                stmt.execute();
                stmt.close();
            }
            return true;
        }
        catch (Exception e) {
            log.error("SQL\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff1a{}", sqlStatementList, (Object)e);
            if (conn != null) {
                conn.rollback();
            }
            throw e;
        }
    }

    public static List<String> readLinesFromResource(Class inst, String sqlPath) {
        List<String> lines = null;
        try {
            InputStream is = inst.getClassLoader().getResourceAsStream(sqlPath);
            lines = S.readLines(is, "UTF-8");
        }
        catch (FileNotFoundException fe) {
            log.warn("\u6682\u672a\u53d1\u73b0\u6570\u636e\u5e93SQL: {}\uff0c \u8bf7\u53c2\u8003\u5176\u4ed6\u6570\u636e\u5e93\u5b9a\u4e49DDL\u624b\u52a8\u521d\u59cb\u5316\u3002", (Object)sqlPath);
        }
        catch (Exception e) {
            log.warn("\u8bfb\u53d6SQL\u6587\u4ef6\u5f02\u5e38: {}", (Object)sqlPath, (Object)e);
        }
        return lines;
    }

    public static String clearComments(String inputSql) {
        String[] sqlRows = inputSql.split("\\n");
        ArrayList<String> cleanSql = new ArrayList<String>();
        for (String row : sqlRows) {
            if (row.contains("--")) {
                row = row.substring(0, row.indexOf("--"));
            }
            if (!V.notEmpty(row.trim())) continue;
            cleanSql.add(row);
        }
        inputSql = S.join(cleanSql, (String)" ");
        inputSql = SqlFileInitializer.removeMultipleLineComments(inputSql);
        return inputSql.replaceAll("\r|\n", " ");
    }

    private static String removeMultipleLineComments(String inputSql) {
        if (inputSql.contains("*/*")) {
            return inputSql;
        }
        if (inputSql.contains("/*") && inputSql.contains("*/")) {
            inputSql = inputSql.substring(0, inputSql.indexOf("/*")) + inputSql.substring(inputSql.indexOf("*/") + 2);
        }
        if (inputSql.contains("/*") && inputSql.contains("*/")) {
            return SqlFileInitializer.removeMultipleLineComments(inputSql);
        }
        return inputSql;
    }

    public static String getDbType() {
        return ContextHolder.getDatabaseType();
    }
}

