/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.config.BaseConfig;
import com.diboot.core.util.V;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class S
extends StringUtils {
    public static final String SEPARATOR = ",";
    private static final String[] SEARCH_LIST = new String[]{"[", "]", "\"", "'"};
    private static final String[] REPLACE_LIST = new String[]{"", "", "", ""};
    private static final String NUMBER_SET = "12345678901";
    private static Random random = new Random();

    public static String cut(String input) {
        return S.cut(input, BaseConfig.getCutLength());
    }

    public static String cut(String input, int cutLength) {
        return S.substring((String)input, (int)0, (int)cutLength);
    }

    public static String join(Iterable<?> stringList) {
        return StringUtils.join(stringList, (String)SEPARATOR);
    }

    public static String join(String[] stringArray) {
        return StringUtils.join((Object[])stringArray, (String)SEPARATOR);
    }

    public static String[] split(String joinedStr) {
        if (joinedStr == null) {
            return null;
        }
        return joinedStr.split(SEPARATOR);
    }

    public static String clearNonConst(String inputJsonStr) {
        return S.replaceEach((String)inputJsonStr, (String[])SEARCH_LIST, (String[])REPLACE_LIST);
    }

    public static String[] toStringArray(List<String> stringList) {
        return stringList.toArray(new String[0]);
    }

    public static List<String> splitToList(String joinedStr) {
        return S.splitToList(joinedStr, SEPARATOR);
    }

    public static List<String> splitToList(String joinedStr, String separator) {
        if (joinedStr == null) {
            return null;
        }
        return Arrays.asList(joinedStr.split(separator));
    }

    public static String[] toSnakeCase(String[] camelCaseStrArray) {
        if (camelCaseStrArray == null) {
            return null;
        }
        String[] snakeCaseArray = new String[camelCaseStrArray.length];
        for (int i = 0; i < camelCaseStrArray.length; ++i) {
            snakeCaseArray[i] = S.toSnakeCase(camelCaseStrArray[i]);
        }
        return snakeCaseArray;
    }

    public static List<String> toSnakeCase(List<String> camelCaseStrArray) {
        if (camelCaseStrArray == null) {
            return null;
        }
        ArrayList<String> snakeCaseList = new ArrayList<String>(camelCaseStrArray.size());
        for (String camelCaseStr : camelCaseStrArray) {
            snakeCaseList.add(S.toSnakeCase(camelCaseStr));
        }
        return snakeCaseList;
    }

    public static String toSnakeCase(String camelCaseStr) {
        if (V.isEmpty(camelCaseStr)) {
            return null;
        }
        if (camelCaseStr.toLowerCase().equals(camelCaseStr)) {
            return camelCaseStr;
        }
        if (camelCaseStr.toUpperCase().equals(camelCaseStr)) {
            return camelCaseStr.toLowerCase();
        }
        char[] chars = camelCaseStr.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            if (Character.isUpperCase(c) && sb.length() > 0) {
                sb.append("_");
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toLowerCaseCamel(String snakeCaseStr) {
        String[] words;
        if (V.isEmpty(snakeCaseStr)) {
            return null;
        }
        if (!snakeCaseStr.contains("_")) {
            if (snakeCaseStr.toUpperCase().equals(snakeCaseStr)) {
                return snakeCaseStr.toLowerCase();
            }
            return S.uncapFirst(snakeCaseStr);
        }
        StringBuilder sb = null;
        for (String word : words = snakeCaseStr.split("_")) {
            if (V.isEmpty(word)) continue;
            if (sb == null) {
                sb = new StringBuilder(word.toLowerCase());
                continue;
            }
            sb.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase());
        }
        if (snakeCaseStr.endsWith("_") && sb != null) {
            sb.append("_");
        }
        return sb != null ? sb.toString() : null;
    }

    public static Long toLong(String strValue) {
        return S.toLong(strValue, null);
    }

    public static Long toLong(String strValue, Long defaultLong) {
        if (V.isEmpty(strValue)) {
            return defaultLong;
        }
        return Long.parseLong(strValue);
    }

    public static Integer toInt(String strValue) {
        return S.toInt(strValue, null);
    }

    public static Integer toInt(String strValue, Integer defaultInt) {
        if (V.isEmpty(strValue)) {
            return defaultInt;
        }
        return Integer.parseInt(strValue);
    }

    public static boolean toBoolean(String strValue) {
        return S.toBoolean(strValue, false);
    }

    public static boolean toBoolean(String strValue, boolean defaultBoolean) {
        if (V.notEmpty(strValue)) {
            return V.isTrue(strValue);
        }
        return defaultBoolean;
    }

    public static String removeDuplicateBlank(String input) {
        if (V.isEmpty(input)) {
            return input;
        }
        return input.trim().replaceAll(" +", " ");
    }

    public static String newUuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String valueOf(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return String.valueOf(o);
    }

    public static String defaultValueOf(Object o) {
        if (o == null) {
            return "";
        }
        return String.valueOf(o);
    }

    public static String defaultValueOf(Object o, String defaultStr) {
        if (o == null) {
            return defaultStr;
        }
        return String.valueOf(o);
    }

    public static String newRandomNum(int length) {
        StringBuilder sb = new StringBuilder();
        sb.append(NUMBER_SET.charAt(random.nextInt(9)));
        for (int i = 1; i < length; ++i) {
            sb.append(NUMBER_SET.charAt(random.nextInt(10)));
        }
        return sb.toString();
    }

    public static String uncapFirst(String input) {
        char firstChar;
        if (input != null && Character.isUpperCase(firstChar = input.charAt(0))) {
            return Character.toLowerCase(firstChar) + input.substring(1);
        }
        return input;
    }

    public static String capFirst(String input) {
        char firstChar;
        if (input != null && Character.isLowerCase(firstChar = input.charAt(0))) {
            return Character.toUpperCase(firstChar) + input.substring(1);
        }
        return input;
    }

    public static List<String> readLines(InputStream input, String charset) throws IOException {
        String line;
        InputStreamReader inputReader = new InputStreamReader(input, Charset.forName(charset));
        BufferedReader reader = new BufferedReader(inputReader);
        ArrayList<String> list = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            list.add(line);
        }
        return list;
    }

    public static String removeEsc(String columnName) {
        if (V.isEmpty(columnName)) {
            return columnName;
        }
        if (S.startsWithAny((CharSequence)columnName, (CharSequence[])new CharSequence[]{"`", "\"", "["})) {
            return S.substring((String)columnName, (int)1, (int)(columnName.length() - 1));
        }
        return columnName;
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (S.isEmpty((CharSequence)str)) {
            return S.valueOf(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return S.valueOf(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return S.valueOf(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String extractToken(String authToken) {
        if (S.startsWithIgnoreCase((CharSequence)authToken, (CharSequence)"Bearer")) {
            authToken = S.substring((String)authToken, (int)"Bearer".length()).trim();
        }
        return authToken;
    }

    public static String format(String template, Object ... params) {
        if (V.isEmpty(params)) {
            return template;
        }
        template = S.replaceChars((String)template, (String)"{}", (String)"%s");
        return String.format(template, params);
    }
}

