/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.config.BaseConfig;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encryptor {
    private static final Logger log = LoggerFactory.getLogger(Encryptor.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5PADDING";
    private static final String KEY_FILL = "abcdefghijklmnop";
    private static Map<String, Cipher> encryptorMap = null;
    private static Map<String, Cipher> decryptorMap = null;

    private static synchronized Map<String, Cipher> getEncryptorMap() {
        if (encryptorMap == null) {
            encryptorMap = new ConcurrentHashMap<String, Cipher>();
        }
        return encryptorMap;
    }

    private static synchronized Map<String, Cipher> getDecryptorMap() {
        if (decryptorMap == null) {
            decryptorMap = new ConcurrentHashMap<String, Cipher>();
        }
        return decryptorMap;
    }

    public static String encrypt(String input, String ... key) {
        String seedKey = V.notEmpty(key) ? key[0] : Encryptor.getDefaultKey();
        try {
            Cipher cipher = Encryptor.getEncryptor(seedKey);
            byte[] enBytes = cipher.doFinal(input.getBytes());
            return Base64.getEncoder().encodeToString(enBytes);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u51fa\u9519:" + input, (Throwable)e);
            return input;
        }
    }

    public static String decrypt(String input, String ... key) {
        if (V.isEmpty(input)) {
            return input;
        }
        String seedKey = V.notEmpty(key) ? key[0] : Encryptor.getDefaultKey();
        try {
            Cipher cipher = Encryptor.getDecryptor(seedKey);
            byte[] deBytes = Base64.getDecoder().decode(input.getBytes());
            return new String(cipher.doFinal(deBytes));
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u51fa\u9519:" + input, (Throwable)e);
            return input;
        }
    }

    private static Cipher getEncryptor(String key) throws Exception {
        byte[] keyBytes = Encryptor.getKey(key);
        Cipher encryptor = Encryptor.getEncryptorMap().get(new String(keyBytes));
        if (encryptor == null) {
            SecretKeySpec skeyspec = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
            encryptor = Cipher.getInstance(CIPHER_ALGORITHM);
            encryptor.init(1, skeyspec);
            Encryptor.getEncryptorMap().put(key, encryptor);
        }
        return encryptor;
    }

    private static Cipher getDecryptor(String key) throws Exception {
        byte[] keyBytes = Encryptor.getKey(key);
        Cipher decryptor = Encryptor.getDecryptorMap().get(new String(keyBytes));
        if (decryptor == null) {
            SecretKeySpec skeyspec = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
            decryptor = Cipher.getInstance(CIPHER_ALGORITHM);
            decryptor.init(2, skeyspec);
            Encryptor.getDecryptorMap().put(key, decryptor);
        }
        return decryptor;
    }

    private static byte[] getKey(String seed) {
        if (V.isEmpty(seed)) {
            seed = Encryptor.getDefaultKey();
        }
        if (seed.length() < 16) {
            seed = seed + S.cut(KEY_FILL, 16 - seed.length());
        } else if (seed.length() > 16) {
            seed = S.cut(seed, 16);
        }
        return seed.getBytes();
    }

    public static String getDefaultKey() {
        String defaultKey = BaseConfig.getProperty("diboot.encryptor.seed");
        return V.notEmpty(defaultKey) ? defaultKey : "DibootV3";
    }
}

