/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.config.Cons;
import com.diboot.core.converter.EnhancedConversionService;
import com.diboot.core.data.copy.AcceptAnnoCopier;
import com.diboot.core.entity.BaseEntity;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.D;
import com.diboot.core.util.IGetter;
import com.diboot.core.util.ISetter;
import com.diboot.core.util.JSON;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.core.vo.Status;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.ReflectionUtils;

public class BeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);
    private static final String CHANGE_FLAG = "->";
    private static final Set<String> IGNORE_FIELDS = new HashSet<String>(){
        {
            this.add(Cons.FieldName.createTime.name());
        }
    };
    private static ConversionService conversionService;
    private static final Map<Class<?>, Function<String, Object>> fieldConverterMap;

    public static <T> T copyProperties(Object source, T target) {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, target);
        AcceptAnnoCopier.copyAcceptProperties(source, target);
        return target;
    }

    public static <T> T convert(Object source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        T target = null;
        try {
            target = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtils.copyProperties(source, target);
        }
        catch (Exception e) {
            log.warn("\u5bf9\u8c61\u8f6c\u6362\u5f02\u5e38, class={}", (Object)clazz.getName());
        }
        return target;
    }

    public static <T> List<T> convertList(List<?> sourceList, Class<T> clazz) {
        if (V.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        if (clazz.equals(sourceList.get(0).getClass())) {
            return sourceList;
        }
        ArrayList<T> resultList = new ArrayList<T>(sourceList.size());
        try {
            for (Object source : sourceList) {
                T target = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                BeanUtils.copyProperties(source, target);
                resultList.add(target);
            }
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6c\u6362\u5f02\u5e38, class: {}, error: {}", (Object)clazz.getName(), (Object)e.getMessage());
            return Collections.emptyList();
        }
        return resultList;
    }

    public static <T> T convertMap2Bean(Map<String, Object> dataMap, Class<T> entityClass) {
        if (V.isEmpty(dataMap)) {
            return null;
        }
        T entityInstance = null;
        try {
            entityInstance = entityClass.newInstance();
        }
        catch (Exception e) {
            log.warn("\u5b9e\u4f8b\u5316Bean {} \u5f02\u5e38: {}", (Object)entityClass.getSimpleName(), (Object)e.getMessage());
        }
        BeanUtils.bindProperties(entityInstance, dataMap);
        return entityInstance;
    }

    public static <T> List<T> convertMap2BeanList(List<Map<String, Object>> resultListMap, Class<T> entityClass) {
        if (V.isEmpty(resultListMap)) {
            return Collections.emptyList();
        }
        ArrayList<T> entityList = new ArrayList<T>(resultListMap.size());
        for (Map<String, Object> resultMap : resultListMap) {
            T entityInstance = BeanUtils.convertMap2Bean(resultMap, entityClass);
            if (entityInstance == null) continue;
            entityList.add(entityInstance);
        }
        return entityList;
    }

    public static void bindProperties(Object model, Map<String, Object> propMap) {
        if (V.isAnyEmpty(model, propMap)) {
            return;
        }
        BeanWrapper beanWrapper = BeanUtils.getBeanWrapper(model);
        for (Map.Entry<String, Object> entry : propMap.entrySet()) {
            try {
                beanWrapper.setPropertyValue(entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                log.debug("\u590d\u5236\u5c5e\u6027{}.{}\u5f02\u5e38: {}", new Object[]{model.getClass().getSimpleName(), entry.getKey(), e.getMessage()});
            }
        }
    }

    public static Object getProperty(Object obj, String field) {
        if (field == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            return objMap.get(field);
        }
        try {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)obj);
            return wrapper.getPropertyValue(field);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u503c\u51fa\u9519\uff0c\u8fd4\u56denull", (Throwable)e);
            return null;
        }
    }

    public static String getStringProperty(Object obj, String field) {
        Object property = BeanUtils.getProperty(obj, field);
        if (property == null) {
            return null;
        }
        return String.valueOf(property);
    }

    public static synchronized BeanWrapper getBeanWrapper(Object obj) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)obj);
        if (conversionService == null) {
            conversionService = (ConversionService)ContextHolder.getBean(DefaultConversionService.class);
            if (conversionService == null) {
                List<Converter> converterList = ContextHolder.getBeans(Converter.class);
                conversionService = new EnhancedConversionService(converterList);
                log.debug("new ConversionService instance: {}", (Object)EnhancedConversionService.class.getName());
            } else {
                log.debug("get ConversionService instance: {} by getBean", (Object)conversionService.getClass().getName());
            }
        }
        wrapper.setConversionService(conversionService);
        return wrapper;
    }

    public static void setProperty(Object obj, String field, Object value) {
        BeanWrapper wrapper = BeanUtils.getBeanWrapper(obj);
        wrapper.setPropertyValue(field, value);
    }

    public static Object convertValueToFieldType(Object value, Field field) {
        if (value == null) {
            return null;
        }
        return BeanUtils.convertValueToFieldType(value, field.getType());
    }

    public static Object convertValueToFieldType(Object value, Class<?> fieldType) {
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(fieldType)) {
            return value;
        }
        String valueStr = S.valueOf(value);
        if (fieldConverterMap.containsKey(fieldType)) {
            return fieldConverterMap.get(fieldType).apply(valueStr);
        }
        if (LocalDate.class.equals(fieldType) || LocalDateTime.class.equals(fieldType)) {
            Date dateVal;
            Date date = dateVal = value instanceof Date ? (Date)value : D.fuzzyConvert(valueStr);
            if (dateVal == null) {
                return null;
            }
            ZonedDateTime zonedDateTime = dateVal.toInstant().atZone(ZoneId.systemDefault());
            return LocalDateTime.class.equals(fieldType) ? zonedDateTime.toLocalDateTime() : zonedDateTime.toLocalDate();
        }
        if (Serializable.class.isAssignableFrom(fieldType)) {
            if (value instanceof String) {
                return valueStr;
            }
            return JSON.parseObject(valueStr, fieldType);
        }
        return value;
    }

    public static <T> Map<String, T> convertToStringKeyObjectMap(List<T> allLists, IGetter<T> ... getterFns) {
        String[] fields = BeanUtils.convertGettersToFields(getterFns);
        return BeanUtils.convertToStringKeyObjectMap(allLists, fields);
    }

    public static <T> Map<String, T> convertToStringKeyObjectMap(List<T> allLists, String ... fields) {
        if (allLists == null || allLists.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, T> allListMap = new LinkedHashMap<String, T>(allLists.size());
        ModelKeyGenerator keyGenerator = new ModelKeyGenerator(fields);
        try {
            for (T model : allLists) {
                String key = keyGenerator.generate(model);
                if (key != null) {
                    allListMap.put(key, model);
                    continue;
                }
                log.warn(model.getClass().getName() + " \u7684\u5c5e\u6027 " + fields[0] + " \u503c\u5b58\u5728 null\uff0c\u8f6c\u6362\u7ed3\u679c\u9700\u8981\u786e\u8ba4!");
            }
        }
        catch (Exception e) {
            log.warn("\u8f6c\u6362key-model\u5f02\u5e38", (Throwable)e);
        }
        return allListMap;
    }

    public static <T> Map<String, List<T>> convertToStringKeyObjectListMap(List<T> allLists, IGetter<T> ... getterFns) {
        String[] fields = BeanUtils.convertGettersToFields(getterFns);
        return BeanUtils.convertToStringKeyObjectListMap(allLists, fields);
    }

    public static <T> Map<String, List<T>> convertToStringKeyObjectListMap(List<T> allLists, String ... fields) {
        if (V.isEmpty(allLists)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<T>> allListMap = new LinkedHashMap<String, List<T>>(allLists.size());
        ModelKeyGenerator keyGenerator = new ModelKeyGenerator(fields);
        try {
            for (T model : allLists) {
                String key = keyGenerator.generate(model);
                if (key != null) {
                    List list = allListMap.computeIfAbsent(key, k -> new ArrayList());
                    list.add(model);
                    continue;
                }
                log.warn(model.getClass().getName() + " \u7684\u5c5e\u6027 " + fields[0] + " \u503c\u5b58\u5728 null\uff0c\u8f6c\u6362\u7ed3\u679c\u9700\u8981\u786e\u8ba4!");
            }
        }
        catch (Exception e) {
            log.warn("\u8f6c\u6362key-model-list\u5f02\u5e38", (Throwable)e);
        }
        return allListMap;
    }

    public static <T> List<T> buildTree(List<T> allNodes) {
        return BeanUtils.buildTree(allNodes, null);
    }

    public static <T> List<T> buildTree(List<T> allNodes, Object rootNodeId) {
        return BeanUtils.buildTree(allNodes, rootNodeId, Cons.FieldName.id.name());
    }

    public static <T> List<T> buildTree(List<T> allNodes, Object rootNodeId, String idFieldName) {
        return BeanUtils.buildTree(allNodes, rootNodeId, idFieldName, Cons.FieldName.parentId.name(), Cons.FieldName.children.name());
    }

    public static <T> List<T> buildTree(List<T> allNodes, Object rootNodeId, String idFieldName, String parentIdFieldName, String childrenFieldName) {
        if (V.isEmpty(allNodes)) {
            return Collections.emptyList();
        }
        HashMap<Object, List<T>> parentId2ListMap = new HashMap<Object, List<T>>();
        for (T node : allNodes) {
            Object parentId = BeanUtils.getProperty(node, parentIdFieldName);
            Object nodeId = BeanUtils.getProperty(node, idFieldName);
            if (V.equals(nodeId, parentId)) {
                throw new BusinessException(Status.WARN_PERFORMANCE_ISSUE, "parentId\u5173\u8054\u81ea\u8eab\uff0c\u8bf7\u68c0\u67e5\uff01" + node.getClass().getSimpleName() + ":" + nodeId, new Object[0]);
            }
            parentId2ListMap.computeIfAbsent(parentId, k -> new ArrayList()).add(node);
        }
        if (parentId2ListMap.containsKey(rootNodeId)) {
            return BeanUtils.buildTree((List)parentId2ListMap.remove(rootNodeId), parentId2ListMap, idFieldName, childrenFieldName);
        }
        if (rootNodeId != null) {
            return Collections.emptyList();
        }
        for (Object parentId : new HashSet(parentId2ListMap.keySet())) {
            if (!parentId2ListMap.containsKey(parentId)) continue;
            BeanUtils.buildTree((List)parentId2ListMap.get(parentId), parentId2ListMap, idFieldName, childrenFieldName);
        }
        if (parentId2ListMap.size() == 1) {
            return (List)parentId2ListMap.values().iterator().next();
        }
        throw new BusinessException("buildTree\u6839\u8282\u70b9ParentId\u4e0d\u552f\u4e00", new Object[0]);
    }

    public static <T> List<T> buildTree(List<T> nodes, Map<Object, List<T>> parentId2ListMap, String idFieldName, String childrenFieldName) {
        for (T item : nodes) {
            Object id = BeanUtils.getProperty(item, idFieldName);
            if (!parentId2ListMap.containsKey(id)) continue;
            BeanUtils.setProperty(item, childrenFieldName, BeanUtils.buildTree(parentId2ListMap.remove(id), parentId2ListMap, idFieldName, childrenFieldName));
        }
        return nodes;
    }

    public static <T> List<T> buildTree(List<T> allNodes, Function<T, Object> getId, Function<T, Object> getParentId, BiConsumer<T, List<T>> setChildren) {
        return BeanUtils.buildTree(allNodes, null, getId, getParentId, setChildren);
    }

    public static <T> List<T> buildTree(List<T> allNodes, Serializable rootNodeId, Function<T, Object> getId, Function<T, Object> getParentId, BiConsumer<T, List<T>> setChildren) {
        if (V.isEmpty(allNodes)) {
            return Collections.emptyList();
        }
        HashMap<Object, List<T>> parentId2ListMap = new HashMap<Object, List<T>>();
        for (T node : allNodes) {
            Object parentId;
            Object nodeId = getId.apply(node);
            if (V.equals(nodeId, parentId = getParentId.apply(node))) {
                throw new BusinessException(Status.WARN_PERFORMANCE_ISSUE, "parentId\u5173\u8054\u81ea\u8eab\uff0c\u8bf7\u68c0\u67e5\uff01" + node.getClass().getSimpleName() + ":" + nodeId, new Object[0]);
            }
            parentId2ListMap.computeIfAbsent(parentId, k -> new ArrayList()).add(node);
        }
        if (parentId2ListMap.containsKey(rootNodeId)) {
            return BeanUtils.buildTree((List)parentId2ListMap.remove(rootNodeId), parentId2ListMap, getId, setChildren);
        }
        if (rootNodeId != null) {
            return Collections.emptyList();
        }
        for (Object parentId : new HashSet(parentId2ListMap.keySet())) {
            if (!parentId2ListMap.containsKey(parentId)) continue;
            BeanUtils.buildTree((List)parentId2ListMap.get(parentId), parentId2ListMap, getId, setChildren);
        }
        if (parentId2ListMap.size() == 1) {
            return (List)parentId2ListMap.values().iterator().next();
        }
        throw new BusinessException("buildTree\u6839\u8282\u70b9ParentId\u4e0d\u552f\u4e00", new Object[0]);
    }

    public static <T> List<T> buildTree(List<T> nodes, Map<Object, List<T>> parentId2ListMap, Function<T, Object> getId, BiConsumer<T, List<T>> setChildren) {
        for (T item : nodes) {
            Object id = getId.apply(item);
            if (!parentId2ListMap.containsKey(id)) continue;
            setChildren.accept(item, BeanUtils.buildTree(parentId2ListMap.remove(id), parentId2ListMap, getId, setChildren));
        }
        return nodes;
    }

    public static String extractDiff(BaseEntity oldModel, BaseEntity newModel) {
        return BeanUtils.extractDiff(oldModel, newModel, null);
    }

    public static String extractDiff(BaseEntity oldModel, BaseEntity newModel, Set<String> fields) {
        return BeanUtils.extractDiff(oldModel, newModel, fields, IGNORE_FIELDS);
    }

    public static String extractDiff(BaseEntity oldModel, BaseEntity newModel, Set<String> fields, Set<String> ignoreFields) {
        String key;
        if (newModel == null || oldModel == null) {
            log.warn("\u8c03\u7528\u9519\u8bef\uff0cModel\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return null;
        }
        Map<String, Object> oldMap = oldModel.toMap();
        Map<String, Object> newMap = newModel.toMap();
        HashMap<String, String> result = new HashMap<String, String>(oldMap.size() + newMap.size());
        for (Map.Entry<String, Object> entry : oldMap.entrySet()) {
            boolean checkThisField;
            key = entry.getKey();
            if (ignoreFields.contains(key)) continue;
            String oldValue = S.defaultValueOf(entry.getValue());
            Object newValueObj = newMap.get(key);
            String newValue = S.defaultValueOf(newValueObj);
            boolean bl = checkThisField = fields == null || fields.contains(key);
            if (checkThisField && !oldValue.equals(newValue)) {
                result.put(key, S.join((Object[])new String[]{oldValue, CHANGE_FLAG, newValue}));
            }
            if (newValueObj == null) continue;
            newMap.remove(key);
        }
        if (!newMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : newMap.entrySet()) {
                key = entry.getKey();
                if (ignoreFields.contains(key)) continue;
                String newValue = S.defaultValueOf(entry.getValue());
                if (fields != null && !fields.contains(key)) continue;
                result.put(key, S.join((Object[])new String[]{"", CHANGE_FLAG, newValue}));
            }
        }
        return JSON.toJSONString(result);
    }

    public static <E, T> List collectToList(List<E> objectList, IGetter<T> getterFn) {
        if (V.isEmpty(objectList)) {
            return Collections.emptyList();
        }
        String getterPropName = BeanUtils.convertToFieldName(getterFn);
        return BeanUtils.collectToList(objectList, getterPropName);
    }

    public static <E> List collectIdToList(List<E> objectList) {
        if (V.isEmpty(objectList)) {
            return Collections.emptyList();
        }
        return BeanUtils.collectToList(objectList, Cons.FieldName.id.name());
    }

    public static <E> List collectToList(List<E> objectList, String getterPropName) {
        if (V.isEmpty(objectList)) {
            return Collections.emptyList();
        }
        ArrayList<Object> fieldValueList = new ArrayList<Object>(objectList.size());
        try {
            for (E object : objectList) {
                Object fieldValue = BeanUtils.getProperty(object, getterPropName);
                if (fieldValue == null) continue;
                if (fieldValue instanceof Collection) {
                    fieldValueList.addAll((Collection)fieldValue);
                    continue;
                }
                fieldValueList.add(fieldValue);
            }
        }
        catch (Exception e) {
            log.warn("\u63d0\u53d6\u5c5e\u6027\u503c\u5f02\u5e38, getterPropName={}", (Object)getterPropName, (Object)e);
        }
        return fieldValueList;
    }

    @Deprecated
    public static <E> List collectToList(List<E> objectList, String getterPropName, boolean[] hasNullFlags) {
        if (V.isEmpty(objectList)) {
            return Collections.emptyList();
        }
        ArrayList<Object> fieldValueList = new ArrayList<Object>(objectList.size());
        try {
            for (E object : objectList) {
                Object fieldValue = BeanUtils.getProperty(object, getterPropName);
                if (fieldValue == null) {
                    hasNullFlags[0] = true;
                }
                fieldValueList.add(fieldValue);
            }
        }
        catch (Exception e) {
            log.warn("\u63d0\u53d6\u5c5e\u6027\u503c\u5f02\u5e38, getterPropName={}", (Object)getterPropName, (Object)e);
        }
        return fieldValueList;
    }

    public static <T1, T2, R, E> void bindPropValueOfList(ISetter<T1, R> setFieldFn, List<E> fromList, IGetter<T2> getFieldFun, Map valueMatchMap) {
        if (V.isEmpty(fromList)) {
            return;
        }
        String setterFieldName = BeanUtils.convertToFieldName(setFieldFn);
        String getterFieldName = BeanUtils.convertToFieldName(getFieldFun);
        BeanUtils.bindPropValueOfList(setterFieldName, fromList, getterFieldName, valueMatchMap);
    }

    public static <E> void bindPropValueOfList(String setterFieldName, List<E> fromList, String getterFieldName, Map valueMatchMap) {
        if (V.isEmpty(fromList) || V.isEmpty(valueMatchMap)) {
            return;
        }
        try {
            for (E object : fromList) {
                Object value;
                Object fieldValue = BeanUtils.getProperty(object, getterFieldName);
                if (V.isEmpty(fieldValue)) continue;
                if (valueMatchMap.containsKey(fieldValue)) {
                    value = valueMatchMap.get(fieldValue);
                } else {
                    String fieldValueStr = String.valueOf(fieldValue);
                    value = valueMatchMap.get(fieldValueStr);
                }
                BeanUtils.setProperty(object, setterFieldName, value);
            }
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u5c5e\u6027\u503c\u5f02\u5e38, setterFieldName={}", (Object)setterFieldName, (Object)e);
        }
    }

    public static <T> T cloneBean(T ent) {
        try {
            Object cloneObj = org.springframework.beans.BeanUtils.instantiateClass(ent.getClass());
            BeanUtils.copyProperties(ent, cloneObj);
            return (T)cloneObj;
        }
        catch (Exception e) {
            log.warn("Clone Object " + ent.getClass().getSimpleName() + " error", (Throwable)e);
            return ent;
        }
    }

    public static <T> String convertToFieldName(IGetter<T> fn) {
        SerializedLambda lambda = BeanUtils.getSerializedLambda(fn);
        return PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
    }

    public static <T, R> String convertToFieldName(ISetter<T, R> fn) {
        SerializedLambda lambda = BeanUtils.getSerializedLambda(fn);
        return PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
    }

    public static <R> String convertSFunctionToFieldName(SFunction<R, ?> getterFn) {
        LambdaMeta lambdaMeta = LambdaUtils.extract(getterFn);
        return PropertyNamer.methodToProperty((String)lambdaMeta.getImplMethodName());
    }

    public static List<Field> extractAllFields(Class clazz) {
        return BeanUtils.extractClassFields(clazz, true, null);
    }

    public static List<Field> extractAllFields(Class clazz, boolean excludeSpecial) {
        return BeanUtils.extractClassFields(clazz, excludeSpecial, null);
    }

    public static List<Field> extractFields(Class<?> clazz, Class<? extends Annotation> annotation) {
        return BeanUtils.extractClassFields(clazz, false, annotation);
    }

    public static Field extractField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.findField(clazz, (String)fieldName);
    }

    public static String getColumnName(Field field) {
        String columnName = null;
        if (field.isAnnotationPresent(TableField.class)) {
            columnName = field.getAnnotation(TableField.class).value();
        } else if (field.isAnnotationPresent(TableId.class)) {
            columnName = field.getAnnotation(TableId.class).value();
        }
        return (String)S.getIfEmpty((CharSequence)columnName, () -> S.toSnakeCase(field.getName()));
    }

    public static Class<?> getTargetClass(Object instance) {
        return instance instanceof Class ? (Class)instance : AopProxyUtils.ultimateTargetClass((Object)instance);
    }

    public static Class getGenericityClass(Object instance, int index) {
        Class<?> hostClass = BeanUtils.getTargetClass(instance);
        ResolvableType resolvableType = ResolvableType.forClass(hostClass);
        resolvableType = resolvableType.getSuperType().getType().getTypeName().equals(Object.class.getName()) && V.notEmpty(resolvableType.getInterfaces()) ? resolvableType.getInterfaces()[0] : resolvableType.getSuperType();
        Object[] types = resolvableType.getGenerics();
        if (V.isEmpty(types) || index >= types.length) {
            types = resolvableType.getSuperType().getGenerics();
        }
        if (V.notEmpty(types) && types.length > index) {
            return types[index].resolve();
        }
        log.debug("\u65e0\u6cd5\u4ece {} \u7c7b\u5b9a\u4e49\u4e2d\u83b7\u53d6\u6cdb\u578b\u7c7b{}", (Object)hostClass.getName(), (Object)index);
        return null;
    }

    public static Map<String, Object> convertLabelValueList2Map(List<LabelValue> labelValueList) {
        if (V.notEmpty(labelValueList)) {
            return labelValueList.stream().collect(Collectors.toMap(LabelValue::getLabel, LabelValue::getValue));
        }
        return Collections.EMPTY_MAP;
    }

    public static <T> List<T> distinctByKey(List<T> list, Function<? super T, ?> getterFn) {
        return list.stream().filter(BeanUtils.distinctPredicate(getterFn)).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctPredicate(Function<? super T, ?> getterFn) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(getterFn.apply(t));
    }

    public static SerializedLambda getSerializedLambda(Serializable fn) {
        SerializedLambda lambda = null;
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            lambda = (SerializedLambda)method.invoke((Object)fn, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6SerializedLambda\u5f02\u5e38, class={}", (Object)fn.getClass().getSimpleName(), (Object)e);
        }
        return lambda;
    }

    @SafeVarargs
    private static <T> String[] convertGettersToFields(IGetter<T> ... getterFns) {
        if (V.isEmpty(getterFns)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int length = getterFns.length;
        String[] fields = new String[length];
        for (int i = 0; i < length; ++i) {
            fields[i] = BeanUtils.convertToFieldName(getterFns[i]);
        }
        return fields;
    }

    public static void clearFieldValue(Object object, List<String> fieldNameList) {
        if (fieldNameList == null) {
            return;
        }
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)object);
        for (String fieldName : fieldNameList) {
            wrapper.setPropertyValue(fieldName, null);
        }
    }

    public static Collection convertIdValuesToType(Collection<?> values, Class fieldType) {
        if (V.isEmpty(values)) {
            return values;
        }
        if (V.equals(values.iterator().next().getClass(), fieldType)) {
            return values;
        }
        ArrayList<Object> formatValues = new ArrayList<Object>(values.size());
        for (Object value : values) {
            formatValues.add(BeanUtils.convertIdValueToType(value, fieldType));
        }
        return formatValues;
    }

    public static Object convertIdValueToType(Object value, Class fieldType) {
        if (V.isEmpty(value)) {
            return null;
        }
        if (Long.class.equals((Object)fieldType)) {
            return Long.parseLong(S.valueOf(value));
        }
        if (Integer.class.equals((Object)fieldType)) {
            return Integer.parseInt(S.valueOf(value));
        }
        return value;
    }

    public static Class<?> getFieldActualType(Class<?> clazz, String fieldName) {
        Field field = BeanUtils.extractField(clazz, fieldName);
        if (field == null) {
            log.warn("class {} \u4e2d\u65e0\u5b57\u6bb5 {}", (Object)clazz.getName(), (Object)fieldName);
            return null;
        }
        return BeanUtils.getFieldActualType(field);
    }

    public static Class<?> getFieldActualType(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getActualTypeArguments()[0];
        }
        log.warn("\u975e\u9884\u671f\u7684GenericType : {}", (Object)genericType.getTypeName());
        return null;
    }

    private static List<Field> extractClassFields(Class<?> beanClazz, boolean excludeStaticFinal, Class<? extends Annotation> annotation) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<String> fieldNameSet = new HashSet<String>();
        BeanUtils.loopFindFields(beanClazz, excludeStaticFinal, annotation, fieldList, fieldNameSet);
        return fieldList;
    }

    private static void loopFindFields(Class<?> beanClazz, boolean excludeSpecial, Class<? extends Annotation> annotation, List<Field> fieldList, Set<String> fieldNameSet) {
        if (beanClazz == null) {
            return;
        }
        Object[] fields = beanClazz.getDeclaredFields();
        if (V.notEmpty(fields)) {
            for (Object field : fields) {
                int modifiers;
                if (!fieldNameSet.add(((Field)field).getName()) || excludeSpecial && (Modifier.isStatic(modifiers = ((Field)field).getModifiers()) || Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers)) || annotation != null && ((Field)field).getAnnotation(annotation) == null) continue;
                fieldList.add((Field)field);
            }
        }
        BeanUtils.loopFindFields(beanClazz.getSuperclass(), excludeSpecial, annotation, fieldList, fieldNameSet);
    }

    static {
        fieldConverterMap = new HashMap<Class<?>, Function<String, Object>>(){
            {
                this.put(Integer.class, Integer::parseInt);
                this.put(Long.class, Long::parseLong);
                this.put(Double.class, Double::parseDouble);
                this.put(BigDecimal.class, BigDecimal::new);
                this.put(Float.class, Float::parseFloat);
                this.put(Boolean.class, V::isTrue);
                this.put(Date.class, D::fuzzyConvert);
            }
        };
    }

    private static class ModelKeyGenerator {
        private final String[] fields;
        private final boolean isFieldsEmpty;
        private final boolean isFieldsOnlyOne;

        public ModelKeyGenerator(String[] fields) {
            this.fields = fields;
            this.isFieldsEmpty = V.isEmpty(fields);
            this.isFieldsOnlyOne = !this.isFieldsEmpty && fields.length == 1;
        }

        public String generate(Object model) {
            Object key = null;
            if (this.isFieldsEmpty) {
                return BeanUtils.getStringProperty(model, Cons.FieldName.id.name());
            }
            if (this.isFieldsOnlyOne) {
                return BeanUtils.getStringProperty(model, this.fields[0]);
            }
            ArrayList<Object> list = new ArrayList<Object>(this.fields.length);
            for (String field : this.fields) {
                list.add(BeanUtils.getProperty(model, field));
            }
            return S.join(list);
        }
    }
}

