/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.ApiUri;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class AnnotationUtils
extends org.springframework.core.annotation.AnnotationUtils {
    private static final Logger log = LoggerFactory.getLogger(AnnotationUtils.class);

    public static ApiUri extractRequestMethodAndMappingUrl(Method method) {
        String requestMethod = null;
        String url = null;
        if (method.getAnnotation(GetMapping.class) != null) {
            GetMapping anno = (GetMapping)AnnotationUtils.getAnnotation((Method)method, GetMapping.class);
            requestMethod = RequestMethod.GET.name();
            url = AnnotationUtils.getNotEmptyStr(anno.value(), anno.path());
        } else if (method.getAnnotation(PostMapping.class) != null) {
            PostMapping anno = (PostMapping)AnnotationUtils.getAnnotation((Method)method, PostMapping.class);
            requestMethod = RequestMethod.POST.name();
            url = AnnotationUtils.getNotEmptyStr(anno.value(), anno.path());
        } else if (method.getAnnotation(PutMapping.class) != null) {
            PutMapping anno = (PutMapping)AnnotationUtils.getAnnotation((Method)method, PutMapping.class);
            requestMethod = RequestMethod.PUT.name();
            url = AnnotationUtils.getNotEmptyStr(anno.value(), anno.path());
        } else if (method.getAnnotation(DeleteMapping.class) != null) {
            DeleteMapping anno = (DeleteMapping)AnnotationUtils.getAnnotation((Method)method, DeleteMapping.class);
            requestMethod = RequestMethod.DELETE.name();
            url = AnnotationUtils.getNotEmptyStr(anno.value(), anno.path());
        } else if (method.getAnnotation(PatchMapping.class) != null) {
            PatchMapping anno = (PatchMapping)AnnotationUtils.getAnnotation((Method)method, PatchMapping.class);
            requestMethod = RequestMethod.PATCH.name();
            url = AnnotationUtils.getNotEmptyStr(anno.value(), anno.path());
        } else if (AnnotationUtils.getAnnotation((Method)method, RequestMapping.class) != null) {
            RequestMapping anno = (RequestMapping)AnnotationUtils.getAnnotation((Method)method, RequestMapping.class);
            if (V.notEmpty(anno.method())) {
                List methods = Arrays.stream(anno.method()).map(m -> m.name()).collect(Collectors.toList());
                requestMethod = S.join(methods);
            } else {
                requestMethod = "GET,POST";
            }
            url = AnnotationUtils.getNotEmptyStr(anno.value(), anno.path());
        } else {
            log.warn("\u65e0\u6cd5\u8bc6\u522b\u5230URL Mapping\u76f8\u5173\u6ce8\u89e3: " + method.getName());
        }
        return new ApiUri(requestMethod, url);
    }

    public static String getNotEmptyStr(String[] values, String[] paths) {
        if (V.notEmpty(values) && values[0] != null) {
            return S.join(values);
        }
        if (V.notEmpty(paths) && paths[0] != null) {
            return S.join(paths);
        }
        return "";
    }

    public static List<Method> extractAnnotationMethods(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        while (clazz != null) {
            Object[] methods = clazz.getDeclaredMethods();
            if (V.notEmpty(methods)) {
                Arrays.stream(methods).forEach(method -> {
                    if (AnnotationUtils.getAnnotation((Method)method, (Class)annotationClass) != null) {
                        methodList.add((Method)method);
                    }
                });
            }
            clazz = clazz.getSuperclass();
        }
        return methodList;
    }
}

