/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.serial.deserializer;

import com.diboot.core.util.JSON;
import com.diboot.core.util.V;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.List;

public class StringListDeserializer
extends StdDeserializer<List<String>> {
    private static final long serialVersionUID = -4162970093906595310L;

    public StringListDeserializer() {
        super(List.class);
    }

    public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        String stringList = (String)p.readValueAs(String.class);
        if (V.notEmpty(stringList)) {
            return JSON.parseArray(stringList, new TypeReference<List<String>>(){});
        }
        return null;
    }
}

