/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.holder;

import com.diboot.core.cache.StaticMemoryCacheManager;
import com.diboot.core.holder.api.CollectThisApi;
import com.diboot.core.holder.api.RestApi;
import com.diboot.core.holder.api.RestApiWrapper;
import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import com.diboot.core.vo.ApiUri;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class AnnotationRestApiHolder {
    private static final Logger log = LoggerFactory.getLogger(AnnotationRestApiHolder.class);
    private static StaticMemoryCacheManager cacheManager;
    private static final String CACHE_NAME_CLASS_TO_WRAPPER = "CLASS_TO_WRAPPER";
    private static final String CACHE_NAME_CATEGORY_TO_APILIST = "CATEGORY_TO_API_LIST";

    private static synchronized StaticMemoryCacheManager getCacheManager() {
        if (cacheManager == null) {
            cacheManager = new StaticMemoryCacheManager(CACHE_NAME_CLASS_TO_WRAPPER, CACHE_NAME_CATEGORY_TO_APILIST);
        }
        return cacheManager;
    }

    public static List<RestApi> getDefaultCategoryRestApiList() {
        return AnnotationRestApiHolder.getRestApiList("default");
    }

    public static synchronized List<RestApi> getRestApiList(String category) {
        List apiList = AnnotationRestApiHolder.getCacheManager().getCacheObj(CACHE_NAME_CATEGORY_TO_APILIST, (Object)category, List.class);
        if (apiList == null && AnnotationRestApiHolder.getCacheManager().isUninitializedCache(CACHE_NAME_CATEGORY_TO_APILIST)) {
            AnnotationRestApiHolder.initRestApiCache();
            apiList = AnnotationRestApiHolder.getCacheManager().getCacheObj(CACHE_NAME_CATEGORY_TO_APILIST, (Object)category, List.class);
        }
        return apiList;
    }

    public static synchronized RestApiWrapper getRestApiWrapper(String className) {
        RestApiWrapper apiWrapper = AnnotationRestApiHolder.getCacheManager().getCacheObj(CACHE_NAME_CLASS_TO_WRAPPER, (Object)className, RestApiWrapper.class);
        if (apiWrapper == null && AnnotationRestApiHolder.getCacheManager().isUninitializedCache(CACHE_NAME_CLASS_TO_WRAPPER)) {
            AnnotationRestApiHolder.initRestApiCache();
            apiWrapper = AnnotationRestApiHolder.getCacheManager().getCacheObj(CACHE_NAME_CLASS_TO_WRAPPER, (Object)className, RestApiWrapper.class);
        }
        return apiWrapper;
    }

    private static synchronized void initRestApiCache() {
        List<Object> controllerList = ContextHolder.getBeansByAnnotation(RestController.class);
        if (V.isEmpty(controllerList)) {
            return;
        }
        for (Object obj : controllerList) {
            List<RestApi> categoryApis;
            Class<?> controllerClass = BeanUtils.getTargetClass(obj);
            CollectThisApi anno = (CollectThisApi)AnnotationUtils.findAnnotation(controllerClass, CollectThisApi.class);
            String title = anno != null ? anno.name() : controllerClass.getSimpleName();
            RestApiWrapper wrapper = new RestApiWrapper(controllerClass.getName(), title, anno);
            AnnotationRestApiHolder.buildRestApisInClass(wrapper, controllerClass);
            if (anno == null && !V.notEmpty(wrapper.getChildren())) continue;
            AnnotationRestApiHolder.getCacheManager().putCacheObj(CACHE_NAME_CLASS_TO_WRAPPER, wrapper.getClassName(), wrapper);
            if (!V.notEmpty(wrapper.getChildren())) continue;
            HashMap<String, ArrayList<RestApi>> categoryApisMap = new HashMap<String, ArrayList<RestApi>>(8);
            for (RestApi restApi : wrapper.getChildren()) {
                categoryApis = (ArrayList<RestApi>)categoryApisMap.get(restApi.getCategory());
                if (categoryApis == null) {
                    categoryApis = new ArrayList<RestApi>();
                    categoryApisMap.put(restApi.getCategory(), (ArrayList<RestApi>)categoryApis);
                }
                categoryApis.add(restApi);
            }
            for (Map.Entry entry : categoryApisMap.entrySet()) {
                categoryApis = AnnotationRestApiHolder.getCacheManager().getCacheObj(CACHE_NAME_CATEGORY_TO_APILIST, entry.getKey(), List.class);
                if (categoryApis == null) {
                    categoryApis = (List)entry.getValue();
                } else {
                    for (RestApi api : (List)entry.getValue()) {
                        if (categoryApis.contains(api)) continue;
                        categoryApis.add(api);
                    }
                }
                AnnotationRestApiHolder.getCacheManager().putCacheObj(CACHE_NAME_CATEGORY_TO_APILIST, entry.getKey(), categoryApis);
            }
        }
    }

    private static void buildRestApisInClass(RestApiWrapper wrapper, Class controllerClass) {
        List<Method> annoMethods;
        String urlPrefix = "";
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Class)controllerClass, RequestMapping.class);
        if (requestMapping != null) {
            urlPrefix = AnnotationUtils.getNotEmptyStr(requestMapping.value(), requestMapping.path());
        }
        if (V.notEmpty(annoMethods = AnnotationUtils.extractAnnotationMethods(controllerClass, CollectThisApi.class))) {
            for (Method method : annoMethods) {
                if (Modifier.isPrivate(method.getModifiers())) continue;
                CollectThisApi restApiAnno = (CollectThisApi)AnnotationUtils.getAnnotation((Method)method, CollectThisApi.class);
                ApiUri apiUri = AnnotationUtils.extractRequestMethodAndMappingUrl(method);
                if (apiUri.isEmpty()) continue;
                AnnotationRestApiHolder.buildRestApi(wrapper, urlPrefix, apiUri, restApiAnno);
            }
        }
    }

    private static void buildRestApi(RestApiWrapper wrapper, String urlPrefix, ApiUri apiUri, CollectThisApi annotation) {
        String requestMethod = apiUri.getMethod();
        String url = apiUri.getUri();
        for (String m : requestMethod.split(",")) {
            for (String u : url.split(",")) {
                if (V.notEmpty(urlPrefix)) {
                    for (String path : urlPrefix.split(",")) {
                        RestApi restApi = new RestApi().setApiMethod(m).setApiUri(path + u).setCategory(annotation.category()).setApiName(annotation.name());
                        wrapper.addChild(restApi);
                    }
                    continue;
                }
                RestApi restApi = new RestApi().setApiMethod(m).setApiUri(u).setCategory(annotation.category()).setApiName(annotation.name());
                wrapper.addChild(restApi);
            }
        }
    }
}

