/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.extension;

import com.diboot.core.extension.SerialNumberGenerator;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SerialNumberGeneratorFactory {
    private static final Logger log = LoggerFactory.getLogger(SerialNumberGeneratorFactory.class);
    private static final Map<String, SerialNumberGenerator> GENERATOR_CACHE_MAP = new LinkedHashMap<String, SerialNumberGenerator>();
    private static final List<LabelValue> DEFINITIONS = new ArrayList<LabelValue>();

    public static SerialNumberGenerator getGenerator(String generatorId) {
        SerialNumberGeneratorFactory.initIfRequired();
        SerialNumberGenerator generator = GENERATOR_CACHE_MAP.get(generatorId);
        if (generator == null) {
            log.warn("\u65e0\u6cd5\u627e\u5230\u5e8f\u5217\u53f7\u751f\u6210\u5668: {} \u7684\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\uff01", (Object)generatorId);
        }
        return generator;
    }

    public static List<LabelValue> getAllDefinitions() {
        SerialNumberGeneratorFactory.initIfRequired();
        return DEFINITIONS;
    }

    private static void initIfRequired() {
        if (GENERATOR_CACHE_MAP.isEmpty()) {
            DEFINITIONS.clear();
            List<SerialNumberGenerator> generatorList = ContextHolder.getBeans(SerialNumberGenerator.class);
            if (V.notEmpty(generatorList)) {
                generatorList.forEach(generator -> {
                    Assert.notNull((Object)generator.definition(), (String)"definition\u63a5\u53e3\u8fd4\u56de\u503c\u4e0d\u53ef\u4e3a\u7a7a");
                    GENERATOR_CACHE_MAP.put(S.valueOf(generator.definition().getValue()), (SerialNumberGenerator)generator);
                    DEFINITIONS.add(generator.definition());
                });
            }
        }
    }
}

