/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.data.protect;

import com.diboot.core.data.protect.DataEncryptHandler;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEncryptTypeHandler
extends BaseTypeHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(DefaultEncryptTypeHandler.class);
    private DataEncryptHandler dataEncryptHandler;

    protected DataEncryptHandler getDataEncryptHandler() {
        if (this.dataEncryptHandler == null) {
            this.dataEncryptHandler = ContextHolder.getBean(DataEncryptHandler.class);
            if (this.dataEncryptHandler == null) {
                throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6 DataEncryptHandler \u6570\u636e\u52a0\u89e3\u5bc6\u7684\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\uff01", new Object[0]);
            }
        }
        return this.dataEncryptHandler;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        String encryptedValue = this.getDataEncryptHandler().encrypt(parameter);
        ps.setString(i, encryptedValue);
        log.debug("\u5b57\u6bb5\u4fdd\u62a4 - \u5b58\u50a8\u524d\u52a0\u5bc6\uff1a{} -> {}", (Object)parameter, (Object)encryptedValue);
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        return this.decryptValue(value);
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        return this.decryptValue(value);
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        return this.decryptValue(value);
    }

    protected String decryptValue(String value) {
        String decryptedValue = this.getDataEncryptHandler().decrypt(value);
        log.debug("\u5b57\u6bb5\u4fdd\u62a4 - \u8bfb\u53d6\u540e\u89e3\u5bc6\uff1a{} -> {}", (Object)value, (Object)decryptedValue);
        return decryptedValue;
    }
}

