/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.data.copy;

import com.diboot.core.data.copy.Accept;
import com.diboot.core.data.copy.CopyInfo;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.V;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;

public class AcceptAnnoCopier {
    private static final Logger log = LoggerFactory.getLogger(AcceptAnnoCopier.class);
    private static final Map<String, List<CopyInfo>> CLASS_ACCEPT_ANNO_CACHE_MAP = new ConcurrentHashMap<String, List<CopyInfo>>();

    public static void copyAcceptProperties(Object source, Object target) {
        List<CopyInfo> acceptAnnos;
        String key = target.getClass().getName();
        if (!CLASS_ACCEPT_ANNO_CACHE_MAP.containsKey(key)) {
            List<Field> annoFieldList = BeanUtils.extractFields(target.getClass(), Accept.class);
            if (V.isEmpty(annoFieldList)) {
                CLASS_ACCEPT_ANNO_CACHE_MAP.put(key, Collections.EMPTY_LIST);
            } else {
                ArrayList<CopyInfo> annoDefList = new ArrayList<CopyInfo>(annoFieldList.size());
                for (Field fld : annoFieldList) {
                    Accept accept = fld.getAnnotation(Accept.class);
                    CopyInfo copyInfo = new CopyInfo(accept.name(), fld.getName(), accept.override());
                    annoDefList.add(copyInfo);
                }
                CLASS_ACCEPT_ANNO_CACHE_MAP.put(key, annoDefList);
            }
        }
        if (V.isEmpty(acceptAnnos = CLASS_ACCEPT_ANNO_CACHE_MAP.get(key))) {
            return;
        }
        BeanWrapper beanWrapper = BeanUtils.getBeanWrapper(target);
        for (CopyInfo copyInfo : acceptAnnos) {
            Object targetValue;
            if (!copyInfo.isOverride() && (targetValue = BeanUtils.getProperty(target, copyInfo.getTo())) != null) {
                log.debug("\u76ee\u6807\u5bf9\u8c61{}\u5df2\u6709\u503c{}\uff0ccopyAcceptProperties\u5c06\u5ffd\u7565.", (Object)key, targetValue);
                continue;
            }
            Object sourceValue = SystemMetaObject.forObject((Object)source).getValue(copyInfo.getForm());
            if (sourceValue == null) continue;
            beanWrapper.setPropertyValue(copyInfo.getTo(), sourceValue);
        }
    }
}

