/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.data.access;

import com.diboot.core.data.access.DataAccessCheckpoint;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.V;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAccessAnnoCache {
    private static final Logger log = LoggerFactory.getLogger(DataAccessAnnoCache.class);
    private static final Map<String, Map<String, String>> DATA_PERMISSION_ANNO_CACHE = new ConcurrentHashMap<String, Map<String, String>>();

    public static boolean hasDataAccessCheckpoint(Class<?> entityClass) {
        return !DATA_PERMISSION_ANNO_CACHE.computeIfAbsent(entityClass.getName(), k -> DataAccessAnnoCache.initClassCheckpoint(entityClass)).isEmpty();
    }

    public static Map<String, String> getDataPermissionMap(Class<?> entityClass) {
        return DATA_PERMISSION_ANNO_CACHE.computeIfAbsent(entityClass.getName(), k -> DataAccessAnnoCache.initClassCheckpoint(entityClass));
    }

    private static Map<String, String> initClassCheckpoint(Class<?> entityClass) {
        List<Field> fieldList = BeanUtils.extractFields(entityClass, DataAccessCheckpoint.class);
        if (V.notEmpty(fieldList)) {
            HashMap<String, String> results = new HashMap<String, String>();
            for (Field fld : fieldList) {
                results.put(fld.getName(), BeanUtils.getColumnName(fld));
            }
            return results;
        }
        return Collections.emptyMap();
    }
}

