/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.query.dynamic;

import com.diboot.core.binding.parser.BaseConditionManager;
import com.diboot.core.binding.query.dynamic.AnnoJoiner;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinConditionManager
extends BaseConditionManager {
    private static final Logger log = LoggerFactory.getLogger(JoinConditionManager.class);

    public static void parseJoinCondition(AnnoJoiner joiner) {
        List<Expression> expressionList = JoinConditionManager.getExpressionList(joiner.getCondition());
        if (V.isEmpty(expressionList)) {
            log.warn("\u65e0\u6cd5\u89e3\u6790\u6ce8\u89e3\u6761\u4ef6: {} ", (Object)joiner.getCondition());
            throw new InvalidUsageException("\u65e0\u6cd5\u89e3\u6790\u6ce8\u89e3\u6761\u4ef6: " + joiner.getCondition(), new Object[0]);
        }
        String tableName = JoinConditionManager.extractMiddleTableName(expressionList);
        if (tableName != null) {
            joiner.setMiddleTable(tableName);
        }
        JoinConditionManager.parseJoinOn(joiner, expressionList);
    }

    private static void parseJoinOn(AnnoJoiner joiner, List<Expression> expressionList) {
        ArrayList<String> segments = new ArrayList<String>();
        ArrayList middleTableOnSegments = new ArrayList();
        for (Expression operator : expressionList) {
            String left;
            BinaryExpression expression;
            ArrayList<String> currentSegments = segments;
            if (operator instanceof BinaryExpression) {
                expression = (BinaryExpression)operator;
                left = JoinConditionManager.formatColumn(expression.getLeftExpression(), joiner);
                String right = JoinConditionManager.formatColumn(expression.getRightExpression(), joiner);
                if (joiner.getMiddleTable() != null && (left.startsWith(joiner.getMiddleTableAlias() + ".") || right.startsWith(joiner.getMiddleTableAlias() + ".")) && !left.startsWith(joiner.getAlias() + ".") && !right.startsWith(joiner.getAlias() + ".")) {
                    currentSegments = middleTableOnSegments;
                }
                if (operator instanceof EqualsTo) {
                    currentSegments.add(left + " = " + right);
                    continue;
                }
                if (operator instanceof NotEqualsTo) {
                    currentSegments.add(left + " != " + right);
                    continue;
                }
                if (operator instanceof GreaterThan) {
                    currentSegments.add(left + " > " + right);
                    continue;
                }
                if (operator instanceof GreaterThanEquals) {
                    currentSegments.add(left + " >= " + right);
                    continue;
                }
                if (operator instanceof MinorThan) {
                    currentSegments.add(left + " < " + right);
                    continue;
                }
                if (operator instanceof MinorThanEquals) {
                    currentSegments.add(left + " <= " + right);
                    continue;
                }
                if (operator instanceof LikeExpression) {
                    LikeExpression likeExpression = (LikeExpression)expression;
                    if (!likeExpression.isNot()) {
                        currentSegments.add(left + " LIKE " + expression.getRightExpression().toString());
                        continue;
                    }
                    currentSegments.add(left + " NOT LIKE " + expression.getRightExpression().toString());
                    continue;
                }
                log.warn("\u6682\u4e0d\u652f\u6301\u7684\u6761\u4ef6: " + expression.toString());
                continue;
            }
            if (operator instanceof IsNullExpression) {
                expression = (IsNullExpression)operator;
                left = JoinConditionManager.formatColumn(expression.getLeftExpression(), joiner);
                if (joiner.getMiddleTable() != null && left.startsWith(joiner.getMiddleTableAlias() + ".")) {
                    currentSegments = middleTableOnSegments;
                }
                if (!expression.isNot()) {
                    currentSegments.add(left + " IS NULL");
                    continue;
                }
                currentSegments.add(left + " IS NOT NULL");
                continue;
            }
            if (operator instanceof InExpression) {
                expression = (InExpression)operator;
                left = JoinConditionManager.formatColumn(expression.getLeftExpression(), joiner);
                if (joiner.getMiddleTable() != null && left.startsWith(joiner.getMiddleTableAlias() + ".")) {
                    currentSegments = middleTableOnSegments;
                }
                if (!expression.isNot()) {
                    currentSegments.add(left + " IN " + expression.getRightExpression().toString());
                    continue;
                }
                currentSegments.add(left + " NOT IN " + expression.getRightExpression().toString());
                continue;
            }
            if (operator instanceof Between) {
                expression = (Between)operator;
                left = JoinConditionManager.formatColumn(expression.getLeftExpression(), joiner);
                if (joiner.getMiddleTable() != null && left.startsWith(joiner.getMiddleTableAlias() + ".")) {
                    currentSegments = middleTableOnSegments;
                }
                if (!expression.isNot()) {
                    currentSegments.add(left + " BETWEEN " + expression.getBetweenExpressionStart().toString() + " AND " + expression.getBetweenExpressionEnd().toString());
                    continue;
                }
                currentSegments.add(left + " NOT BETWEEN " + expression.getBetweenExpressionStart().toString() + " AND " + expression.getBetweenExpressionEnd().toString());
                continue;
            }
            log.warn("\u4e0d\u652f\u6301\u7684\u6761\u4ef6: " + operator.toString());
        }
        if (segments.isEmpty() && middleTableOnSegments.isEmpty()) {
            return;
        }
        joiner.setOnSegment(S.join(segments, (String)" AND "));
        if (V.notEmpty(middleTableOnSegments)) {
            joiner.setMiddleTableOnSegment(S.join(middleTableOnSegments, (String)" AND "));
        }
    }

    private static String formatColumn(Expression expression, AnnoJoiner joiner) {
        if (!(expression instanceof Column)) {
            return expression.toString();
        }
        String annoColumn = S.toSnakeCase(expression.toString());
        if (S.contains((CharSequence)annoColumn, (CharSequence)".")) {
            String tableName = S.substringBefore((String)annoColumn, (String)".");
            if (tableName.equals("this")) {
                annoColumn = "self." + S.substringAfter((String)annoColumn, (String)"this.");
            } else if (!tableName.equals("self")) {
                if (tableName.equals(joiner.getMiddleTable())) {
                    annoColumn = joiner.getMiddleTableAlias() + "." + S.substringAfter((String)annoColumn, (String)".");
                } else {
                    log.warn("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6: {}", (Object)annoColumn);
                }
            }
        } else {
            annoColumn = joiner.getAlias() + "." + annoColumn;
        }
        return annoColumn;
    }
}

