/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.parser;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.entity.BaseEntity;
import com.diboot.core.entity.BaseModel;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class PropInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PropInfo.class);
    private static final long serialVersionUID = 5921667308129991326L;
    private String idColumn;
    private Class<?> idFieldType;
    private String deletedColumn;
    private final List<String> columns = new ArrayList<String>();
    private final Map<String, String> fieldToColumnMap = new LinkedCaseInsensitiveMap();
    private final Map<String, String> columnToFieldMap = new HashMap<String, String>();
    private final Map<String, Class> columnToFieldTypeMap = new HashMap<String, Class>();
    private final List<String> fillUpdateFieldList = new ArrayList<String>();

    public PropInfo(Class<?> beanClass) {
        this(beanClass, true);
    }

    public PropInfo(Class<?> beanClass, boolean isEntityClass) {
        List<Field> fields = BeanUtils.extractAllFields(beanClass, true);
        if (V.notEmpty(fields)) {
            for (Field fld : fields) {
                TableId tableId;
                String fldName = fld.getName();
                String columnName = null;
                TableField tableField = fld.getAnnotation(TableField.class);
                if (tableField != null) {
                    if (!tableField.exist()) continue;
                    columnName = V.notEmpty(tableField.value()) ? tableField.value() : S.toSnakeCase(fldName);
                    FieldFill fill = tableField.fill();
                    if (FieldFill.UPDATE.equals((Object)fill) || FieldFill.INSERT_UPDATE.equals((Object)fill)) {
                        this.fillUpdateFieldList.add(fldName);
                    }
                }
                if ((tableId = fld.getAnnotation(TableId.class)) != null && this.idColumn == null) {
                    if (V.notEmpty(tableId.value())) {
                        columnName = tableId.value();
                    } else if (columnName == null) {
                        columnName = S.toSnakeCase(fldName);
                    }
                    this.idColumn = columnName;
                    this.idFieldType = beanClass.isAssignableFrom(BaseEntity.class) ? Long.class : fld.getType();
                } else {
                    TableLogic tableLogic = fld.getAnnotation(TableLogic.class);
                    if (tableLogic != null) {
                        if (columnName == null) {
                            columnName = S.toSnakeCase(fldName);
                        }
                        this.deletedColumn = columnName;
                        if (V.notEmpty(tableLogic.value())) {
                            BaseConfig.setActiveFlagValue(tableLogic.value());
                        }
                    }
                }
                if (columnName == null && isEntityClass) {
                    columnName = S.toSnakeCase(fldName);
                }
                this.fieldToColumnMap.put(fldName, columnName);
                if (!V.notEmpty(columnName)) continue;
                this.columnToFieldMap.put(columnName, fldName);
                if (columnName.equals(this.idColumn)) {
                    if (beanClass.isAssignableFrom(BaseModel.class)) {
                        this.columnToFieldTypeMap.put(columnName, String.class);
                    } else {
                        Class<?> idType = BeanUtils.getGenericityClass(beanClass, 0);
                        if (idType == null) {
                            idType = fld.getType();
                        }
                        this.columnToFieldTypeMap.put(columnName, idType);
                    }
                } else {
                    this.columnToFieldTypeMap.put(columnName, fld.getType());
                }
                this.columns.add(columnName);
            }
        }
    }

    public String getFieldByColumn(String columnName) {
        if (V.isEmpty(this.columnToFieldMap)) {
            return null;
        }
        return this.columnToFieldMap.get(columnName);
    }

    public String getColumnByField(String fieldName) {
        if (V.isEmpty(this.fieldToColumnMap)) {
            return null;
        }
        String column = this.fieldToColumnMap.get(fieldName);
        if (column == null) {
            log.debug("\u672a\u627e\u5230\u5b57\u6bb5 {} \u5bf9\u5e94\u7684 \u5217\u540d", (Object)fieldName);
        }
        return column;
    }

    public boolean containsField(String fieldName) {
        if (V.isEmpty(this.fieldToColumnMap)) {
            return false;
        }
        return this.fieldToColumnMap.containsKey(fieldName);
    }

    public String getIdFieldName() {
        if (V.isEmpty(this.columnToFieldMap)) {
            return null;
        }
        return this.columnToFieldMap.get(this.idColumn);
    }

    public Class<?> getFieldTypeByColumn(String columnName) {
        if (V.isEmpty(this.columnToFieldTypeMap)) {
            return null;
        }
        return this.columnToFieldTypeMap.get(columnName);
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public Class<?> getIdFieldType() {
        return this.idFieldType;
    }

    public String getDeletedColumn() {
        return this.deletedColumn;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public Map<String, String> getFieldToColumnMap() {
        return this.fieldToColumnMap;
    }

    public Map<String, String> getColumnToFieldMap() {
        return this.columnToFieldMap;
    }

    public Map<String, Class> getColumnToFieldTypeMap() {
        return this.columnToFieldTypeMap;
    }

    public List<String> getFillUpdateFieldList() {
        return this.fillUpdateFieldList;
    }
}

