/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.parser;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.io.Serializable;
import org.springframework.core.annotation.AnnotationUtils;

public class EntityInfoCache
implements Serializable {
    private static final long serialVersionUID = 4102769515630377456L;
    private String tableName;
    private String entityClassName;
    private PropInfo propInfo;
    private Class<?> entityClass;
    private String serviceBeanName;
    private Class<? extends BaseMapper> mapperClass;

    public EntityInfoCache(Class<?> entityClass, String serviceBeanName) {
        this.entityClass = entityClass;
        this.entityClassName = entityClass.getName();
        this.propInfo = BindingCacheManager.getPropInfoByClass(entityClass);
        TableName tableNameAnno = (TableName)AnnotationUtils.findAnnotation(entityClass, TableName.class);
        this.tableName = tableNameAnno != null && V.notEmpty(tableNameAnno.value()) ? tableNameAnno.value() : S.toSnakeCase(entityClass.getSimpleName());
        this.serviceBeanName = serviceBeanName;
    }

    public void setService(String serviceBeanName) {
        this.serviceBeanName = serviceBeanName;
    }

    public IService getService() {
        return this.serviceBeanName == null ? null : (IService)ContextHolder.getApplicationContext().getBean(this.serviceBeanName);
    }

    public void setBaseMapper(Class<? extends BaseMapper> mapper) {
        this.mapperClass = mapper;
    }

    public BaseMapper getBaseMapper() {
        return this.mapperClass == null ? this.getService().getBaseMapper() : ContextHolder.getBean(this.mapperClass);
    }

    public String getFieldByColumn(String columnName) {
        if (this.propInfo == null) {
            return null;
        }
        return this.propInfo.getFieldByColumn(columnName);
    }

    public String getColumnByField(String fieldName) {
        if (this.propInfo == null) {
            return null;
        }
        return this.propInfo.getColumnByField(fieldName);
    }

    public String getIdColumn() {
        if (this.propInfo == null) {
            return null;
        }
        return this.propInfo.getIdColumn();
    }

    public String getDeletedColumn() {
        if (this.propInfo == null) {
            return null;
        }
        return this.propInfo.getDeletedColumn();
    }

    public boolean containsColumn(String column) {
        return this.propInfo.getColumns().contains(column);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public PropInfo getPropInfo() {
        return this.propInfo;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getServiceBeanName() {
        return this.serviceBeanName;
    }

    public Class<? extends BaseMapper> getMapperClass() {
        return this.mapperClass;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setEntityClassName(String entityClassName) {
        this.entityClassName = entityClassName;
    }

    public void setPropInfo(PropInfo propInfo) {
        this.propInfo = propInfo;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public void setServiceBeanName(String serviceBeanName) {
        this.serviceBeanName = serviceBeanName;
    }

    public void setMapperClass(Class<? extends BaseMapper> mapperClass) {
        this.mapperClass = mapperClass;
    }
}

