/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.helper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.extension.conditions.query.ChainQuery;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.query.Comparison;
import com.diboot.core.data.copy.Accept;
import com.diboot.core.util.JSON;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperHelper {
    private static final Logger log = LoggerFactory.getLogger(WrapperHelper.class);

    public static void buildQueryCriteria(QueryWrapper<?> wrapper, Comparison comparison, String columnName, Object value) {
        switch (comparison) {
            case EQ: {
                wrapper.eq((Object)columnName, value);
                break;
            }
            case IN: {
                if (value.getClass().isArray()) {
                    Object[] valueArray = (Object[])value;
                    if (valueArray.length == 1) {
                        wrapper.eq((Object)columnName, valueArray[0]);
                        break;
                    }
                    if (valueArray.length < 2) break;
                    wrapper.in((Object)columnName, valueArray);
                    break;
                }
                if (value instanceof Collection) {
                    wrapper.in(!((Collection)value).isEmpty(), (Object)columnName, (Collection)value);
                    break;
                }
                log.warn("\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef\uff1aIN\u4ec5\u652f\u6301List\u53ca\u6570\u7ec4.");
                break;
            }
            case NOT_IN: {
                if (value.getClass().isArray()) {
                    Object[] valueArray = (Object[])value;
                    if (valueArray.length == 1) {
                        wrapper.ne((Object)columnName, valueArray[0]);
                        break;
                    }
                    if (valueArray.length < 2) break;
                    wrapper.notIn((Object)columnName, valueArray);
                    break;
                }
                if (value instanceof Collection) {
                    wrapper.notIn(!((Collection)value).isEmpty(), (Object)columnName, (Collection)value);
                    break;
                }
                log.warn("\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef\uff1aNOT_IN\u4ec5\u652f\u6301List\u53ca\u6570\u7ec4.");
                break;
            }
            case CONTAINS: {
                boolean isString = S.contains((CharSequence)JSON.toJSONString(value), (CharSequence)"\"");
                BiConsumer<QueryWrapper, String> basicTypeProtection = (query, val) -> {
                    ((QueryWrapper)query.or()).likeRight((Object)columnName, (Object)("[" + val + ","));
                    ((QueryWrapper)query.or()).like((Object)columnName, (Object)("," + val + ","));
                    ((QueryWrapper)query.or()).likeLeft((Object)columnName, (Object)("," + val + "]"));
                    ((QueryWrapper)query.or()).eq((Object)columnName, (Object)("[" + val + "]"));
                };
                if (value instanceof Collection) {
                    wrapper.and(query -> {
                        for (Object val : (Collection)value) {
                            if (isString) {
                                if (!S.valueOf(val).contains("\"")) {
                                    val = "\"" + val + "\"";
                                }
                                ((QueryWrapper)query.or()).like((Object)columnName, val);
                                continue;
                            }
                            basicTypeProtection.accept((QueryWrapper)query, S.valueOf(val));
                        }
                    });
                    break;
                }
                if (value.getClass().isArray()) {
                    wrapper.and(query -> {
                        for (Object val : (Object[])value) {
                            if (isString) {
                                if (!S.valueOf(val).contains("\"")) {
                                    val = "\"" + val + "\"";
                                }
                                ((QueryWrapper)query.or()).like((Object)columnName, val);
                                continue;
                            }
                            basicTypeProtection.accept((QueryWrapper)query, S.valueOf(val));
                        }
                    });
                    break;
                }
                if (isString) {
                    wrapper.like((Object)columnName, value);
                    break;
                }
                wrapper.and(query -> basicTypeProtection.accept((QueryWrapper)query, S.valueOf(value)));
                break;
            }
            case LIKE: {
                wrapper.like((Object)columnName, value);
                break;
            }
            case STARTSWITH: {
                wrapper.likeRight((Object)columnName, value);
                break;
            }
            case ENDSWITH: {
                wrapper.likeLeft((Object)columnName, value);
                break;
            }
            case GT: {
                wrapper.gt((Object)columnName, value);
                break;
            }
            case BETWEEN_BEGIN: 
            case GE: {
                wrapper.ge((Object)columnName, value);
                break;
            }
            case LT: {
                wrapper.lt((Object)columnName, value);
                break;
            }
            case BETWEEN_END: 
            case LE: {
                wrapper.le((Object)columnName, value);
                break;
            }
            case BETWEEN: {
                if (value.getClass().isArray()) {
                    Object[] valueArray = (Object[])value;
                    if (valueArray.length == 1) {
                        wrapper.ge((Object)columnName, valueArray[0]);
                        break;
                    }
                    if (valueArray.length < 2) break;
                    wrapper.between((Object)columnName, valueArray[0], valueArray[1]);
                    break;
                }
                if (value instanceof List) {
                    List valueList = (List)value;
                    if (valueList.size() == 1) {
                        wrapper.ge((Object)columnName, valueList.get(0));
                        break;
                    }
                    if (valueList.size() < 2) break;
                    wrapper.between((Object)columnName, valueList.get(0), valueList.get(1));
                    break;
                }
                if (value instanceof String && ((String)value).contains(",")) {
                    String[] valueArray = ((String)value).split(",");
                    wrapper.between((Object)columnName, (Object)valueArray[0], (Object)valueArray[1]);
                    break;
                }
                wrapper.ge((Object)columnName, value);
                break;
            }
            case NOT_EQ: {
                wrapper.ne((Object)columnName, value);
                break;
            }
            case IS_NULL: {
                wrapper.isNull((Object)columnName);
                break;
            }
            case IS_NOT_NULL: {
                wrapper.isNotNull((Object)columnName);
                break;
            }
        }
    }

    public static void buildOrderBy(QueryWrapper<?> query, String orderBy, Function<String, String> field2column) {
        if (V.notEmpty(orderBy)) {
            for (String field : S.split((String)orderBy, (String)",")) {
                V.securityCheck(field);
                String[] fieldAndOrder = field.split(":");
                String columnName = field2column.apply(fieldAndOrder[0]);
                if (fieldAndOrder.length > 1 && "DESC".equalsIgnoreCase(fieldAndOrder[1])) {
                    query.orderByDesc((Object)columnName);
                    continue;
                }
                query.orderByAsc((Object)columnName);
            }
        }
    }

    public static void optimizeSelect(Wrapper<?> query, Class<?> entityClass, Class<?> voClass) {
        if (query.getSqlSelect() != null) {
            return;
        }
        if (query instanceof Query) {
            ((Query)query).select(entityClass, WrapperHelper.buildSelectPredicate(voClass));
        } else if (query instanceof ChainQuery) {
            Wrapper queryWrapper = ((ChainQuery)query).getWrapper();
            ((Query)queryWrapper).select(entityClass, WrapperHelper.buildSelectPredicate(voClass));
        }
    }

    public static Predicate<TableFieldInfo> buildSelectPredicate(Class<?> voClass) {
        List fieldList = BindingCacheManager.getFields(voClass).stream().flatMap(field -> {
            Accept accept = field.getAnnotation(Accept.class);
            return accept == null ? Stream.of(field.getName()) : (accept.override() ? Stream.of(accept.name()) : Stream.of(field.getName(), accept.name()));
        }).collect(Collectors.toList());
        return fieldInfo -> fieldList.contains(fieldInfo.getField().getName()) && !fieldInfo.isLogicDelete();
    }
}

