/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.cache;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.diboot.core.binding.parser.EntityInfoCache;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.cache.StaticMemoryCacheManager;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.util.init.BeanInitUtils;
import com.diboot.core.util.init.BeanInitializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;

public class BindingCacheManager {
    private static final Logger log = LoggerFactory.getLogger(BindingCacheManager.class);
    private static final String CACHE_NAME_CLASS_ENTITY = "CLASS_ENTITY";
    private static final String CACHE_NAME_TABLE_ENTITY = "TABLE_ENTITY";
    private static final String CACHE_NAME_CLASS_PROP = "CLASS_PROP";
    private static final String CACHE_NAME_ENTITYNAME_CLASS = "NAME_CLASS";
    private static final String CACHE_NAME_CLASS_FIELDS = "CLASS_FIELDS";
    private static final String CACHE_NAME_CLASS_NAME2FLDMAP = "CLASS_NAME2FLDMAP";
    private static final BeanInitializer<StaticMemoryCacheManager> CACHE_MANAGER_INITIALIZER = BeanInitUtils.lazyInit(() -> new StaticMemoryCacheManager(CACHE_NAME_CLASS_ENTITY, CACHE_NAME_TABLE_ENTITY, CACHE_NAME_CLASS_PROP, CACHE_NAME_ENTITYNAME_CLASS, CACHE_NAME_CLASS_FIELDS, CACHE_NAME_CLASS_NAME2FLDMAP));
    private static final BeanInitializer<Void> ENTITY_INFO_CACHE_INITIALIZER = BeanInitUtils.lazyInit(() -> {
        Collection mappers;
        StaticMemoryCacheManager cacheManager = BindingCacheManager.getCacheManager();
        Map serviceMap = ContextHolder.getApplicationContext().getBeansOfType(IService.class);
        HashSet<String> uniqueEntitySet = new HashSet<String>();
        if (V.notEmpty(serviceMap)) {
            for (Map.Entry entry : serviceMap.entrySet()) {
                EntityInfoCache entityInfoCache;
                Class entityClass = BeanUtils.getGenericityClass(entry.getValue(), 1);
                if (entityClass == null) continue;
                IService entityIService = (IService)entry.getValue();
                if (uniqueEntitySet.contains(entityClass.getName())) {
                    if (entityIService.getClass().getAnnotation(Primary.class) != null) {
                        entityInfoCache = cacheManager.getCacheObj(CACHE_NAME_CLASS_ENTITY, (Object)entityClass.getName(), EntityInfoCache.class);
                        if (entityInfoCache == null) continue;
                        entityInfoCache.setService((String)entry.getKey());
                        continue;
                    }
                    log.warn("Entity: {} \u5b58\u5728\u591a\u4e2aservice\u5b9e\u73b0\u7c7b\uff0c\u53ef\u80fd\u5bfc\u81f4\u8c03\u7528\u5b9e\u4f8b\u4e0e\u9884\u671f\u4e0d\u4e00\u81f4!", (Object)entityClass.getName());
                    continue;
                }
                entityInfoCache = new EntityInfoCache(entityClass, (String)entry.getKey());
                cacheManager.putCacheObj(CACHE_NAME_CLASS_ENTITY, entityClass.getName(), entityInfoCache);
                cacheManager.putCacheObj(CACHE_NAME_TABLE_ENTITY, entityInfoCache.getTableName(), entityInfoCache);
                cacheManager.putCacheObj(CACHE_NAME_ENTITYNAME_CLASS, entityClass.getSimpleName(), entityClass);
                uniqueEntitySet.add(entityClass.getName());
            }
        } else {
            log.debug("\u672a\u83b7\u53d6\u5230\u4efb\u4f55\u6709\u6548@Service.");
        }
        SqlSessionFactory sqlSessionFactory = ContextHolder.getBean(SqlSessionFactory.class);
        if (sqlSessionFactory != null && V.notEmpty(mappers = sqlSessionFactory.getConfiguration().getMapperRegistry().getMappers())) {
            for (Class mapperClass : mappers) {
                Type[] types = mapperClass.getGenericInterfaces();
                try {
                    String entityClassName;
                    ParameterizedType genericType;
                    Type[] superTypes;
                    if (types.length <= 0 || types[0] == null || !(types[0] instanceof ParameterizedType) || (superTypes = (genericType = (ParameterizedType)types[0]).getActualTypeArguments()) == null || superTypes.length <= 0 || superTypes[0] == null || uniqueEntitySet.contains(entityClassName = superTypes[0].getTypeName()) || entityClassName.length() <= 1) continue;
                    Class<?> entityClass = Class.forName(entityClassName);
                    EntityInfoCache entityInfoCache = new EntityInfoCache(entityClass, null);
                    entityInfoCache.setBaseMapper(mapperClass);
                    cacheManager.putCacheObj(CACHE_NAME_CLASS_ENTITY, entityClass.getName(), entityInfoCache);
                    cacheManager.putCacheObj(CACHE_NAME_TABLE_ENTITY, entityInfoCache.getTableName(), entityInfoCache);
                    cacheManager.putCacheObj(CACHE_NAME_ENTITYNAME_CLASS, entityClass.getSimpleName(), entityClass);
                    uniqueEntitySet.add(entityClass.getName());
                }
                catch (Exception e) {
                    log.warn("\u89e3\u6790mapper\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return null;
    });

    private static StaticMemoryCacheManager getCacheManager() {
        return CACHE_MANAGER_INITIALIZER.get();
    }

    public static EntityInfoCache getEntityInfoByTable(String tableName) {
        BindingCacheManager.initEntityInfoCache();
        return BindingCacheManager.getCacheManager().getCacheObj(CACHE_NAME_TABLE_ENTITY, (Object)tableName, EntityInfoCache.class);
    }

    public static EntityInfoCache getEntityInfoByClass(Class<?> entityClazz) {
        BindingCacheManager.initEntityInfoCache();
        return BindingCacheManager.getCacheManager().getCacheObj(CACHE_NAME_CLASS_ENTITY, (Object)entityClazz.getName(), EntityInfoCache.class);
    }

    public static PropInfo getPropInfoByClass(Class<?> beanClazz) {
        return BindingCacheManager.getCacheManager().getCacheObj(CACHE_NAME_CLASS_PROP, (Object)beanClazz.getName(), () -> new PropInfo(beanClazz));
    }

    public static PropInfo getPropInfoByTable(String tableName) {
        Class<?> entityClass = BindingCacheManager.getEntityClassByTable(tableName);
        if (entityClass != null) {
            return BindingCacheManager.getPropInfoByClass(entityClass);
        }
        return null;
    }

    public static Class<?> getEntityClassByTable(String tableName) {
        EntityInfoCache entityInfoCache = BindingCacheManager.getEntityInfoByTable(tableName);
        return entityInfoCache != null ? entityInfoCache.getEntityClass() : null;
    }

    public static Class<?> getEntityClassBySimpleName(String classSimpleName) {
        BindingCacheManager.initEntityInfoCache();
        return BindingCacheManager.getCacheManager().getCacheObj(CACHE_NAME_ENTITYNAME_CLASS, (Object)classSimpleName, Class.class);
    }

    public static BaseMapper getMapperByTable(String table) {
        EntityInfoCache entityInfoCache = BindingCacheManager.getEntityInfoByTable(table);
        if (entityInfoCache != null) {
            return entityInfoCache.getBaseMapper();
        }
        return null;
    }

    public static BaseMapper getMapperByClass(Class<?> entityClazz) {
        EntityInfoCache entityInfoCache = BindingCacheManager.getEntityInfoByClass(entityClazz);
        if (entityInfoCache != null) {
            return entityInfoCache.getBaseMapper();
        }
        return null;
    }

    public static List<Field> getFields(Class<?> beanClazz) {
        return BindingCacheManager.getCacheManager().getCacheObj(CACHE_NAME_CLASS_FIELDS, (Object)beanClazz.getName(), () -> BeanUtils.extractAllFields(beanClazz, true));
    }

    public static List<Field> getFields(Class<?> beanClazz, Class<? extends Annotation> annotation) {
        String key = S.joinWith((String)",", (Object[])new Object[]{beanClazz.getName(), annotation.getName()});
        return BindingCacheManager.getCacheManager().getCacheObj(CACHE_NAME_CLASS_FIELDS, (Object)key, () -> BeanUtils.extractFields(beanClazz, annotation));
    }

    public static Map<String, Field> getFieldsMap(Class<?> beanClazz) {
        return BindingCacheManager.getCacheManager().getCacheObj(CACHE_NAME_CLASS_NAME2FLDMAP, (Object)beanClazz.getName(), () -> BeanUtils.convertToStringKeyObjectMap(BindingCacheManager.getFields(beanClazz), "name"));
    }

    private static void initEntityInfoCache() {
        ENTITY_INFO_CACHE_INITIALIZER.get();
    }
}

