/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder.remote;

import com.diboot.core.binding.binder.remote.RemoteBindDTO;
import com.diboot.core.binding.binder.remote.RemoteBindingProvider;
import com.diboot.core.binding.binder.remote.RemoteBindingProviderFactory;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.V;
import com.diboot.core.vo.JsonResult;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBindingManager {
    private static final Logger log = LoggerFactory.getLogger(RemoteBindingManager.class);
    private static Map<String, RemoteBindingProvider> MODULE_PROVIDER_MAP;

    public static <T> List<T> fetchEntityList(String module, RemoteBindDTO remoteBindDTO, Class<T> entityClass) {
        remoteBindDTO.setResultType("Entity");
        RemoteBindingProvider bindingProvider = RemoteBindingManager.getRemoteBindingProvider(module);
        JsonResult<String> jsonResult = bindingProvider.loadBindingData(remoteBindDTO);
        if (V.equals(jsonResult.getCode(), 0)) {
            log.debug("\u83b7\u53d6\u5230\u7ed1\u5b9a\u6570\u636e: {}", (Object)jsonResult.getData());
            List<T> entityList = JSON.parseArray(jsonResult.getData(), entityClass);
            return entityList;
        }
        log.warn("\u83b7\u53d6\u7ed1\u5b9a\u6570\u636e\u5931\u8d25: {}", (Object)jsonResult.getMsg());
        return Collections.EMPTY_LIST;
    }

    public static List<Map<String, Object>> fetchMapList(String module, RemoteBindDTO remoteBindDTO) {
        remoteBindDTO.setResultType("Entity");
        RemoteBindingProvider bindingProvider = RemoteBindingManager.getRemoteBindingProvider(module);
        JsonResult<String> jsonResult = bindingProvider.loadBindingData(remoteBindDTO);
        if (V.equals(jsonResult.getCode(), 0)) {
            log.debug("\u83b7\u53d6\u5230\u7ed1\u5b9a\u6570\u636e: {}", (Object)jsonResult.getData());
            return JSON.parseArray(jsonResult.getData(), new TypeReference<List<Map<String, Object>>>(){});
        }
        log.warn("\u83b7\u53d6\u7ed1\u5b9a\u6570\u636e\u5931\u8d25: {}", (Object)jsonResult.getMsg());
        return Collections.EMPTY_LIST;
    }

    private static synchronized RemoteBindingProvider getRemoteBindingProvider(String module) {
        if (MODULE_PROVIDER_MAP == null) {
            MODULE_PROVIDER_MAP = new ConcurrentHashMap<String, RemoteBindingProvider>();
        }
        return MODULE_PROVIDER_MAP.computeIfAbsent(module, key -> {
            RemoteBindingProviderFactory factory = ContextHolder.getBean(RemoteBindingProviderFactory.class);
            if (factory == null) {
                throw new InvalidUsageException("RemoteBindingProviderFactory \u672a\u5b9e\u73b0\uff0c\u65e0\u6cd5\u4f7f\u7528\u8fdc\u7a0b\u7ed1\u5b9a\u529f\u80fd\uff01", new Object[0]);
            }
            return factory.create(module);
        });
    }
}

