/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder.remote;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.diboot.core.binding.binder.remote.RemoteBindDTO;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.helper.WrapperHelper;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.service.BaseService;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.V;
import com.diboot.core.vo.JsonResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBindQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(RemoteBindQueryExecutor.class);

    public static JsonResult execute(RemoteBindDTO remoteBindDTO) {
        Class<?> entityClass;
        try {
            entityClass = Class.forName(remoteBindDTO.getEntityClassName());
        }
        catch (Exception e2) {
            log.error("\u65e0\u6cd5\u627e\u5230Entity\u7c7b: {}", (Object)remoteBindDTO.getEntityClassName(), (Object)e2);
            return JsonResult.FAIL_INVALID_PARAM("\u6a21\u5757\u4e0b\u65e0Entity\u7c7b: " + remoteBindDTO.getEntityClassName());
        }
        Collection<?> inConditionValues = remoteBindDTO.getInConditionValues();
        if (inConditionValues == null) {
            return JsonResult.OK();
        }
        if (inConditionValues.isEmpty()) {
            return JsonResult.OK(Collections.emptyList());
        }
        String refJoinCol = remoteBindDTO.getRefJoinCol();
        PropInfo propInfo = BindingCacheManager.getPropInfoByClass(entityClass);
        Class<?> idFieldType = propInfo.getFieldTypeByColumn(refJoinCol);
        Collection formatInValues = BeanUtils.convertIdValuesToType(inConditionValues, idFieldType);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntityClass(entityClass);
        if (V.notEmpty(remoteBindDTO.getSelectColumns())) {
            queryWrapper.select(remoteBindDTO.getSelectColumns());
        }
        queryWrapper.in((Object)refJoinCol, formatInValues);
        queryWrapper.and(V.notEmpty(remoteBindDTO.getAdditionalConditions()), e -> remoteBindDTO.getAdditionalConditions().forEach(x$0 -> e.apply(x$0, new Object[0])));
        WrapperHelper.buildOrderBy(queryWrapper, remoteBindDTO.getOrderBy(), e -> e);
        try {
            String jsonStr = null;
            if ("Map".equals(remoteBindDTO.getResultType())) {
                List<Map<String, Object>> resultMap = RemoteBindQueryExecutor.getMapList(entityClass, (Wrapper)queryWrapper);
                jsonStr = JSON.stringify(resultMap);
            } else if ("Entity".equals(remoteBindDTO.getResultType())) {
                List resultList = RemoteBindQueryExecutor.getEntityList(entityClass, (Wrapper)queryWrapper);
                jsonStr = JSON.stringify(resultList);
            }
            return JsonResult.OK(jsonStr);
        }
        catch (Exception e3) {
            log.error("\u7ed1\u5b9a\u67e5\u8be2\u6267\u884c\u5f02\u5e38", (Throwable)e3);
            return JsonResult.FAIL_EXCEPTION("\u7ed1\u5b9a\u67e5\u8be2\u6267\u884c\u5f02\u5e38: " + e3.getMessage());
        }
    }

    private static List<Map<String, Object>> getMapList(Class entityClass, Wrapper queryWrapper) {
        IService referencedService = ContextHolder.getIServiceByEntity(entityClass);
        if (referencedService instanceof BaseService) {
            return ((BaseService)referencedService).getMapList(queryWrapper);
        }
        List list = referencedService.listMaps(queryWrapper);
        return RemoteBindQueryExecutor.checkedList(list);
    }

    private static <T> List<T> getEntityList(Class entityClass, Wrapper queryWrapper) {
        IService referencedService = ContextHolder.getIServiceByEntity(entityClass);
        if (referencedService instanceof BaseService) {
            return ((BaseService)referencedService).getEntityList(queryWrapper);
        }
        List list = referencedService.list(queryWrapper);
        return RemoteBindQueryExecutor.checkedList(list);
    }

    private static List checkedList(List list) {
        if (list == null) {
            list = Collections.emptyList();
        } else if (list.size() > BaseConfig.getBatchSize()) {
            log.warn("\u5355\u6b21\u67e5\u8be2\u8bb0\u5f55\u6570\u91cf\u8fc7\u5927\uff0c\u8fd4\u56de\u7ed3\u679c\u6570={}\uff0c\u8bf7\u68c0\u67e5\uff01", (Object)list.size());
        }
        return list;
    }
}

