/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.diboot.core.binding.annotation.BindFieldList;
import com.diboot.core.binding.binder.FieldBinder;
import com.diboot.core.binding.binder.remote.RemoteBindingManager;
import com.diboot.core.binding.helper.ResultAssembler;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;

public class FieldListBinder<T>
extends FieldBinder<T> {
    private static final Logger log = LoggerFactory.getLogger(FieldListBinder.class);

    public FieldListBinder(BindFieldList annotation, List voList) {
        super(annotation.entity(), voList);
        if (V.notEmpty(annotation.splitBy())) {
            this.splitBy = annotation.splitBy();
        }
        if (V.notEmpty(annotation.orderBy())) {
            this.orderBy = annotation.orderBy();
        }
    }

    @Override
    public void bind() {
        if (V.isEmpty(this.annoObjectList)) {
            return;
        }
        if (V.isEmpty(this.refObjJoinCols)) {
            throw new InvalidUsageException("\u8c03\u7528\u9519\u8bef\uff1a\u65e0\u6cd5\u4ececondition\u4e2d\u89e3\u6790\u51fa\u5b57\u6bb5\u5173\u8054.", new Object[0]);
        }
        if (this.referencedGetterFieldNameList == null) {
            throw new InvalidUsageException("\u8c03\u7528\u9519\u8bef\uff1a\u5b57\u6bb5\u7ed1\u5b9a\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5field.", new Object[0]);
        }
        HashMap<String, List> valueEntityListMap = new HashMap();
        if (this.middleTable == null) {
            super.simplifySelectColumns();
            super.buildQueryWrapperJoinOn();
            if (this.queryWrapper.isEmptyOfNormal()) {
                return;
            }
            this.appendOrderBy(this.remoteBindDTO);
            List entityList = V.isEmpty(this.module) ? this.getEntityList((Wrapper)this.queryWrapper) : RemoteBindingManager.fetchEntityList(this.module, this.remoteBindDTO, this.referencedEntityClass);
            if (V.notEmpty(entityList)) {
                valueEntityListMap = this.buildMatchKey2FieldListMap(entityList);
            }
            ResultAssembler.bindFieldListPropValue(super.getMatchedAnnoObjectList(), this.getAnnoObjJoinFlds(), valueEntityListMap, this.annoObjectSetterPropNameList, this.referencedGetterFieldNameList, this.splitBy);
        } else {
            List entityList;
            if (this.refObjJoinCols.size() > 1) {
                throw new InvalidUsageException("\u4e2d\u95f4\u8868\u5173\u8054\u6682\u4e0d\u652f\u6301\u6d89\u53ca\u76ee\u6807\u8868\u591a\u5217\u7684\u60c5\u51b5!", new Object[0]);
            }
            Map<String, List> trunkObjCol2ValuesMap = super.buildTrunkObjCol2ValuesMap();
            Map<String, List> middleTableResultMap = this.middleTable.executeOneToManyQuery(trunkObjCol2ValuesMap);
            if (V.isEmpty(middleTableResultMap)) {
                return;
            }
            super.simplifySelectColumns();
            this.appendOrderBy(this.remoteBindDTO);
            List entityIdList = this.extractIdValueFromMap(middleTableResultMap);
            if (V.notEmpty(this.splitBy)) {
                Class<?> fieldType = this.refObjPropInfo.getFieldTypeByColumn((String)this.refObjJoinCols.get(0));
                entityIdList = ResultAssembler.unpackValueList(entityIdList, this.splitBy, fieldType);
            }
            String refObjJoinOnCol = (String)this.refObjJoinCols.get(0);
            if (V.isEmpty(this.module)) {
                this.queryWrapper.in((Object)refObjJoinOnCol, (Collection)entityIdList);
                entityList = this.getEntityList((Wrapper)this.queryWrapper);
            } else {
                this.remoteBindDTO.setRefJoinCol(refObjJoinOnCol).setInConditionValues(entityIdList);
                entityList = RemoteBindingManager.fetchEntityList(this.module, this.remoteBindDTO, this.referencedEntityClass);
            }
            if (V.isEmpty(entityList)) {
                return;
            }
            String refObjJoinOnField = this.toRefObjField(refObjJoinOnCol);
            Map entityMap = BeanUtils.convertToStringKeyObjectListMap(entityList, refObjJoinOnField);
            for (Map.Entry<String, List> entry : middleTableResultMap.entrySet()) {
                List annoObjFKList = entry.getValue();
                if (V.isEmpty(annoObjFKList)) continue;
                ArrayList valueList = new ArrayList();
                for (Object obj : annoObjFKList) {
                    String valStr = String.valueOf(obj);
                    List ent = entityMap.get(valStr);
                    if (ent != null) {
                        valueList.addAll(ent);
                        continue;
                    }
                    if (!V.notEmpty(this.splitBy) || !valStr.contains(this.splitBy)) continue;
                    for (String key : valStr.split(this.splitBy)) {
                        ent = entityMap.get(key);
                        if (ent == null) continue;
                        valueList.addAll(ent);
                    }
                }
                valueEntityListMap.put(entry.getKey(), valueList);
            }
            this.bindPropValue(super.getMatchedAnnoObjectList(), this.middleTable.getTrunkObjColMapping(), valueEntityListMap);
        }
    }

    private <E> void bindPropValue(List<E> fromList, Map<String, String> trunkObjColMapping, Map<String, List> valueMatchMap) {
        if (V.isEmpty(fromList) || V.isEmpty(valueMatchMap)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (E object : fromList) {
                boolean appendComma = false;
                sb.setLength(0);
                for (Map.Entry<String, String> entry : trunkObjColMapping.entrySet()) {
                    String getterField = this.toAnnoObjField(entry.getKey());
                    String fieldValue = BeanUtils.getStringProperty(object, getterField);
                    if (appendComma) {
                        sb.append(",");
                    }
                    sb.append(fieldValue);
                    if (appendComma) continue;
                    appendComma = true;
                }
                List entityList = valueMatchMap.get(sb.toString());
                if (entityList == null) continue;
                BeanWrapper beanWrapper = BeanUtils.getBeanWrapper(object);
                for (int i = 0; i < this.annoObjectSetterPropNameList.size(); ++i) {
                    List valObjList = BeanUtils.collectToList(entityList, (String)this.referencedGetterFieldNameList.get(i));
                    beanWrapper.setPropertyValue((String)this.annoObjectSetterPropNameList.get(i), (Object)valObjList);
                }
            }
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u5c5e\u6027\u503c\u5f02\u5e38", (Throwable)e);
        }
    }

    private Map<String, List> buildMatchKey2FieldListMap(List<T> list) {
        HashMap<String, List> key2TargetListMap = new HashMap<String, List>(list.size());
        StringBuilder sb = new StringBuilder();
        for (T entity : list) {
            sb.setLength(0);
            for (int i = 0; i < this.refObjJoinCols.size(); ++i) {
                String refObjJoinOnCol = (String)this.refObjJoinCols.get(i);
                String fldValue = BeanUtils.getStringProperty(entity, this.toRefObjField(refObjJoinOnCol));
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fldValue);
            }
            String matchKey = sb.toString();
            ArrayList<T> entityList = (ArrayList<T>)key2TargetListMap.get(matchKey);
            if (entityList == null) {
                entityList = new ArrayList<T>();
                key2TargetListMap.put(matchKey, entityList);
            }
            entityList.add(entity);
        }
        sb.setLength(0);
        return key2TargetListMap;
    }
}

