/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.diboot.core.binding.annotation.BindEntityList;
import com.diboot.core.binding.binder.EntityBinder;
import com.diboot.core.binding.binder.remote.RemoteBindingManager;
import com.diboot.core.binding.helper.ResultAssembler;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityListBinder<T>
extends EntityBinder<T> {
    private static final Logger log = LoggerFactory.getLogger(EntityListBinder.class);

    public EntityListBinder(BindEntityList annotation, List voList) {
        super(annotation.entity(), voList);
        if (V.notEmpty(annotation.splitBy())) {
            this.splitBy = annotation.splitBy();
        }
        if (V.notEmpty(annotation.orderBy())) {
            this.orderBy = annotation.orderBy();
        }
    }

    public EntityListBinder(Class<T> entityClass, List voList) {
        super(entityClass, voList);
    }

    @Override
    public void bind() {
        if (V.isEmpty(this.annoObjectList)) {
            return;
        }
        if (V.isEmpty(this.refObjJoinCols)) {
            throw new InvalidUsageException("\u8c03\u7528\u9519\u8bef\uff1a\u65e0\u6cd5\u4ececondition\u4e2d\u89e3\u6790\u51fa\u5b57\u6bb5\u5173\u8054.", new Object[0]);
        }
        Map<Object, Object> valueEntityListMap = new HashMap();
        if (this.middleTable == null) {
            this.simplifySelectColumns();
            super.buildQueryWrapperJoinOn();
            if (this.queryWrapper.isEmptyOfNormal()) {
                return;
            }
            this.appendOrderBy(this.remoteBindDTO);
            List entityList = V.isEmpty(this.module) ? this.getEntityList((Wrapper)this.queryWrapper) : RemoteBindingManager.fetchEntityList(this.module, this.remoteBindDTO, this.referencedEntityClass);
            if (V.notEmpty(entityList)) {
                valueEntityListMap = this.buildMatchKey2EntityListMap(entityList);
            }
            ResultAssembler.bindPropValue(this.annoObjectField, super.getMatchedAnnoObjectList(), this.getAnnoObjJoinFlds(), valueEntityListMap, this.splitBy);
        } else {
            List entityList;
            if (this.refObjJoinCols.size() > 1) {
                throw new InvalidUsageException("\u4e2d\u95f4\u8868\u5173\u8054\u6682\u4e0d\u652f\u6301\u6d89\u53ca\u76ee\u6807\u8868\u591a\u5217\u7684\u60c5\u51b5!", new Object[0]);
            }
            Map<String, List> trunkObjCol2ValuesMap = super.buildTrunkObjCol2ValuesMap();
            Map<String, List> middleTableResultMap = this.middleTable.executeOneToManyQuery(trunkObjCol2ValuesMap);
            if (V.isEmpty(middleTableResultMap)) {
                return;
            }
            this.simplifySelectColumns();
            List entityIdList = this.extractIdValueFromMap(middleTableResultMap);
            if (V.notEmpty(this.splitBy)) {
                Class<?> fieldType = this.refObjPropInfo.getFieldTypeByColumn((String)this.refObjJoinCols.get(0));
                entityIdList = ResultAssembler.unpackValueList(entityIdList, this.splitBy, fieldType);
            }
            this.appendOrderBy(this.remoteBindDTO);
            String refObjJoinOnCol = (String)this.refObjJoinCols.get(0);
            if (V.isEmpty(this.module)) {
                this.queryWrapper.in((Object)refObjJoinOnCol, (Collection)entityIdList);
                entityList = this.getEntityList((Wrapper)this.queryWrapper);
            } else {
                this.remoteBindDTO.setRefJoinCol(refObjJoinOnCol).setInConditionValues(entityIdList);
                entityList = RemoteBindingManager.fetchEntityList(this.module, this.remoteBindDTO, this.referencedEntityClass);
            }
            if (V.isEmpty(entityList)) {
                return;
            }
            String refObjJoinOnField = this.toRefObjField(refObjJoinOnCol);
            Map entityMap = BeanUtils.convertToStringKeyObjectListMap(entityList, refObjJoinOnField);
            for (Map.Entry<String, List> entry : middleTableResultMap.entrySet()) {
                List annoObjFKList = entry.getValue();
                if (V.isEmpty(annoObjFKList)) continue;
                ArrayList<Object> valueList = new ArrayList<Object>();
                for (Object obj : annoObjFKList) {
                    if (obj == null) continue;
                    if (obj instanceof Collection) {
                        for (Object key : (Collection)obj) {
                            List ent = entityMap.get(S.valueOf(key));
                            if (ent == null) continue;
                            for (Object item : ent) {
                                valueList.add(this.cloneOrConvertBean(item));
                            }
                        }
                        continue;
                    }
                    String valStr = S.clearNonConst(String.valueOf(obj));
                    List ent = entityMap.get(valStr);
                    if (ent != null) {
                        for (Object item : ent) {
                            valueList.add(this.cloneOrConvertBean(item));
                        }
                        continue;
                    }
                    if (!V.notEmpty(this.splitBy) || !valStr.contains(this.splitBy)) continue;
                    for (String key : valStr.split(this.splitBy)) {
                        ent = entityMap.get(key);
                        if (ent == null) continue;
                        for (Object item : ent) {
                            valueList.add(this.cloneOrConvertBean(item));
                        }
                    }
                }
                valueEntityListMap.put(entry.getKey(), valueList);
            }
            ResultAssembler.bindEntityPropValue(this.annoObjectField, super.getMatchedAnnoObjectList(), this.middleTable.getTrunkObjColMapping(), valueEntityListMap, this.getAnnoObjColumnToFieldMap());
        }
    }

    private Map<String, List> buildMatchKey2EntityListMap(List<T> list) {
        HashMap<String, List> key2TargetListMap = new HashMap<String, List>(list.size());
        StringBuilder sb = new StringBuilder();
        for (T entity : list) {
            Object target;
            sb.setLength(0);
            for (int i = 0; i < this.refObjJoinCols.size(); ++i) {
                String refObjJoinOnCol = (String)this.refObjJoinCols.get(i);
                String pkValue = BeanUtils.getStringProperty(entity, this.toRefObjField(refObjJoinOnCol));
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(pkValue);
            }
            String matchKey = sb.toString();
            ArrayList<T> entityList = (ArrayList<T>)key2TargetListMap.get(matchKey);
            if (entityList == null) {
                entityList = new ArrayList<T>();
                key2TargetListMap.put(matchKey, entityList);
            }
            if (!((target = entity) instanceof Map)) {
                target = this.cloneOrConvertBean(entity);
            }
            entityList.add(target);
        }
        sb.setLength(0);
        return key2TargetListMap;
    }
}

