/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.diboot.core.binding.annotation.BindEntity;
import com.diboot.core.binding.binder.BaseBinder;
import com.diboot.core.binding.binder.remote.RemoteBindingManager;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.helper.ResultAssembler;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.data.copy.Accept;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ISetter;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBinder<T>
extends BaseBinder<T> {
    private static final Logger log = LoggerFactory.getLogger(EntityBinder.class);
    protected String annoObjectField;
    protected Class<?> annoObjectFieldClass;

    public EntityBinder(Class<T> entityClass, List voList) {
        super(entityClass, voList);
    }

    public EntityBinder(BindEntity annotation, List voList) {
        super(annotation.entity(), voList);
    }

    public <T1, R> BaseBinder<T> set(ISetter<T1, R> voSetter, Class annoObjectFieldClass) {
        return this.set(BeanUtils.convertToFieldName(voSetter), annoObjectFieldClass);
    }

    public BaseBinder<T> set(String annoObjectField, Class annoObjectFieldClass) {
        this.annoObjectField = this.toAnnoObjField(annoObjectField);
        this.annoObjectFieldClass = annoObjectFieldClass;
        return this;
    }

    @Override
    public void bind() {
        if (V.isEmpty(this.annoObjectList)) {
            return;
        }
        if (V.isEmpty(this.refObjJoinCols)) {
            throw new InvalidUsageException("\u8c03\u7528\u9519\u8bef\uff1a\u65e0\u6cd5\u4ececondition\u4e2d\u89e3\u6790\u51fa\u5b57\u6bb5\u5173\u8054.", new Object[0]);
        }
        if (this.middleTable == null) {
            this.simplifySelectColumns();
            super.buildQueryWrapperJoinOn();
            if (this.queryWrapper.isEmptyOfNormal()) {
                return;
            }
            List entityList = V.isEmpty(this.module) ? this.getEntityList((Wrapper)this.queryWrapper) : RemoteBindingManager.fetchEntityList(this.module, this.remoteBindDTO, this.referencedEntityClass);
            if (V.notEmpty(entityList)) {
                Map<String, Object> valueEntityMap = this.buildMatchKey2EntityMap(entityList);
                ResultAssembler.bindPropValue(this.annoObjectField, super.getMatchedAnnoObjectList(), this.getAnnoObjJoinFlds(), valueEntityMap, null);
            }
        } else {
            List entityList;
            if (this.refObjJoinCols.size() > 1) {
                throw new InvalidUsageException("\u4e2d\u95f4\u8868\u5173\u8054\u6682\u4e0d\u652f\u6301\u6d89\u53ca\u76ee\u6807\u8868\u591a\u5217\u7684\u60c5\u51b5!", new Object[0]);
            }
            Map<String, List> trunkObjCol2ValuesMap = super.buildTrunkObjCol2ValuesMap();
            Map<String, Object> middleTableResultMap = this.middleTable.executeOneToOneQuery(trunkObjCol2ValuesMap);
            if (V.isEmpty(middleTableResultMap)) {
                return;
            }
            HashMap<String, Object> valueEntityMap = new HashMap<String, Object>();
            this.simplifySelectColumns();
            Collection refObjValues = middleTableResultMap.values().stream().distinct().collect(Collectors.toList());
            String refObjJoinOnCol = (String)this.refObjJoinCols.get(0);
            if (V.isEmpty(this.module)) {
                this.queryWrapper.in((Object)refObjJoinOnCol, refObjValues);
                entityList = this.getEntityList((Wrapper)this.queryWrapper);
            } else {
                this.remoteBindDTO.setRefJoinCol(refObjJoinOnCol).setInConditionValues(refObjValues);
                entityList = RemoteBindingManager.fetchEntityList(this.module, this.remoteBindDTO, this.referencedEntityClass);
            }
            if (V.isEmpty(entityList)) {
                return;
            }
            String refObjJoinOnField = this.toRefObjField(refObjJoinOnCol);
            Map listMap = BeanUtils.convertToStringKeyObjectMap(entityList, refObjJoinOnField);
            if (V.notEmpty(listMap)) {
                for (Map.Entry<String, Object> entry : middleTableResultMap.entrySet()) {
                    Object fetchValueId = entry.getValue();
                    if (fetchValueId == null) continue;
                    String key = entry.getKey();
                    Object entity = listMap.get(String.valueOf(fetchValueId));
                    valueEntityMap.put(key, this.cloneOrConvertBean(entity));
                }
            }
            ResultAssembler.bindEntityPropValue(this.annoObjectField, super.getMatchedAnnoObjectList(), this.middleTable.getTrunkObjColMapping(), valueEntityMap, this.getAnnoObjColumnToFieldMap());
        }
    }

    private Map<String, Object> buildMatchKey2EntityMap(List<T> list) {
        HashMap<String, Object> key2TargetMap = new HashMap<String, Object>(list.size());
        StringBuilder sb = new StringBuilder();
        for (T entity : list) {
            sb.setLength(0);
            for (int i = 0; i < this.refObjJoinCols.size(); ++i) {
                String refObjJoinOnCol = (String)this.refObjJoinCols.get(i);
                String pkValue = BeanUtils.getStringProperty(entity, this.toRefObjField(refObjJoinOnCol));
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(pkValue);
            }
            String matchKey = sb.toString();
            Object target = entity;
            if (!(target instanceof Map)) {
                target = this.cloneOrConvertBean(entity);
            }
            key2TargetMap.put(matchKey, target);
        }
        sb.setLength(0);
        return key2TargetMap;
    }

    protected Object cloneOrConvertBean(T value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().getName().equals(this.annoObjectFieldClass.getName())) {
            return BeanUtils.cloneBean(value);
        }
        return BeanUtils.convert(value, this.annoObjectFieldClass);
    }

    @Override
    protected void simplifySelectColumns() {
        if (!this.referencedEntityClass.getName().equals(this.annoObjectFieldClass.getName())) {
            PropInfo propInfo = BindingCacheManager.getPropInfoByClass(this.referencedEntityClass);
            List<Field> fieldList = BindingCacheManager.getFields(this.annoObjectFieldClass);
            ArrayList<String> selectColumns = new ArrayList<String>(this.refObjJoinCols);
            for (Field field : fieldList) {
                Accept accept = field.getAnnotation(Accept.class);
                String fieldName = accept == null ? field.getName() : accept.name();
                String colName = propInfo.getColumnByField(fieldName);
                if (colName == null || !V.notEquals(colName, propInfo.getDeletedColumn()) || selectColumns.contains(colName)) continue;
                selectColumns.add(colName);
            }
            if (V.notEmpty(this.orderBy)) {
                String[] orderByFields;
                for (String field : orderByFields = S.split(this.orderBy)) {
                    String colName = field.toLowerCase();
                    if (colName.contains(":")) {
                        colName = S.split((String)colName, (String)":")[0];
                    }
                    if (selectColumns.contains(colName = this.toRefObjColumn(colName))) continue;
                    selectColumns.add(colName);
                }
            }
            if (V.notEmpty(selectColumns)) {
                this.queryWrapper.select(selectColumns);
                if (this.remoteBindDTO != null) {
                    this.remoteBindDTO.setSelectColumns(selectColumns);
                }
            }
        }
    }
}

