/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.NormalSegmentList;
import com.diboot.core.binding.helper.WrapperHelper;
import com.diboot.core.binding.parser.ParserCache;
import com.diboot.core.binding.query.BindQuery;
import com.diboot.core.binding.query.Comparison;
import com.diboot.core.binding.query.Strategy;
import com.diboot.core.binding.query.dynamic.AnnoJoiner;
import com.diboot.core.binding.query.dynamic.DynamicJoinQueryWrapper;
import com.diboot.core.binding.query.dynamic.ExtQueryWrapper;
import com.diboot.core.data.protect.DataEncryptHandler;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Pagination;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.type.NullType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder {
    private static Logger log = LoggerFactory.getLogger(QueryBuilder.class);

    public static <DTO> QueryWrapper toQueryWrapper(DTO dto) {
        return QueryBuilder.dtoToWrapper(dto, null, null);
    }

    public static <DTO> QueryWrapper toQueryWrapper(DTO dto, Pagination pagination) {
        return QueryBuilder.dtoToWrapper(dto, null, pagination);
    }

    public static <DTO> QueryWrapper toQueryWrapper(DTO dto, Collection<String> fields) {
        return QueryBuilder.dtoToWrapper(dto, fields, null);
    }

    public static <DTO> QueryWrapper toQueryWrapper(DTO dto, Collection<String> fields, Pagination pagination) {
        return QueryBuilder.dtoToWrapper(dto, fields, pagination);
    }

    public static <DTO> ExtQueryWrapper toDynamicJoinQueryWrapper(DTO dto) {
        return QueryBuilder.toDynamicJoinQueryWrapper(dto, null, null);
    }

    public static <DTO> ExtQueryWrapper toDynamicJoinQueryWrapper(DTO dto, Pagination pagination) {
        return QueryBuilder.toDynamicJoinQueryWrapper(dto, null, pagination);
    }

    public static <DTO> ExtQueryWrapper toDynamicJoinQueryWrapper(DTO dto, Collection<String> fields) {
        return QueryBuilder.toDynamicJoinQueryWrapper(dto, fields, null);
    }

    public static <DTO> ExtQueryWrapper toDynamicJoinQueryWrapper(DTO dto, Collection<String> fields, Pagination pagination) {
        QueryWrapper<?> queryWrapper = QueryBuilder.dtoToWrapper(dto, fields, pagination);
        if (!(queryWrapper instanceof DynamicJoinQueryWrapper)) {
            return (ExtQueryWrapper)queryWrapper;
        }
        return (DynamicJoinQueryWrapper)queryWrapper;
    }

    private static <DTO> QueryWrapper<?> dtoToWrapper(DTO dto, Collection<String> fields, Pagination pagination) {
        LinkedHashMap<String, FieldAndValue> fieldValuesMap = QueryBuilder.extractNotNullValues(dto, fields, pagination);
        if (V.isEmpty(fieldValuesMap)) {
            return new QueryWrapper();
        }
        fields = fieldValuesMap.keySet();
        boolean hasJoinTable = ParserCache.hasJoinTable(dto, fields);
        ExtQueryWrapper wrapper = hasJoinTable ? new DynamicJoinQueryWrapper(dto.getClass(), fields) : new ExtQueryWrapper();
        List<AnnoJoiner> annoJoinerList = ParserCache.getBindQueryAnnos(dto.getClass());
        BiFunction<BindQuery, Field, String> buildColumnName = (bindQuery, field) -> {
            if (bindQuery != null) {
                String key = field.getName() + bindQuery;
                for (AnnoJoiner annoJoiner : annoJoinerList) {
                    if (!key.equals(annoJoiner.getKey())) continue;
                    if (V.notEmpty(annoJoiner.getJoin())) {
                        return annoJoiner.getAlias() + "." + annoJoiner.getColumnName();
                    }
                    return (hasJoinTable ? "self." : "") + annoJoiner.getColumnName();
                }
            }
            return (hasJoinTable ? "self." : "") + BeanUtils.getColumnName(field);
        };
        BiPredicate<Object, BindQuery> ignoreEmpty = (value, bindQuery) -> bindQuery != null && (Strategy.IGNORE_EMPTY.equals((Object)bindQuery.strategy()) && value instanceof String && S.isEmpty((CharSequence)((String)value)) || Comparison.IN.equals((Object)bindQuery.comparison()) && V.isEmpty(value));
        Function<BindQuery, Class> getClass = bindQuery -> bindQuery == null || bindQuery.entity() == NullType.class ? dto.getClass() : bindQuery.entity();
        BiFunction<BindQuery, String, String> getFieldName = (bindQuery, defFieldName) -> bindQuery == null || S.isEmpty((CharSequence)bindQuery.column()) ? defFieldName : bindQuery.column();
        DataEncryptHandler protectFieldHandler = ContextHolder.getBean(DataEncryptHandler.class);
        for (Map.Entry<String, FieldAndValue> entry : fieldValuesMap.entrySet()) {
            BindQuery query;
            FieldAndValue fieldAndValue = entry.getValue();
            Field field2 = fieldAndValue.getField();
            TableField tableField = field2.getAnnotation(TableField.class);
            if (tableField != null && !tableField.exist() || (query = field2.getAnnotation(BindQuery.class)) != null && query.ignore()) continue;
            BindQuery.List queryList = field2.getAnnotation(BindQuery.List.class);
            Object value2 = fieldAndValue.getValue();
            if (queryList != null) {
                List bindQueryList = Arrays.stream(queryList.value()).filter(e -> !ignoreEmpty.test(value2, (BindQuery)e)).collect(Collectors.toList());
                wrapper.and(V.notEmpty(bindQueryList), queryWrapper -> {
                    Class clazz = (Class)getClass.apply(query);
                    List<String> encryptFields = ParserCache.getProtectFieldList(clazz);
                    for (BindQuery bindQuery : bindQueryList) {
                        String fieldName;
                        String columnName = (String)buildColumnName.apply(bindQuery, field2);
                        if (protectFieldHandler != null && encryptFields.contains(fieldName = (String)getFieldName.apply(query, (String)entry.getKey()))) {
                            log.debug("\u67e5\u8be2\u6761\u4ef6\u4e2d\u5305\u542b\u52a0\u5bc6\u5b57\u6bb5 {}:{}\uff0c\u5c06\u52a0\u5bc6\u540e\u5339\u914d\u5bc6\u6587", (Object)fieldName, value2);
                            QueryBuilder.buildQuery((QueryWrapper)queryWrapper.or(), bindQuery, columnName, protectFieldHandler.encrypt(value2.toString()));
                            continue;
                        }
                        QueryBuilder.buildQuery((QueryWrapper)queryWrapper.or(), bindQuery, columnName, value2);
                    }
                });
                continue;
            }
            if (query == null && V.isEmpty(value2) || ignoreEmpty.test(value2, query)) continue;
            String columnName = buildColumnName.apply(query, field2);
            if (protectFieldHandler != null) {
                Class clazz = getClass.apply(query);
                String fieldName = getFieldName.apply(query, entry.getKey());
                if (ParserCache.getProtectFieldList(clazz).contains(fieldName)) {
                    log.debug("\u67e5\u8be2\u6761\u4ef6\u4e2d\u5305\u542b\u52a0\u5bc6\u5b57\u6bb5 {}:{}\uff0c\u5c06\u52a0\u5bc6\u540e\u5339\u914d\u5bc6\u6587", (Object)fieldName, value2);
                    QueryBuilder.buildQuery(wrapper, query, columnName, protectFieldHandler.encrypt(value2.toString()));
                    continue;
                }
            }
            QueryBuilder.buildQuery(wrapper, query, columnName, value2);
        }
        return wrapper;
    }

    private static void buildQuery(QueryWrapper<?> wrapper, BindQuery bindQuery, String columnName, Object value) {
        Comparison comparison;
        Comparison comparison2 = comparison = bindQuery != null ? bindQuery.comparison() : Comparison.EQ;
        if (value == null) {
            if (bindQuery != null && bindQuery.strategy().equals((Object)Strategy.INCLUDE_NULL) && comparison.equals((Object)Comparison.EQ)) {
                wrapper.isNull((Object)columnName);
            }
            return;
        }
        WrapperHelper.buildQueryCriteria(wrapper, comparison, columnName, value);
    }

    private static <DTO> LinkedHashMap<String, FieldAndValue> extractNotNullValues(DTO dto, Collection<String> fields, Pagination pagination) {
        Class<?> dtoClass = dto.getClass();
        List<Field> declaredFields = BeanUtils.extractAllFields(dtoClass, true);
        List<String> extractOrderFieldNames = QueryBuilder.extractOrderFieldNames(pagination);
        LinkedHashMap<String, FieldAndValue> resultMap = new LinkedHashMap<String, FieldAndValue>(declaredFields.size());
        for (Field field : declaredFields) {
            TableField tableField;
            TableLogic tableLogic;
            BindQuery bindQuery;
            String fieldName = field.getName();
            if (V.notContains(fields, fieldName) && !V.equals(field.getType(), Date.class) && !V.equals(field.getType(), LocalDate.class) && !V.equals(field.getType(), LocalDateTime.class) || (bindQuery = field.getAnnotation(BindQuery.class)) != null && bindQuery.ignore()) continue;
            if (field.getType().getName().equals("boolean") && (tableLogic = field.getAnnotation(TableLogic.class)) == null && ((tableField = field.getAnnotation(TableField.class)) == null || tableField.exist())) {
                log.warn("{}.{} \u5b57\u6bb5\u7c7b\u578b\u4e3a boolean\uff0c\u5176\u9ed8\u8ba4\u503c\u5c06\u53c2\u4e0e\u6784\u5efa\u67e5\u8be2\u6761\u4ef6\uff0c\u53ef\u80fd\u5bfc\u81f4\u7ed3\u679c\u4e0e\u9884\u671f\u4e0d\u7b26\uff0c\u5efa\u8bae\u8c03\u6574\u4e3a Boolean \u7c7b\u578b \u6216 \u6307\u5b9a @BindQuery(ignore=true)", (Object)dtoClass.getSimpleName(), (Object)field.getName());
            }
            Object value = null;
            try {
                String prefix = V.equals(Boolean.TYPE, field.getType()) ? "is" : "get";
                Method method = dtoClass.getMethod(prefix + S.capFirst(fieldName), new Class[0]);
                value = method.invoke(dto, new Object[0]);
            }
            catch (IllegalAccessException e) {
                log.error("\u901a\u8fc7\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u503c\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.debug("\u901a\u8fc7\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u65b9\u6cd5\u4e0d\u5b58\u5728\uff1a{}", (Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.warn("\u901a\u8fc7\u53cd\u5c04\u6267\u884c\u5c5e\u6027\u65b9\u6cd5\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            }
            if (field.isAnnotationPresent(TableLogic.class) && V.equals(false, value)) continue;
            Strategy strategy = bindQuery != null ? bindQuery.strategy() : Strategy.IGNORE_EMPTY;
            boolean collectThisField = false;
            if (strategy.equals((Object)Strategy.INCLUDE_NULL)) {
                collectThisField = true;
            } else if (strategy.equals((Object)Strategy.IGNORE_EMPTY) && V.notEmpty(value)) {
                collectThisField = true;
            } else if (strategy.equals((Object)Strategy.INCLUDE_EMPTY) && value != null) {
                collectThisField = true;
            } else if (extractOrderFieldNames.contains(fieldName)) {
                collectThisField = true;
            }
            if (!collectThisField) continue;
            resultMap.put(fieldName, new FieldAndValue(field, value));
        }
        return resultMap;
    }

    public static boolean checkHasColumn(NormalSegmentList segments, String idCol) {
        if (segments.size() > 0) {
            for (ISqlSegment segment : segments) {
                if (!segment.getSqlSegment().equalsIgnoreCase(idCol)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> extractOrderFieldNames(Pagination pagination) {
        if (pagination == null || V.isEmpty(pagination.getOrderBy())) {
            return Collections.emptyList();
        }
        String[] orderByFields = S.split(pagination.getOrderBy());
        ArrayList<String> orderFields = new ArrayList<String>(orderByFields.length);
        for (String field : orderByFields) {
            if (field.contains(":")) {
                field = S.substringBefore((String)field, (String)":");
            }
            orderFields.add(field);
        }
        return orderFields;
    }

    private static class FieldAndValue {
        private final Field field;
        private final Object value;

        public FieldAndValue(Field field, Object value) {
            this.field = field;
            this.value = value;
        }

        public Field getField() {
            return this.field;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

