/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.swagger.dubbo.web;

import com.deepoove.swagger.dubbo.config.DubboPropertyConfig;
import com.deepoove.swagger.dubbo.config.DubboServiceScanner;
import com.deepoove.swagger.dubbo.config.SwaggerDocCache;
import com.deepoove.swagger.dubbo.reader.Reader;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.Api;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${swagger.dubbo.doc:swagger-dubbo}"})
@Api(hidden=true)
public class SwaggerDubboController {
    public static final String DEFAULT_URL = "/api-docs";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    @Autowired
    private DubboServiceScanner dubboServiceScanner;
    @Autowired
    private DubboPropertyConfig dubboPropertyConfig;
    @Autowired
    private SwaggerDocCache swaggerDocCache;
    @Value(value="${swagger.dubbo.http:h}")
    private String httpContext;
    @Value(value="${swagger.dubbo.enable:true}")
    private boolean enable = true;

    @RequestMapping(value={"/api-docs"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8", "application/hal+json"})
    @ResponseBody
    public ResponseEntity<springfox.documentation.spring.web.json.Json> getApiList() throws JsonProcessingException {
        Map<Class<?>, Object> interfaceMapRef;
        if (!this.enable) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Swagger swagger = this.swaggerDocCache.getSwagger();
        if (null != swagger) {
            return new ResponseEntity((Object)new springfox.documentation.spring.web.json.Json(Json.mapper().writeValueAsString((Object)swagger)), HttpStatus.OK);
        }
        swagger = new Swagger();
        DubboPropertyConfig configurator = this.dubboPropertyConfig;
        if (configurator != null) {
            configurator.configure(swagger);
        }
        if (null != (interfaceMapRef = this.dubboServiceScanner.interfaceMapRef())) {
            Reader.read(swagger, interfaceMapRef, this.httpContext);
        }
        this.swaggerDocCache.setSwagger(swagger);
        return new ResponseEntity((Object)new springfox.documentation.spring.web.json.Json(Json.mapper().writeValueAsString((Object)swagger)), HttpStatus.OK);
    }
}

