/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.swagger.dubbo.reader;

import com.deepoove.swagger.dubbo.reader.NameDiscover;
import com.deepoove.swagger.dubbo.reader.ReaderContext;
import com.deepoove.swagger.dubbo.reader.ReaderExtension;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ResponseHeader;
import io.swagger.converter.ModelConverters;
import io.swagger.models.HttpMethod;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.PathUtils;
import io.swagger.util.PrimitiveType;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DubboReaderExtension
implements ReaderExtension {
    private static final String SUCCESSFUL_OPERATION = "";

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean isReadable(ReaderContext context) {
        Api apiAnnotation = context.getCls().getAnnotation(Api.class);
        return apiAnnotation == null || context.isReadHidden() || !apiAnnotation.hidden();
    }

    @Override
    public void applyConsumes(ReaderContext context, Operation operation, Method method) {
        ArrayList<String> consumes = new ArrayList<String>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null) {
            consumes.addAll(DubboReaderExtension.parseStringValues(apiOperation.consumes()));
        }
        if (consumes.isEmpty()) {
            Api apiAnnotation = context.getCls().getAnnotation(Api.class);
            if (apiAnnotation != null) {
                consumes.addAll(DubboReaderExtension.parseStringValues(apiAnnotation.consumes()));
            }
            consumes.addAll(context.getParentConsumes());
        }
        for (String consume : consumes) {
            operation.consumes(consume);
        }
    }

    private static List<String> parseStringValues(String str) {
        return DubboReaderExtension.parseAnnotationValues(str, new Function<String, String>(){

            public String apply(String value) {
                return value;
            }
        });
    }

    private static <T> List<T> parseAnnotationValues(String str, Function<String, T> processor) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String item : Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)str)) {
            result.add(processor.apply((Object)item));
        }
        return result;
    }

    @Override
    public void applyProduces(ReaderContext context, Operation operation, Method method) {
        ArrayList<String> produces = new ArrayList<String>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null) {
            produces.addAll(DubboReaderExtension.parseStringValues(apiOperation.produces()));
        }
        if (produces.isEmpty()) {
            Api apiAnnotation = context.getCls().getAnnotation(Api.class);
            if (apiAnnotation != null) {
                produces.addAll(DubboReaderExtension.parseStringValues(apiAnnotation.produces()));
            }
            produces.addAll(context.getParentProduces());
        }
        for (String produce : produces) {
            operation.produces(produce);
        }
    }

    @Override
    public String getHttpMethod(ReaderContext context, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        return apiOperation == null || StringUtils.isEmpty((CharSequence)apiOperation.httpMethod()) ? HttpMethod.POST.name() : apiOperation.httpMethod();
    }

    @Override
    public String getPath(ReaderContext context, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        String operationId = null == apiOperation ? SUCCESSFUL_OPERATION : (StringUtils.isBlank((CharSequence)apiOperation.nickname()) ? null : apiOperation.nickname());
        return PathUtils.collectPath((String[])new String[]{context.getParentPath(), context.getInterfaceCls().getName(), method.getName(), operationId});
    }

    @Override
    public void applyOperationId(Operation operation, Method method) {
        operation.operationId(method.getName());
    }

    @Override
    public void applySummary(Operation operation, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && StringUtils.isNotBlank((CharSequence)apiOperation.value())) {
            operation.summary(apiOperation.value());
        }
    }

    @Override
    public void applyDescription(Operation operation, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && StringUtils.isNotBlank((CharSequence)apiOperation.notes())) {
            operation.description(apiOperation.notes());
        }
        operation.description(operation.getDescription() == null ? this.outputMethod(method) : this.outputMethod(method) + operation.getDescription());
    }

    private String outputMethod(Method method) {
        try {
            int j;
            Class<?>[] types = method.getParameterTypes();
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            StringBuilder sb = new StringBuilder();
            sb.append(method.getReturnType().getSimpleName()).append(" ").append(method.getName());
            sb.append('(');
            for (j = 0; j < types.length; ++j) {
                sb.append(types[j].getName());
                if (j >= types.length - 1) continue;
                sb.append(",");
            }
            sb.append(')');
            if (exceptionTypes.length > 0) {
                sb.append(" throws ");
                for (j = 0; j < exceptionTypes.length; ++j) {
                    sb.append(exceptionTypes[j].getSimpleName());
                    if (j >= exceptionTypes.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    @Override
    public void applySchemes(ReaderContext context, Operation operation, Method method) {
        ArrayList<Scheme> schemes = new ArrayList<Scheme>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        Api apiAnnotation = context.getCls().getAnnotation(Api.class);
        if (apiOperation != null) {
            schemes.addAll(DubboReaderExtension.parseSchemes(apiOperation.protocols()));
        }
        if (schemes.isEmpty() && apiAnnotation != null) {
            schemes.addAll(DubboReaderExtension.parseSchemes(apiAnnotation.protocols()));
        }
        for (Scheme scheme : schemes) {
            operation.scheme(scheme);
        }
    }

    private static List<Scheme> parseSchemes(String schemes) {
        ArrayList<Scheme> result = new ArrayList<Scheme>();
        for (String item : StringUtils.trimToEmpty((String)schemes).split(",")) {
            Scheme scheme = Scheme.forValue((String)StringUtils.trimToNull((String)item));
            if (scheme == null || result.contains(scheme)) continue;
            result.add(scheme);
        }
        return result;
    }

    @Override
    public void setDeprecated(Operation operation, Method method) {
        operation.deprecated(Boolean.valueOf(ReflectionUtils.getAnnotation((Method)method, Deprecated.class) != null));
    }

    @Override
    public void applySecurityRequirements(ReaderContext context, Operation operation, Method method) {
    }

    @Override
    public void applyTags(ReaderContext context, Operation operation, Method method) {
        ArrayList<String> tags = new ArrayList<String>();
        Api apiAnnotation = context.getCls().getAnnotation(Api.class);
        if (apiAnnotation != null) {
            Collection filter = Collections2.filter(Arrays.asList(apiAnnotation.tags()), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return StringUtils.isNotBlank((CharSequence)input);
                }
            });
            if (filter.isEmpty()) {
                tags.add(context.getInterfaceCls().getSimpleName());
            } else {
                tags.addAll(filter);
            }
        } else {
            tags.add(context.getInterfaceCls().getSimpleName());
        }
        tags.addAll(context.getParentTags());
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null) {
            tags.addAll(Collections2.filter(Arrays.asList(apiOperation.tags()), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return StringUtils.isNotBlank((CharSequence)input);
                }
            }));
        }
        for (String tag : tags) {
            operation.tag(tag);
        }
    }

    private static boolean isValidResponse(Type type) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        return !ReflectionUtils.isVoid((Type)javaType);
    }

    private static Map<String, Property> parseResponseHeaders(ReaderContext context, ResponseHeader[] headers) {
        HashMap<String, Property> responseHeaders = null;
        for (ResponseHeader header : headers) {
            Property property;
            Class cls;
            String name = header.name();
            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
            if (responseHeaders == null) {
                responseHeaders = new HashMap<String, Property>();
            }
            if (ReflectionUtils.isVoid((Type)(cls = header.response())) || (property = ModelConverters.getInstance().readAsProperty((Type)cls)) == null) continue;
            Property responseProperty = ContainerWrapper.wrapContainer(header.responseContainer(), property, ContainerWrapper.ARRAY, ContainerWrapper.LIST, ContainerWrapper.SET);
            responseProperty.setDescription(header.description());
            responseHeaders.put(name, responseProperty);
            DubboReaderExtension.appendModels(context.getSwagger(), cls);
        }
        return responseHeaders;
    }

    private static void appendModels(Swagger swagger, Type type) {
        Map models = ModelConverters.getInstance().readAll(type);
        for (Map.Entry entry : models.entrySet()) {
            swagger.model((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    private static Type getResponseType(Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && !ReflectionUtils.isVoid((Type)apiOperation.response())) {
            return apiOperation.response();
        }
        return method.getGenericReturnType();
    }

    private static String getResponseContainer(ApiOperation apiOperation) {
        return apiOperation == null ? null : (String)StringUtils.defaultIfBlank((CharSequence)apiOperation.responseContainer(), null);
    }

    @Override
    public void applyResponses(ReaderContext context, Operation operation, Method method) {
        ApiResponses responseAnnotation;
        Property property;
        Type responseType;
        HashMap<Integer, Response> result = new HashMap<Integer, Response>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && StringUtils.isNotBlank((CharSequence)apiOperation.responseReference())) {
            Response response = new Response().description(SUCCESSFUL_OPERATION);
            response.schema((Property)new RefProperty(apiOperation.responseReference()));
            result.put(apiOperation.code(), response);
        }
        if (DubboReaderExtension.isValidResponse(responseType = DubboReaderExtension.getResponseType(method)) && (property = ModelConverters.getInstance().readAsProperty(responseType)) != null) {
            Property responseProperty = ContainerWrapper.wrapContainer(DubboReaderExtension.getResponseContainer(apiOperation), property, new ContainerWrapper[0]);
            int n = apiOperation == null ? 200 : apiOperation.code();
            Map defaultResponseHeaders = apiOperation == null ? Collections.emptyMap() : DubboReaderExtension.parseResponseHeaders(context, apiOperation.responseHeaders());
            Response response = new Response().description(SUCCESSFUL_OPERATION).schema(responseProperty).headers(defaultResponseHeaders);
            result.put(n, response);
            DubboReaderExtension.appendModels(context.getSwagger(), responseType);
        }
        if ((responseAnnotation = (ApiResponses)ReflectionUtils.getAnnotation((Method)method, ApiResponses.class)) != null) {
            for (ApiResponse apiResponse : responseAnnotation.value()) {
                Map<String, Property> responseHeaders = DubboReaderExtension.parseResponseHeaders(context, apiResponse.responseHeaders());
                Response response = new Response().description(apiResponse.message()).headers(responseHeaders);
                if (StringUtils.isNotEmpty((CharSequence)apiResponse.reference())) {
                    response.schema((Property)new RefProperty(apiResponse.reference()));
                } else if (!ReflectionUtils.isVoid((Type)apiResponse.response())) {
                    Class type = apiResponse.response();
                    Property property2 = ModelConverters.getInstance().readAsProperty((Type)type);
                    if (property2 != null) {
                        response.schema(ContainerWrapper.wrapContainer(apiResponse.responseContainer(), property2, new ContainerWrapper[0]));
                        DubboReaderExtension.appendModels(context.getSwagger(), type);
                    }
                }
                result.put(apiResponse.code(), response);
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            if ((Integer)entry.getKey() == 0) {
                operation.defaultResponse((Response)entry.getValue());
                continue;
            }
            operation.response(((Integer)entry.getKey()).intValue(), (Response)entry.getValue());
        }
    }

    @Override
    public void applyParameters(ReaderContext context, Operation operation, Type type, Annotation[] annotations) {
    }

    private void applyParametersV2(ReaderContext context, Operation operation, String name, Type type, Class<?> cls, Annotation[] annotations, Annotation[] interfaceParamAnnotations) {
        Parameter parameter;
        Annotation apiParam = null;
        if (annotations != null) {
            for (Annotation annotation : interfaceParamAnnotations) {
                if (!(annotation instanceof ApiParam)) continue;
                apiParam = annotation;
                break;
            }
            if (null == apiParam) {
                for (Annotation annotation : annotations) {
                    if (!(annotation instanceof ApiParam)) continue;
                    apiParam = annotation;
                    break;
                }
            }
        }
        if ((parameter = this.readParam(context.getSwagger(), type, cls, null == apiParam ? null : (ApiParam)apiParam)) != null) {
            parameter.setName(null == name ? parameter.getName() : name);
            operation.parameter(parameter);
        }
    }

    private Parameter readParam(Swagger swagger, Type type, Class<?> cls, ApiParam param) {
        PrimitiveType fromType = PrimitiveType.fromType((Type)type);
        Parameter para = (Parameter)(null == fromType ? new BodyParameter() : new QueryParameter());
        Parameter parameter = ParameterProcessor.applyAnnotations((Swagger)swagger, (Parameter)para, (Type)(type == null ? String.class : type), null == param ? new ArrayList() : Collections.singletonList(param));
        if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter p = (AbstractSerializableParameter)parameter;
            if (p.getType() == null) {
                p.setType(null == fromType ? "string" : fromType.getCommonName());
            }
            p.setRequired(p.getRequired() ? true : cls.isPrimitive());
        } else {
            BodyParameter bp = (BodyParameter)parameter;
            bp.setIn("formData");
        }
        return parameter;
    }

    @Override
    public void applyParameters(ReaderContext context, Operation operation, Method method, Method interfaceMethod) {
        try {
            String[] parameterNames = NameDiscover.parameterNameDiscover.getParameterNames(method);
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            Annotation[][] interfaceParamAnnotations = interfaceMethod.getParameterAnnotations();
            for (int i = 0; i < genericParameterTypes.length; ++i) {
                this.applyParametersV2(context, operation, null == parameterNames ? null : parameterNames[i], genericParameterTypes[i], parameterTypes[i], parameterAnnotations[i], interfaceParamAnnotations[i]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void applyImplicitParameters(ReaderContext context, Operation operation, Method method) {
        ApiImplicitParams implicitParams = method.getAnnotation(ApiImplicitParams.class);
        if (implicitParams != null && implicitParams.value().length > 0) {
            for (ApiImplicitParam param : implicitParams.value()) {
                Parameter p = this.readImplicitParam(context.getSwagger(), param);
                if (p == null) continue;
                operation.parameter(p);
            }
        }
    }

    private Parameter readImplicitParam(Swagger swagger, ApiImplicitParam param) {
        PrimitiveType fromType = PrimitiveType.fromName((String)param.paramType());
        FormParameter p = null == fromType ? new FormParameter() : new QueryParameter();
        Type type = ReflectionUtils.typeFromString((String)param.dataType());
        return ParameterProcessor.applyAnnotations((Swagger)swagger, (Parameter)p, (Type)(type == null ? String.class : type), Collections.singletonList(param));
    }

    @Override
    public void applyExtensions(ReaderContext context, Operation operation, Method method) {
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            operation.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])apiOperation.extensions()));
        }
    }

    static enum ContainerWrapper {
        LIST("list"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        ARRAY("array"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        MAP("map"){

            @Override
            protected Property doWrap(Property property) {
                return new MapProperty(property);
            }
        }
        ,
        SET("set"){

            @Override
            protected Property doWrap(Property property) {
                ArrayProperty arrayProperty = new ArrayProperty(property);
                arrayProperty.setUniqueItems(Boolean.valueOf(true));
                return arrayProperty;
            }
        };

        private final String container;

        private ContainerWrapper(String container) {
            this.container = container;
        }

        public static Property wrapContainer(String container, Property property, ContainerWrapper ... allowed) {
            EnumSet<ContainerWrapper> tmp = allowed.length > 0 ? EnumSet.copyOf(Arrays.asList(allowed)) : EnumSet.allOf(ContainerWrapper.class);
            for (ContainerWrapper wrapper : tmp) {
                Property prop = wrapper.wrap(container, property);
                if (prop == null) continue;
                return prop;
            }
            return property;
        }

        public Property wrap(String container, Property property) {
            if (this.container.equalsIgnoreCase(container)) {
                return this.doWrap(property);
            }
            return null;
        }

        protected abstract Property doWrap(Property var1);
    }
}

