/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.swagger.dubbo.http;

import com.deepoove.swagger.dubbo.reader.NameDiscover;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.HttpMethod;
import io.swagger.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMatch {
    private static Logger logger = LoggerFactory.getLogger(HttpMatch.class);
    private Class<?> interfaceClass;
    private Class<?> refClass;

    public HttpMatch(Class<?> interfaceClass, Class<?> refClass) {
        this.interfaceClass = interfaceClass;
        this.refClass = refClass;
    }

    public Method[] findInterfaceMethods(String methodName) {
        Method[] methods = this.interfaceClass.getMethods();
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            ret.add(method);
        }
        return ret.toArray(new Method[0]);
    }

    public Method[] findRefMethods(Method[] interfaceMethods, String operationId, String requestMethod) {
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : interfaceMethods) {
            try {
                String nickname;
                Method m = this.refClass.getMethod(method.getName(), method.getParameterTypes());
                ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)m, ApiOperation.class);
                String string = nickname = null == apiOperation ? null : apiOperation.nickname();
                if (operationId == null ? StringUtils.isNotBlank((CharSequence)nickname) : !operationId.equals(nickname)) continue;
                if (requestMethod != null) {
                    String httpMethod;
                    String string2 = httpMethod = null == apiOperation ? null : apiOperation.httpMethod();
                    if (StringUtils.isNotBlank((CharSequence)httpMethod) && !requestMethod.equals(httpMethod) || StringUtils.isBlank((CharSequence)httpMethod) && !requestMethod.equalsIgnoreCase(HttpMethod.POST.name())) continue;
                }
                ret.add(m);
            }
            catch (NoSuchMethodException e) {
                logger.error("NoSuchMethodException", (Throwable)e);
            }
            catch (SecurityException e) {
                logger.error("SecurityException", (Throwable)e);
            }
        }
        return ret.toArray(new Method[0]);
    }

    public Method matchRefMethod(Method[] refMethods, String methodName, Set<String> keySet) {
        if (refMethods.length == 0) {
            return null;
        }
        if (refMethods.length == 1) {
            return refMethods[0];
        }
        ArrayList<RateMethod> rateMethods = new ArrayList<RateMethod>();
        for (Method method : refMethods) {
            String[] parameterNames = NameDiscover.parameterNameDiscover.getParameterNames(method);
            if (parameterNames == null) {
                return method;
            }
            float correctRate = 0.0f;
            int hit = 0;
            int error = 0;
            for (String paramName : parameterNames) {
                if (keySet.contains(paramName)) {
                    ++hit;
                    continue;
                }
                ++error;
            }
            correctRate = (float)error / (float)hit;
            rateMethods.add(new RateMethod(method, (int)correctRate * 100));
        }
        if (rateMethods.isEmpty()) {
            return null;
        }
        Collections.sort(rateMethods, new Comparator<RateMethod>(){

            @Override
            public int compare(RateMethod o1, RateMethod o2) {
                return o2.getRate() - o1.getRate();
            }
        });
        return ((RateMethod)rateMethods.get(0)).getMethod();
    }

    class RateMethod {
        private Method method;
        private int rate;

        public RateMethod(Method method, int rate) {
            this.method = method;
            this.rate = rate;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public int getRate() {
            return this.rate;
        }

        public void setRate(int rate) {
            this.rate = rate;
        }
    }
}

