/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.NumberingFormat;
import com.deepoove.poi.data.NumberingRenderData;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.Texts;
import java.util.ArrayList;
import java.util.Arrays;

public class Numberings {
    private Numberings() {
    }

    public static NumberingBuilder ofBullet() {
        return Numberings.of(NumberingFormat.BULLET);
    }

    public static NumberingBuilder ofDecimal() {
        return Numberings.of(NumberingFormat.DECIMAL);
    }

    public static NumberingBuilder ofDecimalParentheses() {
        return Numberings.of(NumberingFormat.DECIMAL_PARENTHESES);
    }

    public static NumberingBuilder of(NumberingFormat format) {
        return new NumberingBuilder(format);
    }

    public static NumberingBuilder of(TextRenderData ... text) {
        NumberingBuilder inst = Numberings.ofBullet();
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder of(String ... text) {
        NumberingBuilder inst = Numberings.ofBullet();
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingRenderData create(String ... text) {
        return Numberings.of(text).create();
    }

    public static class NumberingBuilder
    implements RenderDataBuilder<NumberingRenderData> {
        private NumberingRenderData data;

        private NumberingBuilder(NumberingFormat format) {
            this.data = new NumberingRenderData(format, new ArrayList<ParagraphRenderData>());
        }

        public NumberingBuilder addItem(ParagraphRenderData item) {
            this.data.getItems().add(item);
            return this;
        }

        public NumberingBuilder addItem(TextRenderData item) {
            this.data.getItems().add(Paragraphs.of(item).create());
            return this;
        }

        public NumberingBuilder addItem(PictureRenderData item) {
            this.data.getItems().add(Paragraphs.of(item).create());
            return this;
        }

        public NumberingBuilder addItem(String text) {
            this.addItem(Texts.of(text).create());
            return this;
        }

        @Override
        public NumberingRenderData create() {
            return this.data;
        }
    }
}

