/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteUtils {
    private static Logger logger = LoggerFactory.getLogger(ByteUtils.class);

    public static byte[] getUrlByteArray(String urlPath) {
        try {
            return ByteUtils.toByteArray(ByteUtils.getUrlStream(urlPath));
        }
        catch (IOException e) {
            logger.error("getUrlPictureStream error,{},{}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static byte[] getLocalByteArray(File res) {
        try {
            return ByteUtils.toByteArray(new FileInputStream(res));
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFound", (Throwable)e);
            return null;
        }
    }

    public static byte[] toByteArray(InputStream is) {
        if (null == is) {
            return null;
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            logger.error("toByteArray error", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("close stream error", (Throwable)e);
            }
        }
        return null;
    }

    public static InputStream getUrlStream(String urlPath) throws IOException {
        URL url = new URL(urlPath);
        return url.openConnection().getInputStream();
    }
}

