/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.exception.ResolverException;
import com.deepoove.poi.resolver.AbstractResolver;
import com.deepoove.poi.resolver.ElementTemplateFactory;
import com.deepoove.poi.resolver.RunningRunParagraph;
import com.deepoove.poi.template.BlockTemplate;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.template.PictureTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.CTDrawingWrapper;
import com.deepoove.poi.xwpf.XWPFRunWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateResolver
extends AbstractResolver {
    private static Logger logger = LoggerFactory.getLogger(TemplateResolver.class);
    private ElementTemplateFactory elementTemplateFactory;

    public TemplateResolver(Configure config) {
        this(config, config.getElementTemplateFactory());
    }

    private TemplateResolver(Configure config, ElementTemplateFactory elementTemplateFactory) {
        super(config);
        this.elementTemplateFactory = elementTemplateFactory;
    }

    @Override
    public List<MetaTemplate> resolveDocument(XWPFDocument doc) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (null == doc) {
            return metaTemplates;
        }
        logger.info("Resolve the document start...");
        metaTemplates.addAll(this.resolveBodyElements(doc.getBodyElements()));
        metaTemplates.addAll(this.resolveBodys(doc.getHeaderList()));
        metaTemplates.addAll(this.resolveBodys(doc.getFooterList()));
        metaTemplates.addAll(this.resolveBodys(doc.getFootnotes()));
        metaTemplates.addAll(this.resolveBodys(doc.getEndnotes()));
        logger.info("Resolve the document end, resolve and create {} MetaTemplates.", (Object)metaTemplates.size());
        return metaTemplates;
    }

    @Override
    public List<MetaTemplate> resolveBodyElements(List<IBodyElement> bodyElements) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (null == bodyElements) {
            return metaTemplates;
        }
        LinkedList<BlockTemplate> stack = new LinkedList<BlockTemplate>();
        for (IBodyElement element : bodyElements) {
            XWPFTable table;
            List rows;
            if (element == null) continue;
            if (element.getElementType() == BodyElementType.PARAGRAPH) {
                XWPFParagraph paragraph = (XWPFParagraph)element;
                new RunningRunParagraph(paragraph, this.templatePattern).refactorRun();
                this.resolveXWPFRuns(paragraph.getRuns(), metaTemplates, stack);
                continue;
            }
            if (element.getElementType() != BodyElementType.TABLE || null == (rows = (table = (XWPFTable)element).getRows())) continue;
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                if (null == cells) continue;
                cells.forEach(cell -> this.addNewMeta((List<MetaTemplate>)metaTemplates, (Deque<BlockTemplate>)stack, (MetaTemplate)((Object)this.resolveBodyElements(cell.getBodyElements()))));
            }
        }
        this.checkStack(stack);
        return metaTemplates;
    }

    @Override
    public List<MetaTemplate> resolveXWPFRuns(List<XWPFRun> runs) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (runs == null) {
            return metaTemplates;
        }
        LinkedList<BlockTemplate> stack = new LinkedList<BlockTemplate>();
        this.resolveXWPFRuns(runs, metaTemplates, stack);
        this.checkStack(stack);
        return metaTemplates;
    }

    private void resolveXWPFRuns(List<XWPFRun> runs, List<MetaTemplate> metaTemplates, Deque<BlockTemplate> stack) {
        for (XWPFRun run : runs) {
            String text = null;
            text = run.getText(0);
            if (StringUtils.isBlank((CharSequence)text)) {
                List<MetaTemplate> visitBodyElements = this.resolveTextbox(run);
                if (!visitBodyElements.isEmpty()) {
                    this.addNewMeta(metaTemplates, stack, (MetaTemplate)((Object)visitBodyElements));
                    continue;
                }
                List<PictureTemplate> pictureTemplates = this.resolveXWPFPictures(run.getEmbeddedPictures());
                if (!pictureTemplates.isEmpty()) {
                    this.addNewMeta(metaTemplates, stack, (MetaTemplate)((Object)pictureTemplates));
                    continue;
                }
                ChartTemplate chartTemplate = this.resolveXWPFChart(run);
                if (null == chartTemplate) continue;
                this.addNewMeta(metaTemplates, stack, chartTemplate);
                continue;
            }
            RunTemplate runTemplate = (RunTemplate)this.parseTemplateFactory(text, run, run);
            if (null == runTemplate) continue;
            char charValue = runTemplate.getSign().charValue();
            if (charValue == ((Character)this.config.getIterable().getLeft()).charValue()) {
                IterableTemplate freshIterableTemplate = new IterableTemplate(runTemplate);
                stack.push(freshIterableTemplate);
                continue;
            }
            if (charValue == ((Character)this.config.getIterable().getRight()).charValue()) {
                if (stack.isEmpty()) {
                    throw new ResolverException("Mismatched start/end tags: No start mark found for end mark " + runTemplate);
                }
                BlockTemplate latestIterableTemplate = stack.pop();
                if (StringUtils.isNotEmpty((CharSequence)runTemplate.getTagName()) && !latestIterableTemplate.getStartMark().getTagName().equals(runTemplate.getTagName())) {
                    throw new ResolverException("Mismatched start/end tags: start mark " + latestIterableTemplate.getStartMark() + " does not match to end mark " + runTemplate);
                }
                latestIterableTemplate.setEndMark(runTemplate);
                if (latestIterableTemplate instanceof IterableTemplate) {
                    latestIterableTemplate = ((IterableTemplate)latestIterableTemplate).buildIfInline();
                }
                this.addNewMeta(metaTemplates, stack, latestIterableTemplate);
                continue;
            }
            this.addNewMeta(metaTemplates, stack, runTemplate);
        }
    }

    private ChartTemplate resolveXWPFChart(XWPFRun run) {
        CTDrawing ctDrawing = this.getCTDrawing(run);
        if (null == ctDrawing) {
            return null;
        }
        CTDrawingWrapper wrapper = new CTDrawingWrapper(ctDrawing);
        String rid = wrapper.getCharId();
        if (null == rid) {
            return null;
        }
        POIXMLDocumentPart documentPart = run.getDocument().getRelationById(rid);
        if (null == documentPart || !(documentPart instanceof XWPFChart)) {
            return null;
        }
        ElementTemplate template = this.parseTemplateFactory(wrapper.getTitle(), (XWPFChart)documentPart, run);
        return null == template ? (ChartTemplate)this.parseTemplateFactory(wrapper.getDesc(), (XWPFChart)documentPart, run) : (ChartTemplate)template;
    }

    private List<PictureTemplate> resolveXWPFPictures(List<XWPFPicture> embeddedPictures) {
        ArrayList<PictureTemplate> metaTemplates = new ArrayList<PictureTemplate>();
        if (embeddedPictures == null) {
            return metaTemplates;
        }
        for (XWPFPicture pic : embeddedPictures) {
            CTDrawing ctDrawing = this.getCTDrawing(pic);
            if (null == ctDrawing) continue;
            CTDrawingWrapper wrapper = new CTDrawingWrapper(ctDrawing);
            PictureTemplate pictureTemplate = (PictureTemplate)this.parseTemplateFactory(wrapper.getTitle(), pic, null);
            if (null == pictureTemplate) {
                pictureTemplate = (PictureTemplate)this.parseTemplateFactory(wrapper.getDesc(), pic, null);
            }
            if (null == pictureTemplate) continue;
            metaTemplates.add(pictureTemplate);
        }
        return metaTemplates;
    }

    private CTDrawing getCTDrawing(XWPFPicture pic) throws RuntimeException {
        XWPFRun run = (XWPFRun)ReflectionUtils.getValue("run", pic);
        return this.getCTDrawing(run);
    }

    private CTDrawing getCTDrawing(XWPFRun run) {
        CTR ctr = run.getCTR();
        CTDrawing ctDrawing = CollectionUtils.isNotEmpty((Collection)ctr.getDrawingList()) ? ctr.getDrawingArray(0) : null;
        return ctDrawing;
    }

    private void addNewMeta(List<MetaTemplate> metaTemplates, Deque<BlockTemplate> stack, List<? extends MetaTemplate> newMeta) {
        if (stack.isEmpty()) {
            metaTemplates.addAll(newMeta);
        } else {
            stack.peek().getTemplates().addAll(newMeta);
        }
    }

    private <T extends MetaTemplate> void addNewMeta(List<MetaTemplate> metaTemplates, Deque<BlockTemplate> stack, T newMeta) {
        if (stack.isEmpty()) {
            metaTemplates.add(newMeta);
        } else {
            stack.peek().getTemplates().add(newMeta);
        }
    }

    private void checkStack(Deque<BlockTemplate> stack) {
        if (!stack.isEmpty()) {
            throw new ResolverException("Mismatched start/end tags: No end iterable mark found for start mark " + stack.peek());
        }
    }

    private List<MetaTemplate> resolveTextbox(XWPFRun run) {
        XWPFRunWrapper runWrapper = new XWPFRunWrapper(run);
        if (null == runWrapper.getWpstxbx()) {
            return new ArrayList<MetaTemplate>();
        }
        return this.resolveBodyElements(runWrapper.getWpstxbx().getBodyElements());
    }

    <T extends IBody> List<MetaTemplate> resolveBodys(List<T> bodys) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (null == bodys) {
            return metaTemplates;
        }
        bodys.forEach(body -> metaTemplates.addAll(this.resolveBodyElements(body.getBodyElements())));
        return metaTemplates;
    }

    ElementTemplate parseTemplateFactory(String text, Object obj, XWPFRun run) {
        if (null == text) {
            return null;
        }
        if (this.templatePattern.matcher(text).matches()) {
            logger.debug("Resolve where text: {}, and create ElementTemplate for {}", (Object)text, obj.getClass());
            String tag = this.gramerPattern.matcher(text).replaceAll("").trim();
            if (obj.getClass() == XWPFRun.class) {
                return this.elementTemplateFactory.createRunTemplate(tag, (XWPFRun)obj);
            }
            if (obj.getClass() == XWPFPicture.class) {
                return this.elementTemplateFactory.createPicureTemplate(tag, (XWPFPicture)obj);
            }
            if (obj.getClass() == XWPFChart.class) {
                return this.elementTemplateFactory.createChartTemplate(tag, (XWPFChart)obj, run);
            }
        }
        return null;
    }
}

