/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.reference;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.ChartMultiSeriesRenderData;
import com.deepoove.poi.data.SeriesRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.reference.AbstractChartTemplateRenderPolicy;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.poi.xddf.usermodel.chart.XDDFAreaChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xwpf.usermodel.XWPFChart;

public class MultiSeriesChartTemplateRenderPolicy
extends AbstractChartTemplateRenderPolicy<ChartMultiSeriesRenderData> {
    @Override
    public void doRender(ChartTemplate eleTemplate, ChartMultiSeriesRenderData data, XWPFTemplate template) throws Exception {
        long nullCount;
        if (null == data) {
            return;
        }
        XWPFChart chart = eleTemplate.getChart();
        List chartSeries = chart.getChartSeries();
        if (chartSeries.size() >= 2 && (nullCount = data.getSeriesDatas().stream().filter(d -> null == d.getComboType()).count()) > 0L) {
            throw new RenderException("Combo chart must set comboType field of series!");
        }
        int totalSeriesCount = chartSeries.stream().mapToInt(XDDFChartData::getSeriesCount).sum();
        Field field = ReflectionUtils.findField(XDDFChart.class, "seriesCount");
        field.setAccessible(true);
        field.set(chart, totalSeriesCount);
        int valueCol = 0;
        ArrayList<SeriesRenderData> usedSeriesDatas = new ArrayList<SeriesRenderData>();
        for (XDDFChartData chartData : chartSeries) {
            int orignSize = chartData.getSeriesCount();
            List<SeriesRenderData> seriesDatas = null;
            seriesDatas = chartSeries.size() <= 1 ? data.getSeriesDatas() : this.obtainSeriesData(chartData.getClass(), data.getSeriesDatas());
            usedSeriesDatas.addAll(seriesDatas);
            int seriesSize = seriesDatas.size();
            XDDFCategoryDataSource categoriesData = this.createCategoryDataSource(chart, data.getCategories());
            for (int i = 0; i < seriesSize; ++i) {
                XDDFNumericalDataSource valuesData = this.createValueDataSource(chart, seriesDatas.get(i).getValues(), valueCol);
                XDDFChartData.Series currentSeries = null;
                if (i < orignSize) {
                    currentSeries = chartData.getSeries(i);
                    currentSeries.replaceData((XDDFDataSource)categoriesData, valuesData);
                } else {
                    currentSeries = chartData.addSeries((XDDFDataSource)categoriesData, valuesData);
                    this.processNewSeries(chartData, currentSeries);
                }
                String name = seriesDatas.get(i).getName();
                currentSeries.setTitle(name, chart.setSheetTitle(name, valueCol + 1));
                ++valueCol;
            }
            this.removeExtraSeries(chartData, orignSize, seriesSize);
        }
        XSSFSheet sheet = chart.getWorkbook().getSheetAt(0);
        this.updateCTTable(sheet, usedSeriesDatas);
        this.removeExtraSheetCell(sheet, data.getCategories().length, totalSeriesCount, usedSeriesDatas.size());
        for (XDDFChartData chartData : chartSeries) {
            this.plot(chart, chartData);
        }
        chart.setTitleText(data.getChartTitle());
        chart.setTitleOverlay(false);
    }

    protected void processNewSeries(XDDFChartData chartData, XDDFChartData.Series addSeries) {
    }

    private List<SeriesRenderData> obtainSeriesData(Class<? extends XDDFChartData> clazz, List<SeriesRenderData> seriesDatas) {
        Predicate<SeriesRenderData> predicate = data -> false;
        if (clazz.equals(XDDFBarChartData.class)) {
            predicate = data -> SeriesRenderData.ComboType.BAR == data.getComboType();
        } else if (clazz.equals(XDDFAreaChartData.class)) {
            predicate = data -> SeriesRenderData.ComboType.AREA == data.getComboType();
        } else if (clazz.equals(XDDFLineChartData.class)) {
            predicate = data -> SeriesRenderData.ComboType.LINE == data.getComboType();
        }
        return seriesDatas.stream().filter(predicate).collect(Collectors.toList());
    }
}

