/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;

public class DocPrSupport {
    public static void updateDocPrId(XWPFTable table) {
        List rows = table.getRows();
        rows.forEach(row -> {
            List cells = row.getTableCells();
            cells.forEach(cell -> {
                cell.getParagraphs().forEach(DocPrSupport::updateDocPrId);
                cell.getTables().forEach(DocPrSupport::updateDocPrId);
            });
        });
    }

    public static void updateDocPrId(XWPFParagraph paragraph) {
        DocPrSupport.updateDocPrId(paragraph.getRuns());
    }

    public static void updateDocPrId(List<XWPFRun> runs) {
        runs.forEach(DocPrSupport::updateDocPrId);
    }

    public static void updateDocPrId(XWPFRun run) {
        NiceXWPFDocument document = (NiceXWPFDocument)run.getDocument();
        if (!document.getDocPrIdenifierManager().isValid()) {
            return;
        }
        CTR r = run.getCTR();
        for (CTDrawing ctDrawing : r.getDrawingList()) {
            DocPrSupport.processCTDrawing(document, ctDrawing);
        }
        XmlObject[] xmlObjects = r.selectPath("declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace mc='http://schemas.openxmlformats.org/markup-compatibility/2006' .//mc:AlternateContent/mc:Choice/w:drawing");
        if (null == xmlObjects || xmlObjects.length <= 0) {
            return;
        }
        for (XmlObject xmlObject : xmlObjects) {
            try {
                CTDrawing ctDrawing = CTDrawing.Factory.parse((String)xmlObject.xmlText());
                DocPrSupport.processCTDrawing(document, ctDrawing);
                xmlObject.set((XmlObject)ctDrawing);
            }
            catch (XmlException xmlException) {
                // empty catch block
            }
        }
    }

    private static void processCTDrawing(NiceXWPFDocument document, CTDrawing ctDrawing) {
        for (CTAnchor anchor : ctDrawing.getAnchorList()) {
            if (anchor.getDocPr() == null) continue;
            anchor.getDocPr().setId(document.getDocPrIdenifierManager().reserveNew());
        }
        for (CTInline inline : ctDrawing.getInlineList()) {
            if (inline.getDocPr() == null) continue;
            inline.getDocPr().setId(document.getDocPrIdenifierManager().reserveNew());
        }
    }
}

