/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.resolver.AbstractVisitor;
import com.deepoove.poi.resolver.RunningRunParagraph;
import com.deepoove.poi.resolver.TemplateFactory;
import com.deepoove.poi.template.ElementTemplate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateVisitor
extends AbstractVisitor {
    private static Logger logger = LoggerFactory.getLogger(TemplateVisitor.class);
    private List<ElementTemplate> eleTemplates;

    public TemplateVisitor(Configure config) {
        super(config);
    }

    @Override
    public List<ElementTemplate> visitDocument(XWPFDocument doc) {
        this.eleTemplates = new ArrayList<ElementTemplate>();
        if (null == doc) {
            return this.eleTemplates;
        }
        logger.info("Visit the document start...");
        this.visitParagraphs(doc.getParagraphs());
        this.visitTables(doc.getTables());
        this.visitHeaders(doc.getHeaderList());
        this.visitFooters(doc.getFooterList());
        logger.info("Visit the document end, resolve and create {} ElementTemplates.", (Object)this.eleTemplates.size());
        return this.eleTemplates;
    }

    void visitHeaders(List<XWPFHeader> headers) {
        if (null == headers) {
            return;
        }
        headers.forEach(header -> {
            this.visitParagraphs(header.getParagraphs());
            this.visitTables(header.getTables());
        });
    }

    void visitFooters(List<XWPFFooter> footers) {
        if (null == footers) {
            return;
        }
        footers.forEach(footer -> {
            this.visitParagraphs(footer.getParagraphs());
            this.visitTables(footer.getTables());
        });
    }

    void visitParagraphs(List<XWPFParagraph> paragraphs) {
        if (null == paragraphs) {
            return;
        }
        paragraphs.forEach(paragraph -> this.visitParagraph((XWPFParagraph)paragraph));
    }

    void visitTables(List<XWPFTable> tables) {
        if (null == tables) {
            return;
        }
        tables.forEach(tb -> this.visitTable((XWPFTable)tb));
    }

    void visitTable(XWPFTable table) {
        if (null == table) {
            return;
        }
        List rows = table.getRows();
        this.visitTableRows(rows);
    }

    void visitTableRows(List<XWPFTableRow> rows) {
        if (null == rows) {
            return;
        }
        for (XWPFTableRow row : rows) {
            List cells = row.getTableCells();
            if (null == cells) continue;
            cells.forEach(cell -> {
                this.visitParagraphs(cell.getParagraphs());
                this.visitTables(cell.getTables());
            });
        }
    }

    void visitParagraph(XWPFParagraph paragraph) {
        if (null == paragraph) {
            return;
        }
        RunningRunParagraph runningRun = new RunningRunParagraph(paragraph, this.templatePattern);
        List<XWPFRun> refactorRuns = runningRun.refactorRun();
        if (null == refactorRuns) {
            return;
        }
        refactorRuns.forEach(run -> this.visitRun((XWPFRun)run));
    }

    void visitRun(XWPFRun run) {
        String text = null;
        if (null == run || StringUtils.isBlank((CharSequence)(text = run.getText(0)))) {
            return;
        }
        ElementTemplate elementTemplate = this.parseTemplateFactory(text, run);
        if (null != elementTemplate) {
            this.eleTemplates.add(elementTemplate);
        }
    }

    private <T> ElementTemplate parseTemplateFactory(String text, T obj) {
        logger.debug("Resolve where text: {}, and create ElementTemplate", (Object)text);
        if (this.templatePattern.matcher(text).matches()) {
            String tag = this.gramerPattern.matcher(text).replaceAll("").trim();
            if (obj.getClass() == XWPFRun.class) {
                return TemplateFactory.createRunTemplate(tag, this.config, (XWPFRun)obj);
            }
            if (obj.getClass() == XWPFTableCell.class) {
                return null;
            }
        }
        return null;
    }
}

