/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.ref;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.ref.OptionalText;
import com.deepoove.poi.policy.ref.ReferenceRenderPolicy;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.SimpleValue;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.impl.CTNonVisualDrawingPropsImpl;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;

public abstract class OptionalTextPictureRefRenderPolicy
extends ReferenceRenderPolicy<XWPFPicture>
implements OptionalText {
    protected static final QName TITLE = new QName("", "title");

    @Override
    protected XWPFPicture locate(XWPFTemplate template) {
        this.logger.info("Try locate the XWPFPicture object which mathing optional text [{}]...", (Object)this.optionalText());
        NiceXWPFDocument document = template.getXWPFDocument();
        List<XWPFPicture> pictures = document.getAllEmbeddedPictures();
        for (XWPFPicture pic : pictures) {
            CTDrawing ctDrawing = this.getCTDrawing(pic);
            if (null == ctDrawing) continue;
            CTNonVisualDrawingProps docPr = null;
            if (ctDrawing.sizeOfAnchorArray() > 0) {
                CTAnchor anchorArray = ctDrawing.getAnchorArray(0);
                docPr = anchorArray.getDocPr();
            } else if (ctDrawing.sizeOfInlineArray() > 0) {
                CTInline inline = ctDrawing.getInlineArray(0);
                docPr = inline.getDocPr();
            }
            if (null == docPr) continue;
            String title = this.getTitle(docPr);
            if (Objects.equals(this.optionalText(), title)) {
                return pic;
            }
            String descr = docPr.getDescr();
            if (!Objects.equals(this.optionalText(), descr)) continue;
            return pic;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTitle(CTNonVisualDrawingProps docPr) {
        CTNonVisualDrawingPropsImpl docPrImpl = (CTNonVisualDrawingPropsImpl)docPr;
        Object object = docPrImpl.monitor();
        synchronized (object) {
            SimpleValue localSimpleValue = null;
            localSimpleValue = (SimpleValue)docPrImpl.get_store().find_attribute_user(TITLE);
            if (localSimpleValue == null) {
                return null;
            }
            return localSimpleValue.getStringValue();
        }
    }

    public CTDrawing getCTDrawing(XWPFPicture pic) throws RuntimeException {
        XWPFRun run;
        try {
            Field field = XWPFPicture.class.getDeclaredField("run");
            field.setAccessible(true);
            run = (XWPFRun)field.get(pic);
        }
        catch (Exception e) {
            throw new RenderException("Get XWPFPicture CTDrawing error", e);
        }
        CTR ctr = run.getCTR();
        return ctr.getDrawingList() != null ? ctr.getDrawingArray(0) : null;
    }
}

