/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.exception.ResolverException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.ref.ReferenceRenderPolicy;
import com.deepoove.poi.render.RenderFactory;
import com.deepoove.poi.resolver.TemplateVisitor;
import com.deepoove.poi.resolver.Visitor;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.util.PoitlIOUtils;
import com.deepoove.poi.util.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.Version;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWPFTemplate {
    private static Logger logger = LoggerFactory.getLogger(XWPFTemplate.class);
    private static final String SUPPORT_MINIMUM_VERSION = "4.0.0";
    private NiceXWPFDocument doc;
    private Configure config;
    private Visitor visitor;
    private List<ElementTemplate> eleTemplates;

    private XWPFTemplate() {
    }

    public static XWPFTemplate compile(String filePath) {
        return XWPFTemplate.compile(new File(filePath));
    }

    public static XWPFTemplate compile(File file) {
        return XWPFTemplate.compile(file, Configure.createDefault());
    }

    public static XWPFTemplate compile(InputStream inputStream) {
        return XWPFTemplate.compile(inputStream, Configure.createDefault());
    }

    public static XWPFTemplate compile(String filePath, Configure config) {
        return XWPFTemplate.compile(new File(filePath), config);
    }

    public static XWPFTemplate compile(File file, Configure config) {
        try {
            return XWPFTemplate.compile(new FileInputStream(file), config);
        }
        catch (FileNotFoundException e) {
            throw new ResolverException("Cannot find the file [" + file.getPath() + "]", e);
        }
    }

    public static XWPFTemplate compile(InputStream inputStream, Configure config) {
        try {
            XWPFTemplate instance = new XWPFTemplate();
            instance.config = config;
            instance.doc = new NiceXWPFDocument(inputStream);
            instance.visitor = new TemplateVisitor(instance.config);
            instance.eleTemplates = instance.visitor.visitDocument(instance.doc);
            return instance;
        }
        catch (OLE2NotOfficeXmlFileException e) {
            logger.error("Poi-tl currently only supports .docx format");
            throw new ResolverException("Compile template failed", e);
        }
        catch (IOException e) {
            throw new ResolverException("Compile template failed", e);
        }
    }

    public XWPFTemplate render(Object model) {
        RenderFactory.getRender(model, this.config.getElMode()).render(this);
        return this;
    }

    public XWPFTemplate bindRefPolicy(ReferenceRenderPolicy<?> refPolicy) {
        this.config.referencePolicy(refPolicy);
        return this;
    }

    public XWPFTemplate bind(String tagName, RenderPolicy policy) {
        this.config.customPolicy(tagName, policy);
        return this;
    }

    public void write(OutputStream out) throws IOException {
        this.doc.write(out);
    }

    public void writeToFile(String path) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(path);
            this.write(out);
            out.flush();
        }
        catch (Throwable throwable) {
            PoitlIOUtils.closeQuietlyMulti(new Closeable[]{this.doc, out});
            throw throwable;
        }
        PoitlIOUtils.closeQuietlyMulti(new Closeable[]{this.doc, out});
    }

    public void reload(NiceXWPFDocument doc) {
        PoitlIOUtils.closeLoggerQuietly((Closeable)((Object)this.doc));
        this.doc = doc;
        this.eleTemplates = this.visitor.visitDocument(doc);
    }

    public void close() throws IOException {
        this.doc.close();
    }

    public List<ElementTemplate> getElementTemplates() {
        return this.eleTemplates;
    }

    public NiceXWPFDocument getXWPFDocument() {
        return this.doc;
    }

    public Configure getConfig() {
        return this.config;
    }

    static {
        Preconditions.checkMinimumVersion(Version.getVersion(), SUPPORT_MINIMUM_VERSION, (cur, min) -> "Require Apach POI version at least " + min + ", but now is " + cur + ", please check the dependency of project.");
    }
}

