/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.MiniTableRenderData;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.StyleUtils;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class MiniTableRenderPolicy
implements RenderPolicy {
    @Override
    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        NiceXWPFDocument doc = template.getXWPFDocument();
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        if (null == data) {
            return;
        }
        MiniTableRenderData tableData = (MiniTableRenderData)data;
        RowRenderData headers = tableData.getHeaders();
        List<RowRenderData> datas = tableData.getDatas();
        TableStyle style = tableData.getStyle();
        float width = tableData.getWidth();
        if (!tableData.isSetBody()) {
            if (!tableData.isSetHeader()) {
                run.setText("", 0);
                return;
            }
            int row = 2;
            int col = headers.size();
            int startRow = 1;
            XWPFTable table = this.createTableWithHeaders(doc, run, headers, row, col, width);
            StyleUtils.styleTable(table, style);
            NiceXWPFDocument.mergeCellsHorizonal(table, 1, 0, headers.size() - 1);
            XWPFTableCell cell = table.getRow(startRow).getCell(0);
            cell.setText(tableData.getNoDatadesc());
        } else {
            int row = datas.size();
            int col = 0;
            int startRow = 0;
            if (!tableData.isSetHeader()) {
                col = this.getMaxColumFromData(datas);
            } else {
                ++startRow;
                ++row;
                col = headers.size();
            }
            XWPFTable table = this.createTableWithHeaders(doc, run, headers, row, col, width);
            StyleUtils.styleTable(table, style);
            for (RowRenderData obj : datas) {
                MiniTableRenderPolicy.renderRow(table, startRow++, obj);
            }
        }
        run.setText("", 0);
    }

    private XWPFTable createTableWithHeaders(NiceXWPFDocument doc, XWPFRun run, RowRenderData headers, int row, int col, float width) {
        XWPFTable table = doc.insertNewTable(run, row, col);
        doc.widthTable(table, width, row, col);
        MiniTableRenderPolicy.renderRow(table, 0, headers);
        return table;
    }

    public static void renderRow(XWPFTable table, int row, RowRenderData rowData) {
        if (null == rowData || rowData.size() <= 0) {
            return;
        }
        int i = 0;
        TableStyle style = rowData.getStyle();
        List<TextRenderData> cellDatas = rowData.getRowData();
        XWPFTableCell cell = null;
        for (TextRenderData cellData : cellDatas) {
            cell = table.getRow(row).getCell(i);
            String[] fragment = cellData.getText().split("\\n");
            if (null != fragment) {
                CTTc ctTc = cell.getCTTc();
                CTP ctP = ctTc.sizeOfPArray() == 0 ? ctTc.addNewP() : ctTc.getPArray(0);
                XWPFParagraph par = new XWPFParagraph(ctP, (IBody)cell);
                StyleUtils.styleTableParagraph(par, style);
                XWPFRun run = par.createRun();
                StyleUtils.styleRun(run, cellData.getStyle());
                run.setText(fragment[0]);
                for (int j = 1; j < fragment.length; ++j) {
                    XWPFParagraph addParagraph = cell.addParagraph();
                    StyleUtils.styleTableParagraph(addParagraph, style);
                    run = addParagraph.createRun();
                    StyleUtils.styleRun(run, cellData.getStyle());
                    run.setText(fragment[j]);
                }
            }
            if (null != style && null != style.getBackgroundColor()) {
                cell.setColor(style.getBackgroundColor());
            }
            ++i;
        }
    }

    private int getMaxColumFromData(List<RowRenderData> datas) {
        int maxColom = 0;
        for (RowRenderData obj : datas) {
            if (null == obj || obj.size() <= maxColom) continue;
            maxColom = obj.size();
        }
        return maxColom;
    }
}

