/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.reference;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.ChartMultiSeriesRenderData;
import com.deepoove.poi.data.SeriesRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.reference.AbstractChartTemplateRenderPolicy;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.poi.xddf.usermodel.chart.XDDFAreaChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFScatterChartData;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xwpf.usermodel.XWPFChart;

public class MultiSeriesChartTemplateRenderPolicy
extends AbstractChartTemplateRenderPolicy<ChartMultiSeriesRenderData> {
    @Override
    public void doRender(ChartTemplate eleTemplate, ChartMultiSeriesRenderData data, XWPFTemplate template) throws Exception {
        XWPFChart chart = eleTemplate.getChart();
        List chartSeries = chart.getChartSeries();
        this.validate(chartSeries, data);
        int totalSeriesCount = this.ensureSeriesCount(chart, chartSeries);
        int valueCol = 0;
        ArrayList<SeriesRenderData> usedSeriesDatas = new ArrayList<SeriesRenderData>();
        for (XDDFChartData chartData : chartSeries) {
            int orignSize = chartData.getSeriesCount();
            List<SeriesRenderData> currentSeriesData = null;
            currentSeriesData = chartSeries.size() <= 1 ? data.getSeriesDatas() : this.obtainSeriesData(chartData.getClass(), data.getSeriesDatas());
            usedSeriesDatas.addAll(currentSeriesData);
            int currentSeriesSize = currentSeriesData.size();
            XDDFDataSource<?> categoriesData = null;
            categoriesData = chartData instanceof XDDFScatterChartData ? this.createCategoryDataSource(chart, this.toNumberArray(data.getCategories())) : this.createCategoryDataSource(chart, data.getCategories());
            for (int i = 0; i < currentSeriesSize; ++i) {
                XDDFNumericalDataSource valuesData = this.createValueDataSource(chart, currentSeriesData.get(i).getValues(), valueCol);
                XDDFChartData.Series currentSeries = null;
                if (i < orignSize) {
                    currentSeries = chartData.getSeries(i);
                    valuesData.setFormatCode(currentSeries.getValuesData().getFormatCode());
                    currentSeries.replaceData(categoriesData, valuesData);
                } else {
                    currentSeries = chartData.addSeries(categoriesData, valuesData);
                    this.processNewSeries(chartData, currentSeries);
                }
                String name = currentSeriesData.get(i).getName();
                currentSeries.setTitle(name, chart.setSheetTitle(name, valueCol + 1));
                ++valueCol;
            }
            this.removeExtraSeries(chartData, orignSize, currentSeriesSize);
        }
        XSSFSheet sheet = chart.getWorkbook().getSheetAt(0);
        this.updateCTTable(sheet, usedSeriesDatas);
        this.removeExtraSheetCell(sheet, data.getCategories().length, totalSeriesCount, usedSeriesDatas.size());
        for (XDDFChartData chartData : chartSeries) {
            this.plot(chart, chartData);
        }
        this.setTitle(chart, data.getChartTitle());
        this.setAxisTitle(chart, data.getxAxisTitle(), data.getyAxisTitle());
    }

    protected void processNewSeries(XDDFChartData chartData, XDDFChartData.Series addSeries) {
    }

    private int ensureSeriesCount(XWPFChart chart, List<XDDFChartData> chartSeries) throws IllegalAccessException {
        int totalSeriesCount = chartSeries.stream().mapToInt(XDDFChartData::getSeriesCount).sum();
        Field field = ReflectionUtils.findField(XDDFChart.class, "seriesCount");
        field.setAccessible(true);
        field.set(chart, totalSeriesCount);
        return totalSeriesCount;
    }

    private void validate(List<XDDFChartData> chartSeries, ChartMultiSeriesRenderData data) {
        long nullCount;
        if (chartSeries.size() >= 2 && (nullCount = data.getSeriesDatas().stream().filter(d -> null == d.getComboType()).count()) > 0L) {
            throw new RenderException("Combo chart must set comboType field of series!");
        }
    }

    private List<SeriesRenderData> obtainSeriesData(Class<? extends XDDFChartData> clazz, List<SeriesRenderData> seriesDatas) {
        Predicate<SeriesRenderData> predicate = data -> false;
        if (clazz.equals(XDDFBarChartData.class)) {
            predicate = data -> SeriesRenderData.ComboType.BAR == data.getComboType();
        } else if (clazz.equals(XDDFAreaChartData.class)) {
            predicate = data -> SeriesRenderData.ComboType.AREA == data.getComboType();
        } else if (clazz.equals(XDDFLineChartData.class)) {
            predicate = data -> SeriesRenderData.ComboType.LINE == data.getComboType();
        }
        return seriesDatas.stream().filter(predicate).collect(Collectors.toList());
    }
}

