/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.xwpf.AbstractXWPFDocumentMerge;
import com.deepoove.poi.xwpf.DefaultXmlOptions;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import com.deepoove.poi.xwpf.XWPFNumberingWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ooxml.util.POIXMLUnits;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;

public class XmlXWPFDocumentMerge
extends AbstractXWPFDocumentMerge {
    private static final String CROSS_REPLACE_STRING = "@PoiTL@";
    private static ThreadLocal<Map<String, String>> styleCacheThreadLocal = new ThreadLocal();

    @Override
    public NiceXWPFDocument merge(NiceXWPFDocument source, Iterator<NiceXWPFDocument> mergeIterator, XWPFRun run) throws Exception {
        CTBody body = source.getDocument().getBody();
        List<String> addParts = this.createMergeableStrings(source, mergeIterator);
        String[] startEnd = this.truncatedStartEndXmlFragment(body);
        XWPFParagraph paragraph = (XWPFParagraph)run.getParent();
        CTP mergedContainer = paragraph.getCTP();
        CTP mergedBody = (CTP)CTP.Factory.parse(startEnd[0] + String.join((CharSequence)"", addParts) + startEnd[1]);
        mergedContainer.set((XmlObject)mergedBody);
        String xmlText = this.truncatedOverlapWP(body);
        body.set((XmlObject)CTBody.Factory.parse(xmlText));
        return source.generate(true);
    }

    private String truncatedOverlapWP(CTBody body) {
        String xmlText = body.xmlText(DefaultXmlOptions.OPTIONS_INNER);
        xmlText = xmlText.replaceAll("<w:p><w:p>", "<w:p>").replaceAll("<w:p><w:p\\s", "<w:p ").replaceAll("<w:p><w:tbl>", "<w:tbl>").replaceAll("<w:p><w:tbl\\s", "<w:tbl ");
        xmlText = xmlText.replaceAll("</w:sectPr></w:p>", "</w:sectPr>").replaceAll("</w:p></w:p>", "</w:p>").replaceAll("</w:tbl></w:p>", "</w:tbl>").replaceAll("<w:p(\\s[A-Za-z0-9:\\s=\"]*)?/></w:p>", "").replaceAll("</w:p><w:bookmarkEnd(\\s[A-Za-z0-9:\\s=\"]*)?/></w:p>", "</w:p>");
        return xmlText;
    }

    private String[] truncatedStartEndXmlFragment(CTBody body) {
        String srcString = body.xmlText(DefaultXmlOptions.OPTIONS_INNER);
        if (!srcString.startsWith("<xml-fragment")) {
            body.addNewSectPr();
            srcString = body.xmlText(DefaultXmlOptions.OPTIONS_INNER);
        }
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String suffix = srcString.substring(srcString.lastIndexOf("<"));
        return new String[]{prefix, suffix};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> createMergeableStrings(NiceXWPFDocument source, Iterator<NiceXWPFDocument> iterator) throws InvalidFormatException, IOException {
        ArrayList<String> addParts = new ArrayList<String>();
        if (!iterator.hasNext()) {
            return addParts;
        }
        NiceXWPFDocument next = iterator.next();
        styleCacheThreadLocal.set(this.mergeStyles(source, next));
        try {
            this.mergeNamespaces(source, next);
            while (true) {
                addParts.add(this.createMergeableString(source, next));
                try {
                    next.close();
                }
                catch (Exception e) {
                    this.logger.warn("close merged doc failed!", (Throwable)e);
                }
                if (iterator.hasNext()) {
                    next = iterator.next();
                    continue;
                }
                break;
            }
        }
        finally {
            styleCacheThreadLocal.remove();
        }
        return addParts;
    }

    private void mergeNamespaces(NiceXWPFDocument source, NiceXWPFDocument docMerge) {
        CTDocument1 document = source.getDocument();
        XmlCursor newCursor = document.newCursor();
        if (this.toStartCursor(newCursor)) {
            CTDocument1 documentMerge = docMerge.getDocument();
            XmlCursor mergeCursor = documentMerge.newCursor();
            if (this.toStartCursor(mergeCursor)) {
                HashMap<String, String> addToThis = new HashMap<String, String>();
                mergeCursor.getAllNamespaces(addToThis);
                addToThis.forEach((arg_0, arg_1) -> ((XmlCursor)newCursor).insertNamespace(arg_0, arg_1));
            }
            mergeCursor.dispose();
        }
        newCursor.dispose();
    }

    private boolean toStartCursor(XmlCursor newCursor) {
        while (true) {
            if (newCursor.currentTokenType().isStart()) {
                return true;
            }
            if (!newCursor.hasNextToken()) break;
            newCursor.toNextToken();
        }
        return false;
    }

    private String createMergeableString(NiceXWPFDocument source, NiceXWPFDocument merged) throws InvalidFormatException, IOException {
        CTBody mergedBody = merged.getDocument().getBody();
        Map<String, String> numIdsMap = this.mergeNumbering(source, merged);
        Map<String, String> blipIdsMap = this.mergePicture(source, merged);
        Map<String, String> externalBlipIdsMap = this.mergeExternalPicture(source, merged);
        Map<String, String> hyperlinkMap = this.mergeHyperlink(source, merged);
        Map<String, String> chartIdsMap = this.mergeChart(source, merged);
        Map<String, String> attachmentIdsMap = this.mergeAttachment(source, merged);
        String appendString = mergedBody.xmlText(DefaultXmlOptions.OPTIONS_OUTER);
        String addPart = this.ridSectPr(appendString);
        Map<String, String> styleIdsMap = styleCacheThreadLocal.get();
        for (String string : styleIdsMap.keySet()) {
            addPart = addPart.replaceAll("<w:pStyle\\sw:val=\"" + string + "\"", "<w:pStyle w:val=\"" + styleIdsMap.get(string) + "\"").replaceAll("<w:tblStyle\\sw:val=\"" + string + "\"", "<w:tblStyle w:val=\"" + styleIdsMap.get(string) + "\"").replaceAll("<w:rStyle\\sw:val=\"" + string + "\"", "<w:rStyle w:val=\"" + styleIdsMap.get(string) + "\"");
        }
        HashMap<String, String> placeHolderblipIdsMap = new HashMap<String, String>();
        for (String relaId : blipIdsMap.keySet()) {
            placeHolderblipIdsMap.put(relaId, blipIdsMap.get(relaId) + CROSS_REPLACE_STRING);
        }
        for (String relaId : placeHolderblipIdsMap.keySet()) {
            addPart = addPart.replaceAll("r:embed=\"" + relaId + "\"", "r:embed=\"" + (String)placeHolderblipIdsMap.get(relaId) + "\"");
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + (String)placeHolderblipIdsMap.get(relaId) + "\"");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String relaId : externalBlipIdsMap.keySet()) {
            hashMap.put(relaId, blipIdsMap.get(relaId) + CROSS_REPLACE_STRING);
        }
        for (String relaId : hashMap.keySet()) {
            addPart = addPart.replaceAll("r:link=\"" + relaId + "\"", "r:link=\"" + (String)hashMap.get(relaId) + "\"");
        }
        for (String relaId : hyperlinkMap.keySet()) {
            hyperlinkMap.put(relaId, hyperlinkMap.get(relaId) + CROSS_REPLACE_STRING);
        }
        for (String relaId : hyperlinkMap.keySet()) {
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + hyperlinkMap.get(relaId) + "\"");
        }
        for (String relaId : chartIdsMap.keySet()) {
            chartIdsMap.put(relaId, chartIdsMap.get(relaId) + CROSS_REPLACE_STRING);
        }
        for (String relaId : chartIdsMap.keySet()) {
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + chartIdsMap.get(relaId) + "\"");
        }
        for (String relaId : attachmentIdsMap.keySet()) {
            attachmentIdsMap.put(relaId, attachmentIdsMap.get(relaId) + CROSS_REPLACE_STRING);
        }
        for (String relaId : attachmentIdsMap.keySet()) {
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + attachmentIdsMap.get(relaId) + "\"");
        }
        for (String relaId : numIdsMap.keySet()) {
            numIdsMap.put(relaId, numIdsMap.get(relaId) + CROSS_REPLACE_STRING);
        }
        for (String numId : numIdsMap.keySet()) {
            addPart = addPart.replaceAll("<w:numId\\sw:val=\"" + numId + "\"", "<w:numId w:val=\"" + numIdsMap.get(numId) + "\"");
        }
        return addPart.replaceAll(CROSS_REPLACE_STRING, "");
    }

    private String ridSectPr(String appendString) {
        int lastIndexOf = appendString.lastIndexOf("<w:sectPr");
        String addPart = "";
        int begin = appendString.indexOf(">") + 1;
        int end = appendString.lastIndexOf("<");
        if (-1 != lastIndexOf) {
            String prefix = appendString.substring(begin, appendString.lastIndexOf("<w:sectPr"));
            String suffix = appendString.substring(appendString.lastIndexOf("</w:sectPr>") + 11, end);
            return prefix + suffix;
        }
        if (begin < end) {
            addPart = appendString.substring(begin, end);
        }
        return addPart;
    }

    private Map<String, String> mergePicture(NiceXWPFDocument source, NiceXWPFDocument merged) throws InvalidFormatException {
        HashMap<String, String> blipIdsMap = new HashMap<String, String>();
        List allPictures = merged.getAllPictures();
        for (XWPFPictureData xwpfPictureData : allPictures) {
            String relationId = merged.getRelationId((POIXMLDocumentPart)xwpfPictureData);
            String blidId = source.addPictureData(xwpfPictureData.getData(), xwpfPictureData.getPictureType());
            blipIdsMap.put(relationId, blidId);
        }
        return blipIdsMap;
    }

    private Map<String, String> mergeExternalPicture(NiceXWPFDocument source, NiceXWPFDocument merged) throws InvalidFormatException {
        HashMap<String, String> blipIdsMap = new HashMap<String, String>();
        PackageRelationshipCollection imagePart = merged.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
        for (PackageRelationship relationship : imagePart) {
            if (relationship.getTargetMode() != TargetMode.EXTERNAL) continue;
            PackageRelationship relationshipNew = source.getPackagePart().addExternalRelationship(relationship.getTargetURI().toString(), XWPFRelation.IMAGES.getRelation());
            blipIdsMap.putIfAbsent(relationship.getId(), relationshipNew.getId());
        }
        return blipIdsMap;
    }

    private Map<String, String> mergeNumbering(NiceXWPFDocument source, NiceXWPFDocument merged) {
        HashMap<String, String> numIdsMap = new HashMap<String, String>();
        XWPFNumbering numberingMerge = merged.getNumbering();
        if (null == numberingMerge) {
            return numIdsMap;
        }
        XWPFNumberingWrapper wrapperMerge = new XWPFNumberingWrapper(numberingMerge);
        List<XWPFNum> nums = wrapperMerge.getNums();
        if (null == nums) {
            return numIdsMap;
        }
        XWPFNumbering numbering = source.getNumbering();
        if (null == numbering) {
            numbering = source.createNumbering();
        }
        XWPFNumberingWrapper wrapper = new XWPFNumberingWrapper(numbering);
        HashMap<BigInteger, CTAbstractNum> cache = new HashMap<BigInteger, CTAbstractNum>();
        HashMap<BigInteger, CTAbstractNum> ret = new HashMap<BigInteger, CTAbstractNum>();
        for (XWPFNum xwpfNum : nums) {
            BigInteger mergeNumId2 = xwpfNum.getCTNum().getNumId();
            CTAbstractNum cTAbstractNum = (CTAbstractNum)cache.get(xwpfNum.getCTNum().getAbstractNumId().getVal());
            if (null == cTAbstractNum) {
                XWPFAbstractNum xwpfAbstractNum = numberingMerge.getAbstractNum(xwpfNum.getCTNum().getAbstractNumId().getVal());
                if (null == xwpfAbstractNum) {
                    this.logger.warn("cannot find cTAbstractNum by XWPFNum.");
                    continue;
                }
                cTAbstractNum = xwpfAbstractNum.getCTAbstractNum();
                if (cTAbstractNum.isSetNsid()) {
                    cTAbstractNum.unsetNsid();
                }
                if (cTAbstractNum.isSetTmpl()) {
                    cTAbstractNum.unsetTmpl();
                }
                cache.put(xwpfNum.getCTNum().getAbstractNumId().getVal(), cTAbstractNum);
            }
            ret.put(mergeNumId2, cTAbstractNum);
        }
        long nextId = wrapper.getNextAbstractNumID().longValue();
        HashSet hashSet = new HashSet(ret.values());
        for (CTAbstractNum abnum2 : hashSet) {
            abnum2.setAbstractNumId(BigInteger.valueOf(nextId++));
        }
        XWPFNumbering finalNumbering = numbering;
        ret.forEach((mergeNumId, abnum) -> {
            BigInteger numID = finalNumbering.addNum(finalNumbering.addAbstractNum(new XWPFAbstractNum(abnum)));
            numIdsMap.put(mergeNumId.toString(), numID.toString());
        });
        return numIdsMap;
    }

    private Map<String, String> mergeStyles(NiceXWPFDocument source, NiceXWPFDocument merged) {
        XWPFStyles stylesMerge;
        HashMap<String, String> styleIdsMap = new HashMap<String, String>();
        XWPFStyles styles = source.getStyles();
        if (null == styles) {
            styles = source.createStyles();
        }
        if (null == (stylesMerge = merged.getStyles())) {
            return styleIdsMap;
        }
        try {
            Field listStyleField = XWPFStyles.class.getDeclaredField("listStyle");
            listStyleField.setAccessible(true);
            List lists = (List)listStyleField.get(stylesMerge);
            String defaultParaStyleId = null;
            for (XWPFStyle xwpfStyle : lists) {
                String newId;
                CTStyle ctStyle;
                if (styles.styleExist(xwpfStyle.getStyleId())) {
                    String id = xwpfStyle.getStyleId();
                    xwpfStyle.setStyleId(UUID.randomUUID().toString().substring(0, 8));
                    styleIdsMap.put(id, xwpfStyle.getStyleId());
                }
                if ((ctStyle = xwpfStyle.getCTStyle()).isSetDefault() && POIXMLUnits.parseOnOff((STOnOff)ctStyle.xgetDefault()) && ctStyle.getType() == STStyleType.PARAGRAPH) {
                    defaultParaStyleId = ctStyle.getStyleId();
                }
                if (ctStyle.isSetDefault()) {
                    ctStyle.unsetDefault();
                }
                if (ctStyle.isSetName()) {
                    ctStyle.getName().setVal(ctStyle.getName().getVal() + xwpfStyle.getStyleId());
                }
                if (ctStyle.isSetBasedOn() && null != (newId = (String)styleIdsMap.get(ctStyle.getBasedOn().getVal()))) {
                    ctStyle.getBasedOn().setVal(newId);
                }
                styles.addStyle(xwpfStyle);
            }
            if (null != defaultParaStyleId) {
                String dpid = defaultParaStyleId;
                merged.getParagraphs().stream().filter(p -> null == p.getStyle()).forEach(p -> p.setStyle(dpid));
            }
        }
        catch (Exception e) {
            this.logger.error("merge style error", (Throwable)e);
        }
        return styleIdsMap;
    }

    private Map<String, String> mergeHyperlink(NiceXWPFDocument source, NiceXWPFDocument merged) throws InvalidFormatException {
        HashMap<String, String> map = new HashMap<String, String>();
        PackageRelationshipCollection hyperlinks = merged.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        for (PackageRelationship relationship : hyperlinks) {
            PackageRelationship relationshipNew = source.getPackagePart().addExternalRelationship(relationship.getTargetURI().toString(), XWPFRelation.HYPERLINK.getRelation());
            map.put(relationship.getId(), relationshipNew.getId());
        }
        return map;
    }

    private Map<String, String> mergeChart(NiceXWPFDocument source, NiceXWPFDocument merged) throws InvalidFormatException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        List charts = merged.getCharts();
        for (XWPFChart chart : charts) {
            String relationId = merged.getRelationId((POIXMLDocumentPart)chart);
            POIXMLDocumentPart.RelationPart addChartData = source.addChartData(chart);
            map.put(relationId, addChartData.getRelationship().getId());
        }
        return map;
    }

    private Map<String, String> mergeAttachment(NiceXWPFDocument source, NiceXWPFDocument merged) throws InvalidFormatException, IOException {
        HashMap<String, String> attachmentIdsMap = new HashMap<String, String>();
        PackageRelationshipCollection part = merged.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/package");
        for (PackageRelationship relationship : part) {
            PackagePart embeddPart = merged.getPackagePart().getRelatedPart(relationship);
            String path = relationship.getTargetURI().getPath();
            if (null == path || !path.endsWith(".docx") && !path.endsWith(".xlsx")) continue;
            try {
                byte[] byteData = IOUtils.toByteArray((InputStream)embeddPart.getInputStream());
                String newId = source.addEmbeddData(byteData, path.endsWith("docx") ? 0 : 1);
                attachmentIdsMap.putIfAbsent(relationship.getId(), newId);
            }
            catch (IOException e) {
                throw new POIXMLException((Throwable)e);
            }
        }
        return attachmentIdsMap;
    }
}

