/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.IOException;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTRelId;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;

public class DrawingSupport {
    public static void updateDocPrId(XWPFTable table) {
        List rows = table.getRows();
        rows.forEach(row -> {
            List cells = row.getTableCells();
            cells.forEach(cell -> {
                cell.getParagraphs().forEach(DrawingSupport::updateDocPrId);
                cell.getTables().forEach(DrawingSupport::updateDocPrId);
            });
        });
    }

    public static void updateDocPrId(XWPFParagraph paragraph) {
        DrawingSupport.updateDocPrId(paragraph.getRuns());
    }

    public static void updateDocPrId(List<XWPFRun> runs) {
        runs.forEach(DrawingSupport::updateDocPrId);
    }

    public static void updateDocPrId(XWPFRun run) {
        NiceXWPFDocument document = (NiceXWPFDocument)run.getDocument();
        if (!document.getDocPrIdenifierManager().isValid()) {
            return;
        }
        CTR r = run.getCTR();
        for (CTDrawing ctDrawing : r.getDrawingList()) {
            DrawingSupport.processCTDrawing(document, ctDrawing);
        }
        XmlObject[] xmlObjects = r.selectPath("declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace mc='http://schemas.openxmlformats.org/markup-compatibility/2006' .//mc:AlternateContent/mc:Choice/w:drawing");
        if (null == xmlObjects || xmlObjects.length <= 0) {
            return;
        }
        for (XmlObject xmlObject : xmlObjects) {
            try {
                CTDrawing ctDrawing = (CTDrawing)CTDrawing.Factory.parse(xmlObject.xmlText());
                DrawingSupport.processCTDrawing(document, ctDrawing);
                xmlObject.set((XmlObject)ctDrawing);
            }
            catch (XmlException xmlException) {
                // empty catch block
            }
        }
    }

    private static void processCTDrawing(NiceXWPFDocument document, CTDrawing ctDrawing) {
        for (CTAnchor anchor : ctDrawing.getAnchorList()) {
            if (anchor.getDocPr() != null) {
                anchor.getDocPr().setId(document.getDocPrIdenifierManager().reserveNew());
            }
            DrawingSupport.processCTGraaphicalObject(document, anchor.getGraphic());
        }
        for (CTInline inline : ctDrawing.getInlineList()) {
            if (inline.getDocPr() != null) {
                inline.getDocPr().setId(document.getDocPrIdenifierManager().reserveNew());
            }
            DrawingSupport.processCTGraaphicalObject(document, inline.getGraphic());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCTGraaphicalObject(NiceXWPFDocument document, CTGraphicalObject graphic) {
        CTGraphicalObjectData graphicData = graphic.getGraphicData();
        XmlCursor newCursor = graphicData.newCursor();
        try {
            boolean child = newCursor.toChild(0);
            if (!child) {
                return;
            }
            XmlObject xmlObject = newCursor.getObject();
            if (null == xmlObject || !(xmlObject instanceof CTRelId)) {
                return;
            }
            CTRelId cchart = (CTRelId)xmlObject;
            String rid = cchart.getId();
            if (null == rid) {
                return;
            }
            POIXMLDocumentPart documentPart = document.getRelationById(rid);
            if (null == documentPart || !(documentPart instanceof XWPFChart)) {
                return;
            }
            try {
                XWPFChart xwpfChart = (XWPFChart)documentPart;
                POIXMLDocumentPart.RelationPart relationPart = document.addChartData(xwpfChart);
                String id = relationPart.getRelationship().getId();
                cchart.setId(id);
            }
            catch (IOException | InvalidFormatException e) {
                e.printStackTrace();
            }
        }
        finally {
            newCursor.dispose();
        }
    }
}

