/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.xwpf.XWPFStructuredDocumentTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.ISDTContent;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFieldRun;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class XWPFStructuredDocumentTagContent
implements ISDTContent,
IRunBody,
IBody,
IBodyElement {
    private XWPFStructuredDocumentTag sdt;
    private CTSdtContentRun sdtContentRun;
    private CTSdtContentBlock sdtContentBlock;
    private CTSdtContentCell sdtContentCell;
    private final List<ISDTContents> sdtElements = new ArrayList<ISDTContents>();
    private List<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>();
    private List<XWPFTableCell> cells = new ArrayList<XWPFTableCell>();
    private List<XWPFRun> runs = new ArrayList<XWPFRun>();

    public XWPFStructuredDocumentTagContent(CTSdtContentRun sdtRun, IBody part, XWPFStructuredDocumentTag parent) {
        this.sdtContentRun = sdtRun;
        this.sdt = parent;
        if (sdtRun == null) {
            return;
        }
        XmlCursor cursor = sdtRun.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o = cursor.getObject();
            if (o instanceof CTR) {
                XWPFRun run = new XWPFRun((CTR)o, (IRunBody)this);
                this.runs.add(run);
                this.sdtElements.add((ISDTContents)run);
                continue;
            }
            if (!(o instanceof CTSdtRun)) continue;
            XWPFStructuredDocumentTag c = new XWPFStructuredDocumentTag((CTSdtRun)o, (IBody)this);
            this.sdtElements.add(c);
        }
        cursor.dispose();
    }

    public XWPFStructuredDocumentTagContent(CTSdtContentBlock block, IBody part, XWPFStructuredDocumentTag parent) {
        this.sdtContentBlock = block;
        this.sdt = parent;
        if (block == null) {
            return;
        }
        XmlCursor cursor = block.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o = cursor.getObject();
            if (o instanceof CTP) {
                XWPFParagraph p = new XWPFParagraph((CTP)o, (IBody)this);
                this.paragraphs.add(p);
                this.sdtElements.add((ISDTContents)p);
                continue;
            }
            if (o instanceof CTTbl) {
                XWPFTable t = new XWPFTable((CTTbl)o, (IBody)this);
                this.sdtElements.add((ISDTContents)t);
                continue;
            }
            if (o instanceof CTSdtBlock) {
                XWPFStructuredDocumentTag c = new XWPFStructuredDocumentTag((CTSdtBlock)o, (IBody)this);
                this.sdtElements.add(c);
                continue;
            }
            if (!(o instanceof CTR)) continue;
            XWPFRun run = new XWPFRun((CTR)o, (IRunBody)this);
            this.sdtElements.add((ISDTContents)run);
        }
        cursor.dispose();
    }

    public XWPFStructuredDocumentTagContent(CTSdtContentCell cell, XWPFTableRow row, IBody part, XWPFStructuredDocumentTag parent) {
        this.sdt = parent;
        this.sdtContentCell = cell;
        if (cell == null) {
            return;
        }
        XmlCursor cursor = cell.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o = cursor.getObject();
            if (!(o instanceof CTTc)) continue;
            XWPFTableCell c = new XWPFTableCell((CTTc)o, row, (IBody)this);
            this.cells.add(c);
        }
        cursor.dispose();
    }

    public XWPFRun insertNewRun(int pos) {
        if (pos == this.runs.size()) {
            return this.createRun();
        }
        return this.insertNewProvidedRun(pos, newCursor -> {
            String uri = CTR.type.getName().getNamespaceURI();
            String localPart = "r";
            newCursor.beginElement(localPart, uri);
            newCursor.toParent();
            CTR r = (CTR)newCursor.getObject();
            return new XWPFRun(r, (IRunBody)this);
        });
    }

    public XWPFRun createRun() {
        XWPFRun xwpfRun = new XWPFRun(this.sdtContentRun.addNewR(), (IRunBody)this);
        this.runs.add(xwpfRun);
        this.sdtElements.add((ISDTContents)xwpfRun);
        return xwpfRun;
    }

    private <T extends XWPFRun> T insertNewProvidedRun(int pos, Function<XmlCursor, T> provider) {
        if (pos >= 0 && pos < this.runs.size()) {
            XWPFRun run = this.runs.get(pos);
            CTR ctr = run.getCTR();
            XmlCursor newCursor = ctr.newCursor();
            if (!this.isCursorInRunContent(newCursor)) {
                newCursor.toParent();
            }
            if (this.isCursorInRunContent(newCursor)) {
                XWPFRun newRun = (XWPFRun)provider.apply(newCursor);
                int iPos = this.sdtElements.size();
                int oldAt = this.sdtElements.indexOf(run);
                if (oldAt != -1) {
                    iPos = oldAt;
                }
                this.sdtElements.add(iPos, (ISDTContents)newRun);
                this.runs.add(pos, newRun);
                return (T)newRun;
            }
            newCursor.dispose();
        }
        return null;
    }

    private boolean isCursorInRunContent(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        boolean result = verify.getObject() == this.sdtContentRun;
        verify.dispose();
        return result;
    }

    private boolean isCursorInBlockContent(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        boolean result = verify.getObject() == this.sdtContentBlock;
        verify.dispose();
        return result;
    }

    public boolean removeRun(int pos) {
        if (pos >= 0 && pos < this.runs.size()) {
            XWPFRun run = this.runs.get(pos);
            XmlCursor c = run.getCTR().newCursor();
            c.removeXml();
            c.dispose();
            this.runs.remove(pos);
            this.sdtElements.remove(run);
            return true;
        }
        return false;
    }

    public void setAndUpdateRun(XWPFRun xwpfRun, XWPFRun source, int insertPostionCursor) {
        int i;
        int rPos = 0;
        if (insertPostionCursor >= 0 && insertPostionCursor <= this.runs.size()) {
            for (i = 0; i < insertPostionCursor; ++i) {
                XWPFRun currRun = this.runs.get(i);
                if (currRun instanceof XWPFHyperlinkRun || currRun instanceof XWPFFieldRun) continue;
                ++rPos;
            }
        }
        this.sdtContentRun.setRArray(rPos, xwpfRun.getCTR());
        for (i = 0; i < this.runs.size(); ++i) {
            XWPFRun ele = this.runs.get(i);
            if (ele != source) continue;
            this.runs.set(i, xwpfRun);
        }
        List<ISDTContents> iruns = this.getSdtElements();
        for (int i2 = 0; i2 < iruns.size(); ++i2) {
            ISDTContents ele = iruns.get(i2);
            if (ele != source) continue;
            iruns.set(i2, (ISDTContents)xwpfRun);
        }
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        boolean addNewLine = false;
        for (int i = 0; i < this.sdtElements.size(); ++i) {
            ISDTContents o = this.sdtElements.get(i);
            if (o instanceof XWPFParagraph) {
                this.appendParagraph((XWPFParagraph)o, text);
                addNewLine = true;
            } else if (o instanceof XWPFTable) {
                this.appendTable((XWPFTable)o, text);
                addNewLine = true;
            } else if (o instanceof XWPFSDT) {
                text.append(((XWPFSDT)o).getContent().getText());
                addNewLine = true;
            } else if (o instanceof XWPFRun) {
                text.append(o);
                addNewLine = false;
            }
            if (!addNewLine || i >= this.sdtElements.size() - 1) continue;
            text.append("\n");
        }
        return text.toString();
    }

    private void appendTable(XWPFTable table, StringBuilder text) {
        for (XWPFTableRow row : table.getRows()) {
            List cells = row.getTableICells();
            for (int i = 0; i < cells.size(); ++i) {
                ICell cell = (ICell)cells.get(i);
                if (cell instanceof XWPFTableCell) {
                    text.append(((XWPFTableCell)cell).getTextRecursively());
                } else if (cell instanceof XWPFSDTCell) {
                    text.append(((XWPFSDTCell)cell).getContent().getText());
                }
                if (i >= cells.size() - 1) continue;
                text.append("\t");
            }
            text.append('\n');
        }
    }

    private void appendParagraph(XWPFParagraph paragraph, StringBuilder text) {
        for (IRunElement run : paragraph.getRuns()) {
            text.append(run);
        }
    }

    public String toString() {
        return this.getText();
    }

    public List<ISDTContents> getSdtElements() {
        return this.sdtElements;
    }

    public List<XWPFTableCell> getCells() {
        return this.cells;
    }

    public List<XWPFRun> getRuns() {
        return this.runs;
    }

    public XWPFStructuredDocumentTag getSdt() {
        return this.sdt;
    }

    public CTSdtContentRun getSdtContentRun() {
        return this.sdtContentRun;
    }

    public CTSdtContentBlock getSdtContentBlock() {
        return this.sdtContentBlock;
    }

    public CTSdtContentCell getSdtContentCell() {
        return this.sdtContentCell;
    }

    public XWPFDocument getDocument() {
        return this.getXWPFDocument();
    }

    public POIXMLDocumentPart getPart() {
        return this.sdt.getPart();
    }

    public BodyType getPartType() {
        return this.sdt.getPartType();
    }

    public List<XWPFParagraph> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    public void addParagraph(XWPFParagraph p) {
        this.paragraphs.add(p);
        this.sdtElements.add((ISDTContents)p);
    }

    public void removeParagraph(int pos) {
        XWPFParagraph removedParagraph = this.paragraphs.get(pos);
        this.paragraphs.remove(pos);
        this.sdtContentBlock.removeP(pos);
        this.sdtElements.remove(removedParagraph);
    }

    public void removeParagraph(XWPFParagraph paragraph) {
        if (this.paragraphs.contains(paragraph)) {
            CTP ctP = paragraph.getCTP();
            XmlCursor c = ctP.newCursor();
            c.removeXml();
            c.dispose();
            this.paragraphs.remove(paragraph);
            this.sdtElements.remove(paragraph);
        }
    }

    public XWPFParagraph getParagraph(CTP p) {
        for (XWPFParagraph paragraph : this.paragraphs) {
            if (!p.equals(paragraph.getCTP())) continue;
            return paragraph;
        }
        return null;
    }

    public XWPFParagraph getParagraphArray(int pos) {
        if (pos >= 0 && pos < this.paragraphs.size()) {
            return this.paragraphs.get(pos);
        }
        return null;
    }

    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (!this.isCursorInBlockContent(cursor)) {
            return null;
        }
        String uri = CTP.type.getName().getNamespaceURI();
        String localPart = "p";
        cursor.beginElement(localPart, uri);
        cursor.toParent();
        CTP p = (CTP)cursor.getObject();
        XWPFParagraph newP = new XWPFParagraph(p, (IBody)this);
        XmlObject o = null;
        while (!(o instanceof CTP) && cursor.toPrevSibling()) {
            o = cursor.getObject();
        }
        if (!(o instanceof CTP) || o == p) {
            this.paragraphs.add(0, newP);
        } else {
            int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
            this.paragraphs.add(pos, newP);
        }
        int i = 0;
        XmlCursor p2 = p.newCursor();
        cursor.toCursor(p2);
        p2.dispose();
        while (cursor.toPrevSibling()) {
            o = cursor.getObject();
            if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
            ++i;
        }
        this.sdtElements.add(i, (ISDTContents)newP);
        p2 = p.newCursor();
        cursor.toCursor(p2);
        p2.dispose();
        cursor.toEndToken();
        return newP;
    }

    public XWPFTable getTable(CTTbl ctTable) {
        return null;
    }

    public XWPFTable getTableArray(int pos) {
        return null;
    }

    public XWPFTable insertNewTbl(XmlCursor cursor) {
        throw new UnsupportedOperationException();
    }

    public void insertTable(int pos, XWPFTable table) {
        throw new UnsupportedOperationException();
    }

    public XWPFTableCell getTableCell(CTTc cell) {
        return null;
    }

    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.sdtElements.stream().filter(e -> e instanceof IBodyElement).map(e -> (IBodyElement)e).collect(Collectors.toList()));
    }

    public List<XWPFTable> getTables() {
        return null;
    }

    public XWPFDocument getXWPFDocument() {
        return this.sdt.getDocument();
    }

    public IBody getBody() {
        return this;
    }

    public BodyElementType getElementType() {
        return this.sdt.getElementType();
    }
}

