/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteUtils {
    private static Logger logger = LoggerFactory.getLogger(ByteUtils.class);

    public static byte[] getUrlByteArray(String urlPath) {
        try {
            return ByteUtils.toByteArray(ByteUtils.getUrlStream(urlPath));
        }
        catch (IOException e) {
            logger.error("getUrlPictureStream error,{},{}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static byte[] getLocalByteArray(File res) {
        try {
            logger.info("Read contents from local path:{}", (Object)res.toPath());
            return Files.readAllBytes(res.toPath());
        }
        catch (IOException e) {
            logger.error("Read all bytes error", (Throwable)e);
            return null;
        }
    }

    public static byte[] getBase64ByteArray(String base64) {
        boolean isBase64;
        String encodingPrefix = "base64,";
        if (base64.contains(encodingPrefix)) {
            int contentStartIndex = base64.indexOf(encodingPrefix) + encodingPrefix.length();
            base64 = base64.substring(contentStartIndex);
        }
        if (isBase64 = Base64.isBase64((String)base64)) {
            return Base64.decodeBase64((String)base64);
        }
        return null;
    }

    public static byte[] toByteArray(InputStream is) {
        if (null == is) {
            return null;
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            logger.error("toByteArray error", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
        return null;
    }

    public static InputStream getUrlStream(String urlPath) throws IOException {
        logger.info("Read contents from remote uri:{}", (Object)urlPath);
        URL url = new URL(urlPath);
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/4.0");
        InputStream inputStream = connection.getInputStream();
        if (connection instanceof HttpURLConnection && 200 != ((HttpURLConnection)connection).getResponseCode()) {
            throw new IOException("get url " + urlPath + " content error, response status: " + ((HttpURLConnection)connection).getResponseCode());
        }
        return inputStream;
    }

    public static boolean startsWith(byte[] bytes, byte[] prefix) {
        if (bytes == prefix) {
            return true;
        }
        if (null == prefix || null == bytes || bytes.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (bytes[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(byte[] bytes, byte[] suffix) {
        if (bytes == suffix) {
            return true;
        }
        if (null == suffix || null == bytes || bytes.length < suffix.length) {
            return false;
        }
        int length = bytes.length - suffix.length;
        for (int i = suffix.length - 1; i >= 0; --i) {
            if (bytes[length + i] == suffix[i]) continue;
            return false;
        }
        return true;
    }
}

