/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.xwpf.XWPFPageMargin;
import com.deepoove.poi.xwpf.XWPFPageSize;
import java.math.BigInteger;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;

public class XWPFSection {
    protected CTSectPr sectPr;
    protected XWPFPageMargin pageMargin;
    protected XWPFPageSize pageSize;

    public XWPFSection(CTSectPr sectPr) {
        this.sectPr = sectPr;
        this.pageMargin = new XWPFPageMargin(sectPr.getPgMar());
        this.pageSize = new XWPFPageSize(sectPr.getPgSz());
    }

    public boolean haveHeader(String headerRelationId) {
        if (null == headerRelationId) {
            return false;
        }
        List referenceList = this.sectPr.getHeaderReferenceList();
        for (CTHdrFtrRef ref : referenceList) {
            String id = ref.getId();
            if (!id.equals(headerRelationId)) continue;
            return true;
        }
        return false;
    }

    public boolean haveFooter(String footerRelationId) {
        if (null == footerRelationId) {
            return false;
        }
        List referenceList = this.sectPr.getFooterReferenceList();
        for (CTHdrFtrRef ref : referenceList) {
            String id = ref.getId();
            if (!id.equals(footerRelationId)) continue;
            return true;
        }
        return false;
    }

    public CTSectPr getSectPr() {
        return this.sectPr;
    }

    public XWPFPageMargin getPageMargin() {
        return this.pageMargin;
    }

    public XWPFPageSize getPageSize() {
        return this.pageSize;
    }

    public int getPageWidth() {
        return this.pageSize.getWidth();
    }

    public int getPageHeight() {
        return this.pageSize.getHeight();
    }

    public BigInteger getPageContentWidth() {
        return BigInteger.valueOf((long)this.getPageWidth() - this.pageMargin.getLeft().longValue() - this.pageMargin.getRight().longValue());
    }
}

