/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.reference;

import com.deepoove.poi.data.SeriesRenderData;
import com.deepoove.poi.policy.reference.AbstractTemplateRenderPolicy;
import com.deepoove.poi.template.ChartTemplate;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTitle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTx;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumns;

public abstract class AbstractChartTemplateRenderPolicy<T>
extends AbstractTemplateRenderPolicy<ChartTemplate, T> {
    protected final int FIRST_ROW = 1;
    protected final int CATEGORY_COL = 0;
    protected final int VALUE_START_COL = 1;

    protected XDDFCategoryDataSource createCategoryDataSource(XWPFChart chart, String[] categories) {
        return XDDFDataSourcesFactory.fromArray((String[])categories, (String)chart.formatRange(new CellRangeAddress(1, categories.length, 0, 0)), (int)0);
    }

    protected <N extends Number> XDDFNumericalDataSource<Number> createValueDataSource(XWPFChart chart, N[] data, int index) {
        return XDDFDataSourcesFactory.fromArray(data, (String)chart.formatRange(new CellRangeAddress(1, data.length, index + 1, index + 1)), (int)(index + 1));
    }

    protected void removeExtraSeries(XDDFChartData chartData, int orignSize, int seriesSize) {
        if (orignSize - seriesSize > 0) {
            for (int j = orignSize - 1; j >= seriesSize; --j) {
                chartData.removeSeries(j);
            }
        }
    }

    protected void removeExtraSheetCell(XSSFSheet sheet, int numOfPoints, int orignSize, int seriesSize) {
        if (orignSize - seriesSize > 0) {
            for (int i = 0; i < numOfPoints + 1; ++i) {
                for (int j = orignSize; j > seriesSize; --j) {
                    XSSFCell cell;
                    XSSFRow row = sheet.getRow(i);
                    if (null == row || null == (cell = row.getCell(j))) continue;
                    row.removeCell((Cell)cell);
                }
            }
        }
    }

    protected void updateCTTable(XSSFSheet sheet, List<SeriesRenderData> seriesDatas) {
        int seriesSize = seriesDatas.size();
        int numOfPoints = seriesDatas.get(0).getValues().length;
        CTTable ctTable = this.getSheetTable(sheet);
        String prefix = seriesSize >= 26 ? String.valueOf((char)(65 + (seriesSize / 26 - 1))) : "";
        char c = (char)(65 + seriesSize % 26);
        String ref = "A1:" + prefix + c + (numOfPoints + 1);
        ctTable.setRef(ref);
        CTTableColumns tableColumns = ctTable.getTableColumns();
        tableColumns.setCount((long)(seriesSize + 1));
        int size = tableColumns.sizeOfTableColumnArray();
        for (int i = size - 1; i >= 0; --i) {
            tableColumns.removeTableColumn(i);
        }
        CTTableColumn column = tableColumns.addNewTableColumn();
        column.setId(1L);
        column.setName(" ");
        for (int i = 0; i < seriesSize; ++i) {
            column = tableColumns.addNewTableColumn();
            column.setId((long)(1 + i + 1));
            column.setName(seriesDatas.get(i).getName());
        }
    }

    protected CTTable getSheetTable(XSSFSheet sheet) {
        if (sheet.getTables().size() == 0) {
            XSSFTable newTable = sheet.createTable(null);
            newTable.getCTTable().addNewTableColumns();
            sheet.getTables().add(newTable);
        }
        return ((XSSFTable)sheet.getTables().get(0)).getCTTable();
    }

    protected void plot(XWPFChart chart, XDDFChartData data) throws Exception {
        XSSFSheet sheet = chart.getWorkbook().getSheetAt(0);
        Method method = XDDFChart.class.getDeclaredMethod("fillSheet", XSSFSheet.class, XDDFDataSource.class, XDDFNumericalDataSource.class);
        method.setAccessible(true);
        for (XDDFChartData.Series series : data.getSeries()) {
            boolean numeric = series.getCategoryData().isNumeric();
            if (!numeric) {
                Method getAxDSMethod = series.getClass().getDeclaredMethod("getAxDS", new Class[0]);
                getAxDSMethod.setAccessible(true);
                CTAxDataSource axDataSource = (CTAxDataSource)getAxDSMethod.invoke((Object)series, new Object[0]);
                if (axDataSource.isSetNumRef()) {
                    axDataSource.unsetNumRef();
                }
                if (axDataSource.isSetNumLit()) {
                    axDataSource.unsetNumLit();
                }
            }
            series.plot();
            method.invoke((Object)chart, sheet, series.getCategoryData(), series.getValuesData());
        }
    }

    protected void setTitle(XWPFChart chart, String title) {
        if (null == title && chart.getCTChart().isSetTitle()) {
            chart.getCTChart().unsetTitle();
            return;
        }
        boolean isSet = false;
        CTTitle ctTitle = chart.getCTChart().getTitle();
        if (null != ctTitle) {
            CTTextBody body;
            CTTx tx;
            if (!ctTitle.isSetTx()) {
                ctTitle.addNewTx();
            }
            if ((tx = ctTitle.getTx()).isSetStrRef()) {
                tx.unsetStrRef();
            }
            if (!tx.isSetRich()) {
                tx.addNewRich();
            }
            if ((body = tx.getRich()).sizeOfPArray() > 0) {
                for (int i = body.sizeOfPArray() - 1; i > 0; --i) {
                    body.removeP(i);
                }
                CTTextParagraph pArray = body.getPArray(0);
                if (pArray.sizeOfRArray() > 0) {
                    for (int i = pArray.sizeOfRArray() - 1; i > 0; --i) {
                        pArray.removeR(i);
                    }
                    CTRegularTextRun rArray = pArray.getRArray(0);
                    rArray.setT(title);
                    isSet = true;
                }
            }
        }
        if (!isSet) {
            chart.setTitleText(title);
            chart.setTitleOverlay(false);
        }
    }
}

