/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.NumberingFormat;
import com.deepoove.poi.data.NumberingItemRenderData;
import com.deepoove.poi.data.NumberingRenderData;
import com.deepoove.poi.data.Numberings;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.ParagraphRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class NumberingRenderPolicy
extends AbstractRenderPolicy<Object> {
    @Override
    protected boolean validate(Object data) {
        if (null == data) {
            return false;
        }
        if (data instanceof NumberingRenderData) {
            return CollectionUtils.isNotEmpty(((NumberingRenderData)data).getItems());
        }
        return data instanceof Iterable;
    }

    @Override
    public void doRender(RenderContext<Object> context) throws Exception {
        Helper.renderNumbering(context.getRun(), NumberingRenderPolicy.wrapper(context.getData()));
    }

    @Override
    protected void afterRender(RenderContext<Object> context) {
        this.clearPlaceholder(context, true);
    }

    private static NumberingRenderData wrapper(Object obj) {
        if (obj instanceof NumberingRenderData) {
            return (NumberingRenderData)obj;
        }
        Numberings.NumberingBuilder ofBullet = Numberings.ofBullet();
        if (obj instanceof Iterable) {
            for (Object next : (Iterable)obj) {
                if (next instanceof TextRenderData) {
                    ofBullet.addItem((TextRenderData)next);
                    continue;
                }
                if (next instanceof PictureRenderData) {
                    ofBullet.addItem((PictureRenderData)next);
                    continue;
                }
                if (next instanceof ParagraphRenderData) {
                    ofBullet.addItem((ParagraphRenderData)next);
                    continue;
                }
                ofBullet.addItem(next.toString());
            }
        }
        return ofBullet.create();
    }

    public static class Helper {
        public static void renderNumbering(XWPFRun run, NumberingRenderData data) throws Exception {
            List<NumberingItemRenderData> items = data.getItems();
            NumberingFormat[] array = data.getFormats().toArray(new NumberingFormat[0]);
            BigInteger numID = ((NiceXWPFDocument)run.getParent().getDocument()).addNewMultiLevelNumberingId(array);
            BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(run);
            for (NumberingItemRenderData item : items) {
                XWPFParagraph paragraph = bodyContainer.insertNewParagraph(run);
                int level = item.getLevel();
                if (-1 != level) {
                    paragraph.setNumID(numID);
                    paragraph.setNumILvl(BigInteger.valueOf(level));
                }
                XWPFRun createRun = paragraph.createRun();
                StyleUtils.styleRun(createRun, run);
                ParagraphRenderPolicy.Helper.renderParagraph(createRun, item.getItem());
            }
        }
    }
}

