/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.style.PictureStyle;
import com.deepoove.poi.util.BufferedImageUtils;
import com.deepoove.poi.util.ByteUtils;
import com.deepoove.poi.util.UnitUtils;
import com.deepoove.poi.xwpf.WidthScalePattern;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.function.Supplier;

public class Pictures {
    private Pictures() {
    }

    public static PictureBuilder ofLocal(String path) {
        return Pictures.of(new LocalPictureSupplier(path), PictureType.suggestFileType(path));
    }

    public static PictureBuilder ofUrl(String url, PictureType pictureType) {
        return Pictures.of(new UrlPictureSupplier(url), pictureType);
    }

    public static PictureBuilder ofUrl(String url) {
        return Pictures.of(new UrlPictureSupplier(url));
    }

    public static PictureBuilder ofStream(InputStream inputStream, PictureType pictureType) {
        return Pictures.ofBytes(ByteUtils.toByteArray(inputStream), pictureType);
    }

    public static PictureBuilder ofStream(InputStream inputStream) {
        return Pictures.ofBytes(ByteUtils.toByteArray(inputStream));
    }

    public static PictureBuilder ofBufferedImage(BufferedImage image, PictureType pictureType) {
        return Pictures.of(() -> BufferedImageUtils.getBufferByteArray(image, pictureType.format()), pictureType);
    }

    public static PictureBuilder ofBase64(String base64, PictureType pictureType) {
        return Pictures.ofBytes(ByteUtils.getBase64ByteArray(base64), pictureType);
    }

    public static PictureBuilder ofBytes(byte[] bytes) {
        return Pictures.ofBytes(bytes, null);
    }

    public static PictureBuilder ofBytes(byte[] bytes, PictureType pictureType) {
        return new PictureBuilder(pictureType, new PictureSupplier(bytes));
    }

    public static PictureBuilder of(String imgUri) {
        if (imgUri.startsWith("http")) {
            return Pictures.ofUrl(imgUri);
        }
        return Pictures.ofLocal(imgUri);
    }

    public static PictureBuilder of(Supplier<byte[]> supplier) {
        return Pictures.of(supplier, null);
    }

    public static PictureBuilder of(Supplier<byte[]> supplier, PictureType pictureType) {
        return new PictureBuilder(pictureType, supplier);
    }

    public static class PictureBuilder
    implements RenderDataBuilder<PictureRenderData> {
        private PictureRenderData data;

        private PictureBuilder(PictureType pictureType, Supplier<byte[]> supplier) {
            this.data = new PictureRenderData(0, 0, pictureType, supplier);
        }

        public PictureBuilder size(int width, int height) {
            PictureStyle style = this.getPictureStyle();
            style.setWidth(width);
            style.setHeight(height);
            style.setScalePattern(WidthScalePattern.NONE);
            return this;
        }

        private PictureStyle getPictureStyle() {
            PictureStyle style = this.data.getPictureStyle();
            if (null == style) {
                style = new PictureStyle();
                this.data.setPictureStyle(style);
            }
            return style;
        }

        public PictureBuilder sizeInCm(double widthCm, double heightCm) {
            return this.size(UnitUtils.cm2Pixel(widthCm), UnitUtils.cm2Pixel(heightCm));
        }

        public PictureBuilder fitSize() {
            PictureStyle style = this.getPictureStyle();
            style.setScalePattern(WidthScalePattern.FIT);
            return this;
        }

        public PictureBuilder altMeta(String altMeta) {
            this.data.setAltMeta(altMeta);
            return this;
        }

        public PictureBuilder left() {
            PictureStyle style = this.getPictureStyle();
            style.setAlign(PictureStyle.PictureAlign.LEFT);
            return this;
        }

        public PictureBuilder center() {
            PictureStyle style = this.getPictureStyle();
            style.setAlign(PictureStyle.PictureAlign.CENTER);
            return this;
        }

        public PictureBuilder right() {
            PictureStyle style = this.getPictureStyle();
            style.setAlign(PictureStyle.PictureAlign.RIGHT);
            return this;
        }

        @Override
        public PictureRenderData create() {
            return this.data;
        }
    }

    public static class PictureSupplier
    implements Supplier<byte[]>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] bytes;

        public PictureSupplier(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte[] get() {
            return this.bytes;
        }
    }

    public static class UrlPictureSupplier
    implements Supplier<byte[]>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String url;

        public UrlPictureSupplier(String url) {
            this.url = url.replace("tp=webp", "tp=png");
        }

        @Override
        public byte[] get() {
            return ByteUtils.getUrlByteArray(this.url);
        }
    }

    public static class LocalPictureSupplier
    implements Supplier<byte[]>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String path;

        public LocalPictureSupplier(String path) {
            this.path = path;
        }

        @Override
        public byte[] get() {
            return ByteUtils.getLocalByteArray(new File(this.path));
        }
    }
}

