/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.util.ByteUtils;

public enum PictureType {
    EMF(2),
    WMF(3),
    PICT(4),
    JPEG(5),
    PNG(6),
    DIB(7),
    GIF(8),
    TIFF(9),
    EPS(10),
    BMP(11),
    WPG(12),
    SVG(13);

    private int type;

    private PictureType(int type) {
        this.type = type;
    }

    public int type() {
        return this.type;
    }

    public String format() {
        return super.name().toLowerCase();
    }

    public static PictureType suggestFileType(String imgFile) {
        PictureType format = null;
        if ((imgFile = imgFile.toLowerCase()).endsWith(".emf")) {
            format = EMF;
        } else if (imgFile.endsWith(".wmf")) {
            format = WMF;
        } else if (imgFile.endsWith(".pict")) {
            format = PICT;
        } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
            format = JPEG;
        } else if (imgFile.endsWith(".png")) {
            format = PNG;
        } else if (imgFile.endsWith(".dib")) {
            format = DIB;
        } else if (imgFile.endsWith(".gif")) {
            format = GIF;
        } else if (imgFile.endsWith(".tiff")) {
            format = TIFF;
        } else if (imgFile.endsWith(".eps")) {
            format = EPS;
        } else if (imgFile.endsWith(".bmp")) {
            format = BMP;
        } else if (imgFile.endsWith(".wpg")) {
            format = WPG;
        } else {
            throw new IllegalArgumentException("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
        }
        return format;
    }

    public static PictureType suggestFileType(byte[] bytes) {
        if (ByteUtils.startsWith(bytes, "GIF89a".getBytes()) || ByteUtils.startsWith(bytes, "GIF87a".getBytes())) {
            return GIF;
        }
        if (ByteUtils.startsWith(bytes, new byte[]{-1, -40}) || ByteUtils.endsWith(bytes, new byte[]{-1, -39})) {
            return JPEG;
        }
        if (ByteUtils.startsWith(bytes, new byte[]{-119, 80, 78, 71})) {
            return PNG;
        }
        if (ByteUtils.startsWith(bytes, new byte[]{73, 73, 42, 0}) || ByteUtils.startsWith(bytes, new byte[]{77, 77, 0, 42})) {
            return TIFF;
        }
        if (ByteUtils.startsWith(bytes, "BM".getBytes())) {
            return BMP;
        }
        String str = new String(bytes);
        if (str.substring(0, 100).indexOf("<svg") != -1 || str.substring(str.length() - 10).indexOf("</svg>") != -1) {
            return SVG;
        }
        throw new IllegalArgumentException("Unable to identify the picture type from byte");
    }
}

