/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics.link;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonAlias;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonValue;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLink;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLinkType;
import java.util.Objects;

public class CouchbaseRemoteAnalyticsLink
extends AnalyticsLink {
    @JsonProperty
    @JsonAlias(value={"activeHostname"})
    private String hostname;
    @JsonProperty
    private EncryptionLevel encryption;
    @JsonProperty
    private String username;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String password;
    @JsonProperty
    private String certificate;
    @JsonProperty
    private String clientCertificate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String clientKey;

    public CouchbaseRemoteAnalyticsLink(String name, String dataverse) {
        super(name, dataverse);
    }

    private CouchbaseRemoteAnalyticsLink() {
        super("", "");
    }

    public String hostname() {
        return this.hostname;
    }

    public CouchbaseRemoteAnalyticsLink hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public EncryptionLevel encryption() {
        return this.encryption;
    }

    public CouchbaseRemoteAnalyticsLink encryption(EncryptionLevel encryption) {
        this.encryption = encryption;
        return this;
    }

    public String username() {
        return this.username;
    }

    public CouchbaseRemoteAnalyticsLink username(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public CouchbaseRemoteAnalyticsLink password(String password) {
        this.password = password;
        return this;
    }

    public String certificate() {
        return this.certificate;
    }

    public CouchbaseRemoteAnalyticsLink certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    public String clientCertificate() {
        return this.clientCertificate;
    }

    public CouchbaseRemoteAnalyticsLink clientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return this;
    }

    public String clientKey() {
        return this.clientKey;
    }

    public CouchbaseRemoteAnalyticsLink clientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @Override
    public AnalyticsLinkType type() {
        return AnalyticsLinkType.COUCHBASE_REMOTE;
    }

    public String toString() {
        return "CouchbaseAnalyticsLink{encryption=" + (Object)((Object)this.encryption) + ", hostname='" + this.hostname + '\'' + ", username='" + this.username + '\'' + ", hasPassword=" + (this.password != null) + ", certificate='" + this.certificate + '\'' + ", clientCertificate='" + this.clientCertificate + '\'' + ", hasClientKey=" + (this.clientKey != null) + '}';
    }

    public static enum EncryptionLevel {
        NONE("none"),
        HALF("half"),
        FULL("full");

        private final String wireName;

        private EncryptionLevel(String wireName) {
            this.wireName = Objects.requireNonNull(wireName);
        }

        @JsonValue
        public String wireName() {
            return this.wireName;
        }
    }
}

