/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg.transaction;

import com.codingapi.txlcn.common.exception.FastStorageException;
import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.common.util.ApplicationInformation;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import com.codingapi.txlcn.tm.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tm.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.LCNCmdType;
import java.io.Serializable;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpc_clean-invalid-tm")
public class CleanInvalidTMExecuteService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(CleanInvalidTMExecuteService.class);
    private final FastStorage fastStorage;
    private static final TxLogger txLogger = TxLogger.newLogger(CleanInvalidTMExecuteService.class);

    @Autowired
    public CleanInvalidTMExecuteService(FastStorage fastStorage) {
        this.fastStorage = fastStorage;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        HashSet hashSet = (HashSet)transactionCmd.getMsg().loadBean(HashSet.class);
        for (Object address : hashSet) {
            String[] args = ApplicationInformation.splitAddress((String)address.toString());
            try {
                this.fastStorage.removeTMProperties(args[0], Integer.valueOf(args[1]));
            }
            catch (FastStorageException e) {
                txLogger.error(LCNCmdType.cleanInvalidTM.getName(), "Remove TM {} fail.", new Object[]{address});
            }
        }
        log.info("Clean invalid TM: {}", (Object)hashSet);
        return null;
    }
}

