/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg;

import com.codingapi.txlcn.common.runner.TxLcnInitializer;
import com.codingapi.txlcn.common.util.Transactions;
import com.codingapi.txlcn.common.util.id.IdGenInit;
import com.codingapi.txlcn.common.util.id.ModIdProvider;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.tm.support.service.ManagerService;
import com.codingapi.txlcn.txmsg.dto.RpcCmd;
import com.codingapi.txlcn.txmsg.listener.HeartbeatListener;
import com.codingapi.txlcn.txmsg.listener.RpcConnectionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EnsureIdGenEngine
implements RpcConnectionListener,
HeartbeatListener,
TxLcnInitializer {
    private final TxManagerConfig managerConfig;
    private final ManagerService managerService;
    private final TxLogger txLogger = TxLogger.newLogger(EnsureIdGenEngine.class);
    private final ModIdProvider modIdProvider;

    @Autowired
    public EnsureIdGenEngine(ManagerService managerService, TxManagerConfig managerConfig, ModIdProvider modIdProvider) {
        this.managerService = managerService;
        this.managerConfig = managerConfig;
        this.modIdProvider = modIdProvider;
    }

    public void connect(String remoteKey) {
    }

    public void disconnect(String remoteKey, String appName) {
    }

    public void init() throws Exception {
        this.managerConfig.applyMachineId(this.managerService.machineIdSync());
        IdGenInit.applyDefaultIdGen((int)this.managerConfig.getSeqLen(), (long)this.managerConfig.getMachineId());
        Transactions.setApplicationIdWhenRunning((String)this.modIdProvider.modId());
    }

    public void onTmReceivedHeart(RpcCmd cmd) {
        try {
            Long machineId = (Long)cmd.getMsg().loadBean(Long.class);
            this.managerService.refreshMachines(machineId, this.managerConfig.getMachineId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

