/*
 * Decompiled with CFR 0.152.
 */
package com.civiw.biz.ms.hd.civiwhdsdk.api;

import com.civiw.biz.ms.hd.civiwhdsdk.entity.ClueResult;
import com.civiw.biz.ms.hd.civiwhdsdk.entity.Token;
import com.civiw.biz.ms.hd.civiwhdsdk.util.MD5Util;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ClueOpenDataApi {
    private int maxTotalConnectionSize = 2000;
    private int defaultMaxPerRoute = 500;
    private int requestTimeout = 30000;
    private int connectTimeout = 30000;
    private int socketTimeout = 300000;
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String OAUTH2 = "oauth2 ";
    private static final String CIVIW_HD_BASE_URL = "https://biz.civiw.com/hd";
    private static final String CIVIW_HD_TOKEN_QUERY_URI = "/clue/open/authentication";
    private static final String CIVIW_HD_CLUE_QUERY_URL = "/clue/open";
    private static final String CIVIW_HD_CLUE_CONFIRM_URL = "/clue/open/confirm";
    private RestTemplate restTemplate;
    private Cache<String, Token> tokenCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).maximumSize(10L).build();

    public ClueOpenDataApi() {
        this.restTemplate = new RestTemplate(this.getDefaultClientHttpRequestFactory());
    }

    public ClueOpenDataApi(ClientHttpRequestFactory requestFactoryBuilder) {
        if (null == requestFactoryBuilder) {
            requestFactoryBuilder = this.getDefaultClientHttpRequestFactory();
        }
        this.restTemplate = new RestTemplate(requestFactoryBuilder);
    }

    private ClientHttpRequestFactory getDefaultClientHttpRequestFactory() {
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setSoLinger(0).setSoReuseAddress(true).setSoTimeout(this.socketTimeout).setTcpNoDelay(true).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.requestTimeout).build();
        PoolingHttpClientConnectionManager poolingManager = new PoolingHttpClientConnectionManager();
        poolingManager.setDefaultSocketConfig(socketConfig);
        poolingManager.setMaxTotal(this.maxTotalConnectionSize);
        poolingManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)poolingManager).setDefaultSocketConfig(socketConfig).setMaxConnTotal(this.maxTotalConnectionSize).setMaxConnPerRoute(this.defaultMaxPerRoute).setDefaultRequestConfig(requestConfig).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return 50L;
            }
        }).setConnectionReuseStrategy(new ConnectionReuseStrategy(){

            public boolean keepAlive(HttpResponse response, HttpContext context) {
                return true;
            }
        }).build();
        HttpComponentsClientHttpRequestFactory requestFactoryBuilder = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return requestFactoryBuilder;
    }

    public String getUserToken(String userName, String password, boolean refresh) {
        Token token = (Token)this.tokenCache.getIfPresent((Object)userName);
        if (null != token && this.tokenIsNotExpire(token) && !refresh) {
            return token.getAccessToken();
        }
        HttpHeaders headers = new HttpHeaders();
        LinkedMultiValueMap paramMap = new LinkedMultiValueMap(2);
        paramMap.add((Object)"userName", (Object)userName);
        paramMap.add((Object)"password", (Object)MD5Util.md5(password, 1));
        HttpEntity entity = new HttpEntity((Object)paramMap, (MultiValueMap)headers);
        String url = "https://biz.civiw.com/hd/clue/open/authentication";
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<Token>(){}, new Object[0]);
        if (null != responseEntity.getBody()) {
            this.tokenCache.put((Object)userName, responseEntity.getBody());
        }
        return ((Token)responseEntity.getBody()).getAccessToken();
    }

    private boolean tokenIsNotExpire(Token token) {
        return token.getExpireDate() > System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(3L);
    }

    public List<ClueResult> queryUnreadClueResult(String userName, String password, boolean refresh) throws Exception {
        String url = "https://biz.civiw.com/hd/clue/open";
        HttpHeaders headers = new HttpHeaders();
        String userToken = this.getUserToken(userName, password, refresh);
        headers.add(AUTHORIZATION_HEADER_NAME, OAUTH2 + userToken);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ClueResult>>(){}, new Object[0]);
        if (null == responseEntity.getBody()) {
            return Collections.emptyList();
        }
        return (List)responseEntity.getBody();
    }

    public Boolean confirmClueResult(String userName, String password, boolean refresh, List<String> clueIds) throws Exception {
        if (CollectionUtils.isEmpty(clueIds)) {
            return false;
        }
        String url = "https://biz.civiw.com/hd/clue/open/confirm";
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"clueIds", (Object)StringUtils.join(clueIds, (String)","));
        HttpHeaders headers = new HttpHeaders();
        String userToken = this.getUserToken(userName, password, refresh);
        headers.add(AUTHORIZATION_HEADER_NAME, OAUTH2 + userToken);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Boolean>(){}, new Object[0]);
        return (Boolean)responseEntity.getBody();
    }
}

