/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.log;

import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.runtime.log.LogSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLog4JLogSystem
implements LogSystem {
    private RuntimeServices rsvc = null;
    protected Logger logger = null;

    @Override
    public void init(RuntimeServices rs) {
        this.rsvc = rs;
        String categoryname = "bboss.org.apache.velocity";
        if (categoryname != null) {
            this.logger = LoggerFactory.getLogger((String)categoryname);
            this.logVelocityMessage(0, "SimpleLog4JLogSystem using category '" + categoryname + "'");
            return;
        }
        String logfile = this.rsvc.getString("runtime.log");
        try {
            this.internalInit(logfile);
            this.logVelocityMessage(0, "SimpleLog4JLogSystem initialized using logfile '" + logfile + "'");
        }
        catch (Exception e) {
            System.err.println("PANIC : error configuring SimpleLog4JLogSystem : " + e);
        }
    }

    private void internalInit(String logfile) throws Exception {
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }

    @Override
    public void logVelocityMessage(int level, String message) {
        switch (level) {
            case 2: {
                this.logger.warn(message);
                break;
            }
            case 1: {
                this.logger.info(message);
                break;
            }
            case 3: {
                this.logger.error(message);
                break;
            }
            default: {
                this.logger.debug(message);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void shutdown() {
    }
}

